/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ballerinalang.compiler.semantics.model;

import java.util.LinkedHashMap;
import java.util.Map;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BSymbol;
import org.wso2.ballerinalang.compiler.util.Name;

public class Scope
implements org.ballerinalang.model.Scope {
    private static final int DEFAULT_SIZE = 10;
    public static final ScopeEntry NOT_FOUND_ENTRY = new ScopeEntry(null, null);
    public BSymbol owner;
    public Map<Name, ScopeEntry> entries;

    public Scope(BSymbol owner) {
        this.owner = owner;
        this.entries = new LinkedHashMap<Name, ScopeEntry>(10);
    }

    private Scope(BSymbol owner, Map<Name, ScopeEntry> entries) {
        this.owner = owner;
        this.entries = entries;
    }

    public void define(Name name, BSymbol symbol) {
        ScopeEntry current = this.entries.get(name);
        if (current == null) {
            current = NOT_FOUND_ENTRY;
        }
        ScopeEntry newEntry = new ScopeEntry(symbol, current);
        this.entries.put(name, newEntry);
    }

    public ScopeEntry lookup(Name name) {
        ScopeEntry entry = this.entries.get(name);
        if (entry == null) {
            return NOT_FOUND_ENTRY;
        }
        return entry;
    }

    public static class ScopeEntry
    implements org.ballerinalang.model.ScopeEntry {
        public BSymbol symbol;
        public ScopeEntry next;

        public ScopeEntry(BSymbol symbol, ScopeEntry next) {
            this.symbol = symbol;
            this.next = next;
        }
    }
}

