/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ballerinalang.compiler.tree.types;

import java.util.Arrays;
import java.util.Collections;
import org.ballerinalang.model.tree.NodeKind;
import org.ballerinalang.model.tree.types.ArrayTypeNode;
import org.wso2.ballerinalang.compiler.tree.BLangNodeVisitor;
import org.wso2.ballerinalang.compiler.tree.types.BLangType;
import org.wso2.ballerinalang.compiler.tree.types.BLangUserDefinedType;

public class BLangArrayType
extends BLangType
implements ArrayTypeNode {
    public BLangType elemtype;
    public int dimensions;
    public int[] sizes = new int[0];

    @Override
    public BLangType getElementType() {
        return this.elemtype;
    }

    @Override
    public int getDimensions() {
        return this.dimensions;
    }

    @Override
    public int[] getSizes() {
        return this.sizes;
    }

    @Override
    public void accept(BLangNodeVisitor visitor) {
        visitor.visit(this);
    }

    public String toString() {
        StringBuilder[] sb = new StringBuilder[]{new StringBuilder(this.getTypeName())};
        if (this.sizes.length == 0) {
            Arrays.stream(this.sizes).forEach(size -> {
                if (size == -1) {
                    sb[0].append("[]");
                } else {
                    sb[0].append("[").append(size).append("]");
                }
            });
        } else {
            sb[0].append(String.join((CharSequence)"", Collections.nCopies(this.dimensions, "[]")));
        }
        return sb[0].toString();
    }

    @Override
    public NodeKind getKind() {
        return NodeKind.ARRAY_TYPE;
    }

    private String getTypeName() {
        return this.elemtype instanceof BLangUserDefinedType ? ((BLangUserDefinedType)this.elemtype).typeName.value : this.elemtype.toString();
    }
}

