/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.stdlib.ldap.nativeimpl;

import java.util.ArrayList;
import java.util.List;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.DirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.LdapName;
import javax.naming.ldap.Rdn;
import org.ballerinalang.jvm.BallerinaErrors;
import org.ballerinalang.jvm.values.ArrayValueImpl;
import org.ballerinalang.jvm.values.ErrorValue;
import org.ballerinalang.jvm.values.MapValue;
import org.ballerinalang.stdlib.ldap.CommonLdapConfiguration;
import org.ballerinalang.stdlib.ldap.util.LdapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetGroups {
    private static final Logger LOG = LoggerFactory.getLogger(GetGroups.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object getGroups(MapValue<?, ?> ldapConnection, String userName) {
        try {
            LdapUtils.setServiceName((String)ldapConnection.getNativeData("instanceId"));
            DirContext ldapConnectionContext = (DirContext)ldapConnection.getNativeData("connectionContext");
            CommonLdapConfiguration ldapConfiguration = (CommonLdapConfiguration)ldapConnection.getNativeData("ldapConfiguration");
            String[] externalRoles = GetGroups.doGetGroupsListOfUser(userName, ldapConfiguration, ldapConnectionContext);
            ArrayValueImpl arrayValueImpl = new ArrayValueImpl(externalRoles);
            return arrayValueImpl;
        }
        catch (NamingException | ErrorValue e) {
            ErrorValue errorValue = LdapUtils.createError(e.getMessage());
            return errorValue;
        }
        finally {
            LdapUtils.removeServiceName();
        }
    }

    private static String[] doGetGroupsListOfUser(String userName, CommonLdapConfiguration ldapAuthConfig, DirContext ldapConnectionContext) throws NamingException {
        List<String> searchBase = ldapAuthConfig.getGroupSearchBase();
        return GetGroups.getLDAPGroupsListOfUser(userName, searchBase, ldapAuthConfig, ldapConnectionContext);
    }

    private static String[] getLDAPGroupsListOfUser(String userName, List<String> searchBase, CommonLdapConfiguration ldapAuthConfig, DirContext ldapConnectionContext) throws NamingException {
        String membershipValue;
        if (userName == null) {
            throw BallerinaErrors.createError((String)"UserName value is null.");
        }
        SearchControls searchControls = new SearchControls();
        searchControls.setSearchScope(2);
        String searchFilter = ldapAuthConfig.getGroupNameListFilter();
        String roleNameProperty = ldapAuthConfig.getGroupNameAttribute();
        String membershipProperty = ldapAuthConfig.getMembershipAttribute();
        String nameInSpace = GetGroups.getNameInSpaceForUserName(userName, ldapAuthConfig, ldapConnectionContext);
        if (membershipProperty == null || membershipProperty.length() < 1) {
            throw BallerinaErrors.createError((String)"MembershipAttribute not set in configuration.");
        }
        if (nameInSpace != null) {
            LdapName ldn = new LdapName(nameInSpace);
            if ("memberUid".equals(ldapAuthConfig.getMembershipAttribute())) {
                List<Rdn> rdns = ldn.getRdns();
                membershipValue = rdns.get(rdns.size() - 1).getValue().toString();
            } else {
                membershipValue = GetGroups.escapeLdapNameForFilter(ldn);
            }
        } else {
            return new String[0];
        }
        searchFilter = "(&" + searchFilter + "(" + membershipProperty + "=" + membershipValue + "))";
        String[] returnedAttributes = new String[]{roleNameProperty};
        searchControls.setReturningAttributes(returnedAttributes);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Reading roles with the membershipProperty Property: " + membershipProperty);
        }
        List<String> list = GetGroups.getListOfNames(searchBase, searchFilter, searchControls, roleNameProperty, ldapConnectionContext);
        return list.toArray(new String[list.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<String> getListOfNames(List<String> searchBases, String searchFilter, SearchControls searchControls, String property, DirContext ldapConnectionContext) throws NamingException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Result for searchBase: " + searchBases + " searchFilter: " + searchFilter + " property:" + property + " appendDN: false");
        }
        ArrayList<String> names = new ArrayList<String>();
        NamingEnumeration<SearchResult> answer = null;
        try {
            for (String searchBase : searchBases) {
                answer = ldapConnectionContext.search(LdapUtils.escapeDNForSearch(searchBase), searchFilter, searchControls);
                while (answer.hasMoreElements()) {
                    Attribute attr;
                    SearchResult searchResult = answer.next();
                    if (searchResult.getAttributes() == null || (attr = searchResult.getAttributes().get(property)) == null) continue;
                    NamingEnumeration<?> vals = attr.getAll();
                    while (vals.hasMoreElements()) {
                        String name = (String)vals.nextElement();
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("Found user: " + name);
                        }
                        names.add(name);
                    }
                }
                if (!LOG.isDebugEnabled()) continue;
                for (String name : names) {
                    LOG.debug("Result  :  " + name);
                }
            }
        }
        finally {
            LdapUtils.closeNamingEnumeration(answer);
        }
        return names;
    }

    private static String getNameInSpaceForUserName(String userName, CommonLdapConfiguration ldapConfiguration, DirContext ldapConnectionContext) throws NamingException {
        return LdapUtils.getNameInSpaceForUsernameFromLDAP(userName, ldapConfiguration, ldapConnectionContext);
    }

    private static String escapeLdapNameForFilter(LdapName ldn) {
        if (ldn == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Received null value to escape special characters. Returning null");
            }
            return null;
        }
        StringBuilder escapedDN = new StringBuilder();
        for (int i = ldn.size() - 1; i > -1; --i) {
            escapedDN = escapedDN.append(GetGroups.escapeSpecialCharactersForFilterWithStarAsRegex(ldn.get(i)));
            if (i == 0) continue;
            escapedDN = escapedDN.append(",");
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Escaped DN value for filter : " + escapedDN.toString());
        }
        return escapedDN.toString();
    }

    private static String escapeSpecialCharactersForFilterWithStarAsRegex(String filter) {
        StringBuilder sb = new StringBuilder();
        block6: for (int i = 0; i < filter.length(); ++i) {
            char currentChar = filter.charAt(i);
            switch (currentChar) {
                case '\\': {
                    if (filter.charAt(i + 1) == '*') {
                        sb.append("\\2a");
                        ++i;
                        continue block6;
                    }
                    sb.append("\\5c");
                    continue block6;
                }
                case '(': {
                    sb.append("\\28");
                    continue block6;
                }
                case ')': {
                    sb.append("\\29");
                    continue block6;
                }
                case '\u0000': {
                    sb.append("\\00");
                    continue block6;
                }
                default: {
                    sb.append(currentChar);
                }
            }
        }
        return sb.toString();
    }
}

