/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.mime.nativeimpl;

import io.netty.handler.codec.http.DefaultHttpHeaders;
import io.netty.handler.codec.http.DefaultLastHttpContent;
import io.netty.handler.codec.http.HttpHeaders;
import java.util.List;
import java.util.TreeSet;
import org.ballerinalang.jvm.BallerinaErrors;
import org.ballerinalang.jvm.StringUtils;
import org.ballerinalang.jvm.types.BArrayType;
import org.ballerinalang.jvm.types.BTypes;
import org.ballerinalang.jvm.values.ArrayValue;
import org.ballerinalang.jvm.values.HandleValue;
import org.ballerinalang.jvm.values.ObjectValue;
import org.ballerinalang.jvm.values.api.BString;
import org.ballerinalang.jvm.values.api.BValueCreator;
import org.ballerinalang.mime.util.MimeUtil;

public class EntityHeaders {
    private static final BArrayType bArrayType = new BArrayType(BTypes.typeHandle);
    private static final BString HEADER_OPERATION_ERROR = StringUtils.fromString((String)"{ballerina/mime}InvalidHeaderOperation");
    private static final BString HEADER_NOT_FOUND_ERROR = StringUtils.fromString((String)"{ballerina/mime}HeaderNotFound");

    public static void addHeader(ObjectValue entityObj, String headerName, String headerValue, Object position) {
        if (headerName == null || headerValue == null) {
            return;
        }
        try {
            EntityHeaders.getOrCreateHeadersBasedOnPosition(entityObj, position).add(headerName, (Object)headerValue);
        }
        catch (IllegalArgumentException ex) {
            throw BallerinaErrors.createError((BString)HEADER_OPERATION_ERROR, (String)ex.getMessage());
        }
    }

    public static String getHeader(ObjectValue entityObj, String headerName, Object position) {
        HttpHeaders httpHeaders = EntityHeaders.getHeadersBasedOnPosition(entityObj, position);
        if (httpHeaders == null) {
            throw BallerinaErrors.createError((BString)HEADER_NOT_FOUND_ERROR, (String)"Http header does not exist");
        }
        if (httpHeaders.get(headerName) != null) {
            return httpHeaders.get(headerName);
        }
        throw BallerinaErrors.createError((BString)HEADER_NOT_FOUND_ERROR, (String)"Http header does not exist");
    }

    public static ArrayValue getHeaderNames(ObjectValue entityObj, Object position) {
        HttpHeaders httpHeaders = EntityHeaders.getHeadersBasedOnPosition(entityObj, position);
        Object[] handleValues = new HandleValue[]{};
        if (httpHeaders == null || httpHeaders.isEmpty()) {
            return (ArrayValue)BValueCreator.createArrayValue((Object[])handleValues, (BArrayType)bArrayType);
        }
        int i = 0;
        TreeSet distinctNames = new TreeSet(String.CASE_INSENSITIVE_ORDER);
        distinctNames.addAll(httpHeaders.names());
        handleValues = new HandleValue[distinctNames.size()];
        for (String headerName : distinctNames) {
            handleValues[i++] = new HandleValue((Object)headerName);
        }
        return (ArrayValue)BValueCreator.createArrayValue((Object[])handleValues, (BArrayType)bArrayType);
    }

    public static ArrayValue getHeaders(ObjectValue entityObj, String headerName, Object position) {
        HttpHeaders httpHeaders = EntityHeaders.getHeadersBasedOnPosition(entityObj, position);
        if (httpHeaders == null) {
            throw MimeUtil.createError("{ballerina/mime}HeaderNotFound", "Http header does not exist");
        }
        List headerValueList = httpHeaders.getAll(headerName);
        if (headerValueList == null) {
            throw MimeUtil.createError("{ballerina/mime}HeaderNotFound", "Http header does not exist");
        }
        int i = 0;
        Object[] handleValues = new HandleValue[headerValueList.size()];
        for (String headerValue : headerValueList) {
            handleValues[i] = new HandleValue((Object)headerValue);
            ++i;
        }
        return (ArrayValue)BValueCreator.createArrayValue((Object[])handleValues, (BArrayType)bArrayType);
    }

    public static boolean hasHeader(ObjectValue entityObj, String headerName, Object position) {
        HttpHeaders httpHeaders = EntityHeaders.getHeadersBasedOnPosition(entityObj, position);
        if (httpHeaders == null) {
            return false;
        }
        List headerValueList = httpHeaders.getAll(headerName);
        return headerValueList != null && !headerValueList.isEmpty();
    }

    public static void removeAllHeaders(ObjectValue entityObj, Object position) {
        HttpHeaders httpHeaders = EntityHeaders.getHeadersBasedOnPosition(entityObj, position);
        if (httpHeaders != null) {
            httpHeaders.clear();
        }
    }

    public static void removeHeader(ObjectValue entityObj, String headerName, Object position) {
        HttpHeaders httpHeaders = EntityHeaders.getHeadersBasedOnPosition(entityObj, position);
        if (httpHeaders != null) {
            httpHeaders.remove(headerName);
        }
    }

    public static void setHeader(ObjectValue entityObj, String headerName, String headerValue, Object position) {
        if (headerName == null || headerValue == null) {
            return;
        }
        try {
            EntityHeaders.getOrCreateHeadersBasedOnPosition(entityObj, position).set(headerName, (Object)headerValue);
        }
        catch (IllegalArgumentException ex) {
            throw BallerinaErrors.createError((BString)HEADER_OPERATION_ERROR, (String)ex.getMessage());
        }
    }

    private static HttpHeaders getHeadersBasedOnPosition(ObjectValue entityObj, Object position) {
        return position.equals("leading") ? (HttpHeaders)entityObj.getNativeData("entity_headers") : (HttpHeaders)entityObj.getNativeData("entity_trailer_headers");
    }

    private static HttpHeaders getOrCreateHeadersBasedOnPosition(ObjectValue entityObj, Object position) {
        return position.equals("leading") ? EntityHeaders.getHeaders(entityObj) : EntityHeaders.getTrailerHeaders(entityObj);
    }

    private static HttpHeaders getHeaders(ObjectValue entityObj) {
        DefaultHttpHeaders httpHeaders;
        if (entityObj.getNativeData("entity_headers") != null) {
            httpHeaders = (HttpHeaders)entityObj.getNativeData("entity_headers");
        } else {
            httpHeaders = new DefaultHttpHeaders();
            entityObj.addNativeData("entity_headers", (Object)httpHeaders);
        }
        return httpHeaders;
    }

    private static HttpHeaders getTrailerHeaders(ObjectValue entityObj) {
        HttpHeaders httpTrailerHeaders;
        if (entityObj.getNativeData("entity_trailer_headers") != null) {
            httpTrailerHeaders = (HttpHeaders)entityObj.getNativeData("entity_trailer_headers");
        } else {
            httpTrailerHeaders = new DefaultLastHttpContent().trailingHeaders();
            entityObj.addNativeData("entity_trailer_headers", (Object)httpTrailerHeaders);
        }
        return httpTrailerHeaders;
    }
}

