/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.mime.util;

import io.netty.handler.codec.http.DefaultHttpHeaders;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaders;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.activation.MimeType;
import javax.activation.MimeTypeParseException;
import org.ballerinalang.jvm.types.BMapType;
import org.ballerinalang.jvm.types.BType;
import org.ballerinalang.jvm.types.BTypes;
import org.ballerinalang.jvm.values.MapValue;
import org.ballerinalang.jvm.values.MapValueImpl;
import org.ballerinalang.jvm.values.ObjectValue;
import org.ballerinalang.mime.util.MimeUtil;
import org.jvnet.mimepull.Header;

public class HeaderUtil {
    private static final BMapType stringMapType = new BMapType(BTypes.typeString);

    public static MapValue<String, String> getParamMap(String headerValue) {
        MapValue<String, String> paramMap = null;
        if (headerValue.contains(";")) {
            HeaderUtil.extractValue(headerValue);
            List<String> paramList = Arrays.stream(headerValue.substring(headerValue.indexOf(";") + 1).split(";")).map(String::trim).collect(Collectors.toList());
            paramMap = HeaderUtil.validateParams(paramList) ? HeaderUtil.getHeaderParamMap(paramList) : HeaderUtil.getEmptyMap();
        } else {
            paramMap = HeaderUtil.getEmptyMap();
        }
        return paramMap;
    }

    public static String getHeaderValue(String headerValue) {
        return HeaderUtil.extractValue(headerValue.trim());
    }

    private static String extractValue(String headerValue) {
        String value = headerValue.substring(0, headerValue.indexOf(";")).trim();
        if (value.isEmpty()) {
            throw MimeUtil.createError("{ballerina/mime}InvalidHeaderValue", "invalid header value: " + headerValue);
        }
        return value;
    }

    private static boolean validateParams(List<String> paramList) {
        return paramList.size() != 1 || !paramList.get(0).isEmpty();
    }

    private static MapValue<String, String> getHeaderParamMap(List<String> paramList) {
        MapValue<String, String> paramMap = HeaderUtil.getEmptyMap();
        for (String param : paramList) {
            if (param.contains("=")) {
                String[] keyValuePair = param.split("=", 2);
                if (keyValuePair.length != 2 || keyValuePair[0].isEmpty() || keyValuePair[1].isEmpty()) {
                    throw MimeUtil.createError("{ballerina/mime}InvalidHeaderParam", "invalid header parameter: " + param);
                }
                paramMap.put((Object)keyValuePair[0].trim(), (Object)keyValuePair[1].trim());
                continue;
            }
            paramMap.put((Object)param.trim(), null);
        }
        return paramMap;
    }

    static boolean isHeaderExist(List<String> headers) {
        return headers != null && headers.get(0) != null && !headers.get(0).isEmpty();
    }

    static HttpHeaders setBodyPartHeaders(List<? extends Header> bodyPartHeaders, HttpHeaders httpHeaders) {
        for (Header header : bodyPartHeaders) {
            httpHeaders.add(header.getName(), (Object)header.getValue());
        }
        return httpHeaders;
    }

    public static String getHeaderValue(ObjectValue bodyPart, String headerName) {
        if (bodyPart.getNativeData("entity_headers") != null) {
            HttpHeaders httpHeaders = (HttpHeaders)bodyPart.getNativeData("entity_headers");
            return httpHeaders.get(headerName);
        }
        return null;
    }

    public static String appendHeaderParams(StringBuilder headerValue, MapValue map) {
        String[] keys;
        int index = 0;
        if (map != null && !map.isEmpty() && (keys = (String[])map.getKeys()).length != 0) {
            for (String key : keys) {
                String paramValue = HeaderUtil.getHeaderParamValue(map, key);
                if (index == keys.length - 1) {
                    headerValue.append(key).append("=").append(paramValue);
                    continue;
                }
                headerValue.append(key).append("=").append(paramValue).append(";");
                ++index;
            }
        }
        return headerValue.toString();
    }

    private static String getHeaderParamValue(MapValue map, String key) {
        String paramValue = (String)map.get((Object)key);
        if (HeaderUtil.containsSpecialCharacters(paramValue)) {
            paramValue = "\"" + paramValue + "\"";
        }
        return paramValue;
    }

    private static boolean containsSpecialCharacters(String headerValue) {
        return IntStream.range(0, headerValue.length()).anyMatch(i -> "\" ()<>@,;:/[]?=\\\"\"".contains(Character.toString(headerValue.charAt(i))));
    }

    public static boolean isMultipart(String contentType) {
        return contentType != null && contentType.startsWith("multipart/");
    }

    public static String extractBoundaryParameter(String contentType) {
        MapValue<String, String> paramMap = HeaderUtil.getParamMap(contentType);
        return paramMap.get((Object)"boundary") != null ? (String)paramMap.get((Object)"boundary") : null;
    }

    public static void setHeaderToEntity(ObjectValue entity, String key, String value) {
        DefaultHttpHeaders httpHeaders;
        if (entity.getNativeData("entity_headers") != null) {
            httpHeaders = (HttpHeaders)entity.getNativeData("entity_headers");
        } else {
            httpHeaders = new DefaultHttpHeaders();
            entity.addNativeData("entity_headers", (Object)httpHeaders);
        }
        httpHeaders.set(key, (Object)value);
    }

    public static String getBaseType(ObjectValue entityStruct) throws MimeTypeParseException {
        String contentType = HeaderUtil.getHeaderValue(entityStruct, HttpHeaderNames.CONTENT_TYPE.toString());
        if (contentType != null) {
            return new MimeType(contentType).getBaseType();
        }
        return null;
    }

    private static MapValue<String, String> getEmptyMap() {
        return new MapValueImpl((BType)stringMapType);
    }
}

