/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.mime.util;

import io.netty.handler.codec.http.HttpHeaderNames;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.security.SecureRandom;
import java.util.Enumeration;
import javax.activation.MimeType;
import javax.activation.MimeTypeParameterList;
import javax.activation.MimeTypeParseException;
import org.ballerinalang.jvm.BallerinaErrors;
import org.ballerinalang.jvm.BallerinaValues;
import org.ballerinalang.jvm.TypeChecker;
import org.ballerinalang.jvm.types.BArrayType;
import org.ballerinalang.jvm.types.BMapType;
import org.ballerinalang.jvm.types.BPackage;
import org.ballerinalang.jvm.types.BType;
import org.ballerinalang.jvm.types.BTypes;
import org.ballerinalang.jvm.values.ArrayValue;
import org.ballerinalang.jvm.values.ErrorValue;
import org.ballerinalang.jvm.values.MapValue;
import org.ballerinalang.jvm.values.MapValueImpl;
import org.ballerinalang.jvm.values.ObjectValue;
import org.ballerinalang.jvm.values.StreamingJsonValue;
import org.ballerinalang.jvm.values.utils.StringUtils;
import org.ballerinalang.mime.util.HeaderUtil;
import org.ballerinalang.mime.util.MimeConstants;
import org.ballerinalang.stdlib.io.utils.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.transport.http.netty.message.HttpCarbonMessage;

public class MimeUtil {
    private static final Logger LOG = LoggerFactory.getLogger(MimeUtil.class);

    public static String getBaseType(ObjectValue entity) {
        ObjectValue mediaType;
        if (entity.get("cType") != null && (mediaType = (ObjectValue)entity.get("cType")) != null) {
            return mediaType.get("primaryType").toString() + "/" + mediaType.get("subType").toString();
        }
        return null;
    }

    public static String getContentTypeWithParameters(ObjectValue entity) {
        if (entity.get("cType") == null) {
            return HeaderUtil.getHeaderValue(entity, HttpHeaderNames.CONTENT_TYPE.toString());
        }
        ObjectValue mediaType = (ObjectValue)entity.get("cType");
        String primaryType = String.valueOf(mediaType.get("primaryType"));
        String subType = String.valueOf(mediaType.get("subType"));
        String contentType = null;
        if (!primaryType.isEmpty() && !subType.isEmpty()) {
            contentType = primaryType + "/" + subType;
            if (mediaType.get("parameters") != null) {
                MapValue map;
                MapValue mapValue = map = mediaType.get("parameters") != null ? (MapValue)mediaType.get("parameters") : null;
                if (map != null && !map.isEmpty()) {
                    contentType = contentType + ";";
                    return HeaderUtil.appendHeaderParams(new StringBuilder(contentType), map);
                }
            }
        }
        return contentType;
    }

    public static String getContentTypeBParamValue(String contentType, String parameterName) {
        try {
            MimeType mimeType = new MimeType(contentType);
            MimeTypeParameterList parameterList = mimeType.getParameters();
            return parameterList.get(parameterName);
        }
        catch (MimeTypeParseException e) {
            throw MimeUtil.createError("{ballerina/mime}InvalidContentType", e.getMessage());
        }
    }

    public static String getContentTypeParamValue(String contentType, String parameterName) {
        try {
            MimeType mimeType = new MimeType(contentType);
            MimeTypeParameterList parameterList = mimeType.getParameters();
            return parameterList.get(parameterName);
        }
        catch (MimeTypeParseException e) {
            throw MimeUtil.createError("{ballerina/mime}InvalidContentType", e.getMessage());
        }
    }

    public static void setContentType(ObjectValue mediaType, ObjectValue entityStruct, String contentType) {
        ObjectValue mimeType = MimeUtil.parseMediaType(mediaType, contentType);
        if (contentType == null) {
            mimeType.set("primaryType", (Object)"application");
            mimeType.set("subType", (Object)"octet-stream");
        }
        entityStruct.set("cType", (Object)mimeType);
    }

    public static ObjectValue parseMediaType(ObjectValue mediaType, String contentType) {
        try {
            String suffix;
            String subType;
            String primaryType;
            MapValueImpl parameterMap = new MapValueImpl((BType)new BMapType(BTypes.typeString));
            if (contentType != null) {
                String subTypeStr;
                MimeType mimeType = new MimeType(contentType);
                primaryType = mimeType.getPrimaryType();
                subType = subTypeStr = mimeType.getSubType();
                suffix = subTypeStr != null && subTypeStr.contains("+") ? subTypeStr.substring(subTypeStr.lastIndexOf("+") + 1) : (String)BTypes.typeString.getZeroValue();
                MimeTypeParameterList parameterList = mimeType.getParameters();
                Enumeration keys = parameterList.getNames();
                while (keys.hasMoreElements()) {
                    String key = (String)keys.nextElement();
                    String value = parameterList.get(key);
                    parameterMap.put((Object)key, (Object)value);
                }
            } else {
                suffix = subType = (String)BTypes.typeString.getZeroValue();
                primaryType = subType;
            }
            mediaType.set("primaryType", (Object)primaryType);
            mediaType.set("subType", (Object)subType);
            mediaType.set("suffix", (Object)suffix);
            mediaType.set("parameters", (Object)parameterMap);
        }
        catch (MimeTypeParseException e) {
            throw new ErrorValue("{ballerina/mime}InvalidContentType", (Object)e.getMessage());
        }
        return mediaType;
    }

    public static void setMediaTypeToEntity(ObjectValue entityStruct, String contentType) {
        ObjectValue mediaType = BallerinaValues.createObjectValue((BPackage)MimeConstants.PROTOCOL_MIME_PKG_ID, (String)"MediaType", (Object[])new Object[0]);
        MimeUtil.setContentType(mediaType, entityStruct, contentType);
        HeaderUtil.setHeaderToEntity(entityStruct, HttpHeaderNames.CONTENT_TYPE.toString(), contentType);
    }

    public static void setContentDisposition(ObjectValue contentDisposition, ObjectValue bodyPart, String contentDispositionHeaderWithParams) {
        MimeUtil.populateContentDispositionObject(contentDisposition, contentDispositionHeaderWithParams);
        bodyPart.set("cDisposition", (Object)contentDisposition);
    }

    public static void populateContentDispositionObject(ObjectValue contentDisposition, String contentDispositionHeaderWithParams) {
        if (MimeUtil.isNotNullAndEmpty(contentDispositionHeaderWithParams)) {
            String dispositionValue = contentDispositionHeaderWithParams.contains(";") ? HeaderUtil.getHeaderValue(contentDispositionHeaderWithParams) : contentDispositionHeaderWithParams;
            contentDisposition.set("disposition", (Object)dispositionValue);
            MapValue<String, String> paramMap = HeaderUtil.getParamMap(contentDispositionHeaderWithParams);
            block8: for (Object key : paramMap.getKeys()) {
                String paramValue = (String)paramMap.get(key);
                switch (key.toString()) {
                    case "filename": {
                        contentDisposition.set("fileName", (Object)MimeUtil.stripQuotes(paramValue));
                        continue block8;
                    }
                    case "name": {
                        contentDisposition.set("name", (Object)MimeUtil.stripQuotes(paramValue));
                        continue block8;
                    }
                }
            }
            paramMap.remove((Object)"filename");
            paramMap.remove((Object)"name");
            contentDisposition.set("parameters", paramMap);
        }
    }

    public static String getContentDisposition(ObjectValue entity) {
        ObjectValue contentDispositionStruct;
        StringBuilder dispositionBuilder = new StringBuilder();
        if (entity.get("cDisposition") != null && (contentDispositionStruct = (ObjectValue)entity.get("cDisposition")) != null) {
            Object disposition = contentDispositionStruct.get("disposition");
            if (disposition == null || disposition.toString().isEmpty()) {
                String contentType = MimeUtil.getBaseType(entity);
                if (contentType != null && contentType.equals("multipart/form-data")) {
                    dispositionBuilder.append("form-data");
                }
            } else {
                dispositionBuilder.append(disposition);
            }
            if (!dispositionBuilder.toString().isEmpty()) {
                dispositionBuilder = MimeUtil.convertDispositionObjectToString(dispositionBuilder, contentDispositionStruct);
            }
        }
        return dispositionBuilder.toString();
    }

    public static StringBuilder convertDispositionObjectToString(StringBuilder dispositionBuilder, ObjectValue contentDispositionStruct) {
        String fileName;
        Object nameBVal = contentDispositionStruct.get("name");
        String name = nameBVal != null ? nameBVal.toString() : null;
        Object fileNameBVal = contentDispositionStruct.get("fileName");
        String string = fileName = fileNameBVal != null ? fileNameBVal.toString() : null;
        if (MimeUtil.isNotNullAndEmpty(name)) {
            MimeUtil.appendSemiColon(dispositionBuilder).append("name").append("=").append(MimeUtil.includeQuotes(name)).append(";");
        }
        if (MimeUtil.isNotNullAndEmpty(fileName)) {
            MimeUtil.appendSemiColon(dispositionBuilder).append("filename").append("=").append(MimeUtil.includeQuotes(fileName)).append(";");
        }
        if (contentDispositionStruct.get("parameters") != null) {
            MapValue map = (MapValue)contentDispositionStruct.get("parameters");
            HeaderUtil.appendHeaderParams(MimeUtil.appendSemiColon(dispositionBuilder), map);
        }
        if (dispositionBuilder.toString().endsWith(";")) {
            dispositionBuilder.setLength(dispositionBuilder.length() - 1);
        }
        return dispositionBuilder;
    }

    private static StringBuilder appendSemiColon(StringBuilder disposition) {
        if (!disposition.toString().endsWith(";")) {
            disposition.append(";");
        }
        return disposition;
    }

    public static void setContentLength(ObjectValue entityStruct, long length) {
        entityStruct.set("cLength", (Object)length);
    }

    public static void writeInputToOutputStream(InputStream inputStream, OutputStream outputStream) throws IOException {
        int len;
        byte[] buffer = new byte[8192];
        while ((len = inputStream.read(buffer)) != -1) {
            outputStream.write(buffer, 0, len);
        }
    }

    public static byte[] getByteArray(InputStream input) throws IOException {
        try (ByteArrayOutputStream output = new ByteArrayOutputStream();){
            int len;
            byte[] buffer = new byte[8192];
            while ((len = input.read(buffer)) != -1) {
                output.write(buffer, 0, len);
            }
            byte[] byArray = output.toByteArray();
            return byArray;
        }
    }

    public static boolean isNotNullAndEmpty(String textValue) {
        return textValue != null && !textValue.isEmpty();
    }

    public static String includeQuotes(String textValue) {
        if (!textValue.startsWith("\"")) {
            textValue = "\"" + textValue;
        }
        if (!textValue.endsWith("\"")) {
            textValue = textValue + "\"";
        }
        return textValue;
    }

    public static String stripQuotes(String textValue) {
        if (textValue.startsWith("\"")) {
            textValue = textValue.substring(1);
        }
        if (textValue.endsWith("\"")) {
            textValue = textValue.substring(0, textValue.length() - 1);
        }
        return textValue;
    }

    public static String getNewMultipartDelimiter() {
        SecureRandom random = new SecureRandom();
        return Long.toHexString(random.nextLong());
    }

    static boolean isNestedPartsAvailable(ObjectValue bodyPart) {
        String contentTypeOfChildPart = MimeUtil.getBaseType(bodyPart);
        return contentTypeOfChildPart != null && contentTypeOfChildPart.startsWith("multipart/") && bodyPart.getNativeData("body_parts") != null;
    }

    public static ErrorValue createError(String reason, String errMsg) {
        return BallerinaErrors.createError((String)reason, (MapValue)Utils.populateMimeErrorRecord(null, (String)errMsg));
    }

    public static ErrorValue createError(String reason, String errMsg, ErrorValue errorValue) {
        return BallerinaErrors.createError((String)reason, (MapValue)Utils.populateMimeErrorRecord((ErrorValue)errorValue, (String)errMsg));
    }

    public static boolean isJSONCompatible(BType type) {
        switch (type.getTag()) {
            case 1: 
            case 3: 
            case 5: 
            case 6: 
            case 7: {
                return true;
            }
            case 20: {
                return MimeUtil.isJSONCompatible(((BArrayType)type).getElementType());
            }
            case 15: {
                return MimeUtil.isJSONCompatible(((BMapType)type).getConstrainedType());
            }
        }
        return false;
    }

    public static String getMessageAsString(Object dataSource) {
        BType type = TypeChecker.getType((Object)dataSource);
        if (type.getTag() == 5) {
            return (String)dataSource;
        }
        if (type.getTag() == 20 && ((BArrayType)type).getElementType().getTag() == 2) {
            return new String(((ArrayValue)dataSource).getBytes(), StandardCharsets.UTF_8);
        }
        return StringUtils.getJsonString((Object)dataSource);
    }

    public static boolean generateAsJSON(Object value, ObjectValue entity) {
        if (value instanceof StreamingJsonValue) {
            return false;
        }
        return MimeUtil.parseAsJson(entity) && MimeUtil.isJSONCompatible(TypeChecker.getType((Object)value));
    }

    private static boolean parseAsJson(ObjectValue entity) {
        Object parseAsJson = entity.getNativeData("PARSE_AS_TEXT");
        return parseAsJson != null && (Boolean)entity.getNativeData("PARSE_AS_TEXT") != false;
    }

    public static boolean isValidateContentType(String contentType) {
        try {
            new MimeType(contentType);
        }
        catch (MimeTypeParseException e) {
            return false;
        }
        return true;
    }

    public static long extractContentLength(HttpCarbonMessage httpCarbonMessage) {
        long contentLength = -1L;
        String lengthStr = httpCarbonMessage.getHeader(HttpHeaderNames.CONTENT_LENGTH.toString());
        try {
            long l = contentLength = lengthStr != null ? Long.parseLong(lengthStr) : contentLength;
            if (contentLength == -1L) {
                contentLength = httpCarbonMessage.countMessageLengthTill(1L);
            }
        }
        catch (NumberFormatException e) {
            throw MimeUtil.createError("{ballerina/mime}InvalidContentLength", "Invalid content length");
        }
        return contentLength;
    }

    public static void closeOutputStream(OutputStream outputStream) throws IOException {
        if (outputStream != null) {
            outputStream.close();
        }
    }
}

