/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.observe.nativeimpl;

import java.util.Set;
import org.ballerinalang.jvm.BallerinaValues;
import org.ballerinalang.jvm.observability.metrics.Counter;
import org.ballerinalang.jvm.observability.metrics.DefaultMetricRegistry;
import org.ballerinalang.jvm.observability.metrics.Gauge;
import org.ballerinalang.jvm.observability.metrics.Metric;
import org.ballerinalang.jvm.observability.metrics.MetricId;
import org.ballerinalang.jvm.observability.metrics.PolledGauge;
import org.ballerinalang.jvm.observability.metrics.Tag;
import org.ballerinalang.jvm.scheduling.Strand;
import org.ballerinalang.jvm.types.BArrayType;
import org.ballerinalang.jvm.types.BMapType;
import org.ballerinalang.jvm.types.BPackage;
import org.ballerinalang.jvm.types.BType;
import org.ballerinalang.jvm.types.BTypes;
import org.ballerinalang.jvm.values.ArrayValue;
import org.ballerinalang.jvm.values.ArrayValueImpl;
import org.ballerinalang.jvm.values.MapValue;
import org.ballerinalang.jvm.values.MapValueImpl;
import org.ballerinalang.model.types.TypeKind;
import org.ballerinalang.natives.annotations.BallerinaFunction;
import org.ballerinalang.natives.annotations.ReturnType;
import org.ballerinalang.observe.nativeimpl.ObserveNativeImplConstants;
import org.ballerinalang.observe.nativeimpl.Utils;

@BallerinaFunction(orgName="ballerina", packageName="observe", functionName="getAllMetrics", returnType={@ReturnType(type=TypeKind.ARRAY)}, isPublic=true)
public class GetAllMetrics {
    private static final BType METRIC_TYPE = BallerinaValues.createRecordValue((BPackage)ObserveNativeImplConstants.OBSERVE_PACKAGE_ID, (String)"Metric").getType();

    public static ArrayValue getAllMetrics(Strand strand) {
        Metric[] metrics = DefaultMetricRegistry.getInstance().getAllMetrics();
        ArrayValueImpl bMetrics = new ArrayValueImpl(new BArrayType(METRIC_TYPE));
        int metricIndex = 0;
        for (Metric metric : metrics) {
            Gauge gauge;
            MetricId metricId = metric.getId();
            Number metricValue = null;
            String metricType = null;
            ArrayValue summary = null;
            if (metric instanceof Counter) {
                metricValue = ((Counter)metric).getValue();
                metricType = "counter";
            } else if (metric instanceof Gauge) {
                gauge = (Gauge)metric;
                metricValue = gauge.getValue();
                metricType = "gauge";
                summary = Utils.createBSnapshots(gauge.getSnapshots(), strand);
            } else if (metric instanceof PolledGauge) {
                gauge = (PolledGauge)metric;
                metricValue = gauge.getValue();
                metricType = "gauge";
            }
            if (metricValue == null) continue;
            MapValue metricStruct = BallerinaValues.createRecordValue((BPackage)ObserveNativeImplConstants.OBSERVE_PACKAGE_ID, (String)"Metric");
            metricStruct.put((Object)"name", (Object)metricId.getName());
            metricStruct.put((Object)"desc", (Object)metricId.getDescription());
            metricStruct.put((Object)"tags", GetAllMetrics.getTags(metricId));
            metricStruct.put((Object)"metricType", (Object)metricType);
            metricStruct.put((Object)"value", (Object)metricValue);
            metricStruct.put((Object)"summary", (Object)summary);
            bMetrics.add((long)metricIndex, (Object)metricStruct);
            ++metricIndex;
        }
        return bMetrics;
    }

    private static MapValue<String, Object> getTags(MetricId metricId) {
        MapValueImpl bTags = new MapValueImpl((BType)new BMapType(BTypes.typeString));
        Set tags = metricId.getTags();
        for (Tag tag : tags) {
            bTags.put((Object)tag.getKey(), (Object)tag.getValue());
        }
        return bTags;
    }
}

