/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.packerina;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import java.util.Optional;
import java.util.Scanner;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.ballerinalang.compiler.BLangCompilerException;
import org.ballerinalang.model.elements.PackageID;
import org.ballerinalang.packerina.BrowserLauncher;
import org.ballerinalang.spi.EmbeddedExecutor;
import org.ballerinalang.toml.model.Manifest;
import org.ballerinalang.toml.model.Settings;
import org.ballerinalang.toml.parser.ManifestProcessor;
import org.ballerinalang.toml.parser.SettingsProcessor;
import org.ballerinalang.util.EmbeddedExecutorProvider;
import org.wso2.ballerinalang.compiler.packaging.Patten;
import org.wso2.ballerinalang.compiler.packaging.converters.Converter;
import org.wso2.ballerinalang.compiler.packaging.repo.RemoteRepo;
import org.wso2.ballerinalang.compiler.util.Name;
import org.wso2.ballerinalang.util.RepoUtils;

public class PushUtils {
    private static final Path BALLERINA_HOME_PATH = RepoUtils.createAndGetHomeReposPath();
    private static final Path SETTINGS_TOML_FILE_PATH = BALLERINA_HOME_PATH.resolve("Settings.toml");
    public static final String BALLERINA_CENTRAL_CLI_TOKEN = "https://central.ballerina.io/cli-token";
    public static final PrintStream SYS_ERR = System.err;
    private static PrintStream outStream = System.err;
    private static EmbeddedExecutor executor = EmbeddedExecutorProvider.getInstance().getExecutor();

    public static void pushPackages(String packageName, String installToRepo) {
        Manifest manifest = PushUtils.readManifestConfigurations();
        if (manifest.getName().isEmpty()) {
            throw new BLangCompilerException("An org-name is required when pushing. This is not specified in Ballerina.toml inside the project");
        }
        if (manifest.getVersion().isEmpty()) {
            throw new BLangCompilerException("A package version is required when pushing. This is not specified in Ballerina.toml inside the project");
        }
        String orgName = manifest.getName();
        String version = manifest.getVersion();
        PackageID packageID = new PackageID(new Name(orgName), new Name(packageName), new Name(version));
        Path prjDirPath = Paths.get(".", new String[0]).toAbsolutePath().normalize();
        Path pkgPathFromPrjtDir = Paths.get(prjDirPath.toString(), ".ballerina", "repo", orgName, packageName, version, packageName + ".zip");
        if (Files.notExists(pkgPathFromPrjtDir, new LinkOption[0])) {
            throw new BLangCompilerException("package does not exist");
        }
        if (installToRepo == null) {
            String accessToken = PushUtils.checkAccessToken();
            String mdFileContent = PushUtils.getPackageMDFileContent(pkgPathFromPrjtDir.toString(), packageName);
            if (mdFileContent == null) {
                throw new BLangCompilerException("Cannot find Package.md file in the artifact");
            }
            String description = PushUtils.readSummary(mdFileContent);
            String homepageURL = manifest.getHomepageURL();
            String repositoryURL = manifest.getRepositoryURL();
            String apiDocURL = manifest.getDocumentationURL();
            String authors = String.join((CharSequence)",", manifest.getAuthors());
            String keywords = String.join((CharSequence)",", manifest.getKeywords());
            String license = manifest.getLicense();
            String resourcePath = PushUtils.resolvePkgPathInRemoteRepo(packageID);
            String msg = orgName + "/" + packageName + ":" + version + " [project repo -> central]";
            executor.execute("packaging_push/packaging_push.balx", true, new String[]{accessToken, mdFileContent, description, homepageURL, repositoryURL, apiDocURL, authors, keywords, license, resourcePath, pkgPathFromPrjtDir.toString(), msg});
        } else {
            if (!installToRepo.equals("home")) {
                throw new BLangCompilerException("Unknown repository provided to push the package");
            }
            PushUtils.installToHomeRepo(packageID, pkgPathFromPrjtDir);
        }
    }

    private static String checkAccessToken() {
        String accessToken = PushUtils.getAccessTokenOfCLI();
        if (accessToken.isEmpty()) {
            try {
                SYS_ERR.println("Opening the web browser to https://central.ballerina.io/cli-token for auto token update ...");
                BrowserLauncher.startInDefaultBrowser(BALLERINA_CENTRAL_CLI_TOKEN);
            }
            catch (IOException e) {
                throw new BLangCompilerException("Access token is missing in " + SETTINGS_TOML_FILE_PATH.toString() + "\nAuto update failed. Please visit https://central.ballerina.io");
            }
            long modifiedTimeOfFileAtStart = PushUtils.getLastModifiedTimeOfFile(SETTINGS_TOML_FILE_PATH);
            executor.execute("packaging_token_updater/packaging_token_updater.balx", false, new String[0]);
            boolean waitForToken = true;
            while (waitForToken) {
                PushUtils.pause();
                long modifiedTimeOfFileAfter = PushUtils.getLastModifiedTimeOfFile(SETTINGS_TOML_FILE_PATH);
                if (modifiedTimeOfFileAtStart == modifiedTimeOfFileAfter) continue;
                accessToken = PushUtils.getAccessTokenOfCLI();
                if (accessToken.isEmpty()) {
                    throw new BLangCompilerException("Access token is missing in " + SETTINGS_TOML_FILE_PATH.toString() + "\nPlease " + "visit https://central.ballerina.io");
                }
                waitForToken = false;
            }
        }
        return accessToken;
    }

    private static void pause() {
        try {
            Thread.sleep(3000L);
        }
        catch (InterruptedException ex) {
            throw new BLangCompilerException("Error occurred when getting the access token");
        }
    }

    private static long getLastModifiedTimeOfFile(Path path) {
        if (!Files.isRegularFile(path, new LinkOption[0])) {
            return -1L;
        }
        try {
            return Files.getLastModifiedTime(path, new LinkOption[0]).toMillis();
        }
        catch (IOException ex) {
            throw new BLangCompilerException("Error occurred when reading file for token " + SETTINGS_TOML_FILE_PATH.toString());
        }
    }

    private static void installToHomeRepo(PackageID packageID, Path pkgPathFromPrjtDir) {
        Path targetDirectoryPath = Paths.get(BALLERINA_HOME_PATH.toString(), "repo", packageID.orgName.getValue(), packageID.name.getValue(), packageID.version.getValue(), packageID.name.getValue() + ".zip");
        if (Files.exists(targetDirectoryPath, new LinkOption[0])) {
            throw new BLangCompilerException("Ballerina package exists in the home repository");
        }
        try {
            Files.createDirectories(targetDirectoryPath, new FileAttribute[0]);
            Files.copy(pkgPathFromPrjtDir, targetDirectoryPath, StandardCopyOption.REPLACE_EXISTING);
            outStream.println(packageID.orgName.getValue() + "/" + packageID.name.getValue() + ":" + packageID.version.getValue() + " [project repo -> home repo]");
        }
        catch (IOException e) {
            throw new BLangCompilerException("Error occurred when creating directories in the home repository");
        }
    }

    private static String resolvePkgPathInRemoteRepo(PackageID packageID) {
        RemoteRepo remoteRepo = new RemoteRepo(URI.create(RepoUtils.getRemoteRepoURL()));
        Patten patten = remoteRepo.calculate(packageID);
        if (patten == Patten.NULL) {
            throw new BLangCompilerException("Couldn't find package " + packageID.toString());
        }
        Converter converter = remoteRepo.getConverterInstance();
        List uris = patten.convert(converter).collect(Collectors.toList());
        if (uris.isEmpty()) {
            throw new BLangCompilerException("Couldn't find package " + packageID.toString());
        }
        return ((URI)uris.get(0)).toString();
    }

    private static Manifest readManifestConfigurations() {
        String tomlFilePath = Paths.get(".", new String[0]).toAbsolutePath().normalize().resolve("Ballerina.toml").toString();
        try {
            return ManifestProcessor.parseTomlContentFromFile((String)tomlFilePath);
        }
        catch (IOException e) {
            return new Manifest();
        }
    }

    private static Settings readSettings() {
        String tomlFilePath = SETTINGS_TOML_FILE_PATH.toString();
        try {
            return SettingsProcessor.parseTomlContentFromFile((String)tomlFilePath);
        }
        catch (IOException e) {
            return new Settings();
        }
    }

    private static String getAccessTokenOfCLI() {
        Settings settings = PushUtils.readSettings();
        if (settings.getCentral() != null) {
            return settings.getCentral().getAccessToken();
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getPackageMDFileContent(String archivedFilePath, String packageName) {
        ZipFile zipFile = null;
        try {
            zipFile = new ZipFile(archivedFilePath);
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            while (true) {
                if (entries.hasMoreElements()) {
                    ZipEntry entry = entries.nextElement();
                    if (!entry.getName().equalsIgnoreCase(packageName + "/" + "Package.md")) continue;
                    InputStream stream = zipFile.getInputStream(entry);
                    Scanner scanner = new Scanner(stream, "UTF-8").useDelimiter("\\A");
                    String string = scanner.hasNext() ? scanner.next() : "";
                    return string;
                    continue;
                }
                break;
            }
        }
        catch (IOException iOException) {
        }
        finally {
            try {
                if (zipFile != null) {
                    zipFile.close();
                }
            }
            catch (IOException iOException) {}
        }
        return null;
    }

    private static String readSummary(String mdFileContent) {
        if (mdFileContent.isEmpty()) {
            throw new BLangCompilerException("Package.md in the artifact is empty");
        }
        Optional<String> result = Arrays.asList(mdFileContent.split("\n")).stream().filter(line -> !line.isEmpty() && !line.startsWith("#")).findFirst();
        if (!result.isPresent()) {
            throw new BLangCompilerException("Cannot find package summary");
        }
        String firstLine = result.get();
        if (firstLine.length() > 50) {
            throw new BLangCompilerException("Summary of the package exceeds 50 characters");
        }
        return firstLine;
    }
}

