/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.packerina;

import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryNotEmptyException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import org.ballerinalang.compiler.CompilerOptionName;
import org.ballerinalang.compiler.CompilerPhase;
import org.ballerinalang.util.program.BLangPrograms;
import org.wso2.ballerinalang.compiler.Compiler;
import org.wso2.ballerinalang.compiler.util.CompilerContext;
import org.wso2.ballerinalang.compiler.util.CompilerOptions;

public class UserRepositoryUtils {
    public static Path initializeUserRepository() {
        Path userRepoPath = UserRepositoryUtils.getUserRepositoryPath();
        Path artifactsDirPath = userRepoPath.resolve("artifacts");
        Path srcDirPath = artifactsDirPath.resolve("src");
        Path objDirPath = artifactsDirPath.resolve("obj");
        BLangPrograms.createDirectory((Path)userRepoPath);
        BLangPrograms.createDirectory((Path)artifactsDirPath);
        BLangPrograms.createDirectory((Path)srcDirPath);
        BLangPrograms.createDirectory((Path)objDirPath);
        return userRepoPath;
    }

    public static Path getUserRepositoryPath() {
        Path userRepoPath;
        String userRepoDir = System.getenv("BALLERINA_REPOSITORY");
        if (userRepoDir == null || userRepoDir.isEmpty()) {
            String userHomeDir = System.getProperty("user.home");
            if (userHomeDir == null || userHomeDir.isEmpty()) {
                throw new RuntimeException("error creating user repository: unable to get user home directory");
            }
            userRepoPath = Paths.get(userHomeDir, ".ballerina");
        } else {
            userRepoPath = Paths.get(userRepoDir, new String[0]);
        }
        userRepoPath = userRepoPath.toAbsolutePath();
        if (Files.exists(userRepoPath, new LinkOption[0]) && !Files.isDirectory(userRepoPath, LinkOption.NOFOLLOW_LINKS)) {
            throw new RuntimeException("user repository is not a directory: " + userRepoPath.toString());
        }
        return userRepoPath;
    }

    public static void installSourcePackage(Path sourceRootPath, String packageStr) {
        Path packagePath = Paths.get(packageStr, new String[0]);
        CompilerContext context = new CompilerContext();
        CompilerOptions cOptions = CompilerOptions.getInstance((CompilerContext)context);
        cOptions.put(CompilerOptionName.PROJECT_DIR, sourceRootPath.toString());
        cOptions.put(CompilerOptionName.COMPILER_PHASE, CompilerPhase.CODE_GEN.toString());
        cOptions.put(CompilerOptionName.PRESERVE_WHITESPACE, "false");
        Compiler compiler = Compiler.getInstance((CompilerContext)context);
        compiler.compile(packagePath.toString());
        Path srcDirectoryPath = BLangPrograms.validateAndResolveSourcePath((Path)sourceRootPath, (Path)packagePath);
        Path targetDirectoryPath = UserRepositoryUtils.initializeUserRepository().resolve("artifacts").resolve("src").resolve(packagePath);
        try {
            Files.list(srcDirectoryPath).filter(filePath -> !Files.isDirectory(filePath, LinkOption.NOFOLLOW_LINKS)).filter(filePath -> filePath.toString().endsWith(".bal")).forEach(filePath -> {
                Path srcNamePath = filePath.getFileName();
                Path targetFilePath = targetDirectoryPath.resolve(srcNamePath);
                CopyOption[] options = new CopyOption[]{StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.COPY_ATTRIBUTES, LinkOption.NOFOLLOW_LINKS};
                try {
                    if (Files.exists(targetDirectoryPath, LinkOption.NOFOLLOW_LINKS) && !Files.isDirectory(targetDirectoryPath, LinkOption.NOFOLLOW_LINKS)) {
                        throw new RuntimeException("a file exists with the same name as the package name: " + targetDirectoryPath.toString());
                    }
                    if (!Files.exists(targetDirectoryPath, LinkOption.NOFOLLOW_LINKS)) {
                        Files.createDirectories(targetDirectoryPath, new FileAttribute[0]);
                    }
                    Files.copy(filePath, targetFilePath, options);
                }
                catch (IOException e) {
                    throw new RuntimeException("error installing package: " + packageStr + ": " + e.getMessage(), e);
                }
            });
        }
        catch (IOException e) {
            throw new RuntimeException("error installing package: " + packageStr + ": " + e.getMessage(), e);
        }
    }

    public static void uninstallSourcePackage(String packageStr) {
        Path packagePath = Paths.get(packageStr, new String[0]);
        Path userRepoSrcPath = UserRepositoryUtils.initializeUserRepository().resolve("artifacts").resolve("src");
        Path dirPathToDelete = userRepoSrcPath.resolve(packagePath);
        if (Files.exists(dirPathToDelete, LinkOption.NOFOLLOW_LINKS) && !Files.isDirectory(dirPathToDelete, LinkOption.NOFOLLOW_LINKS)) {
            throw new RuntimeException("a file exists with the same name as the package name: " + dirPathToDelete.toString());
        }
        if (!Files.exists(dirPathToDelete, LinkOption.NOFOLLOW_LINKS)) {
            throw new RuntimeException("package does not exist: " + dirPathToDelete.toString());
        }
        try {
            Files.list(dirPathToDelete).filter(filePath -> !Files.isDirectory(filePath, LinkOption.NOFOLLOW_LINKS)).filter(filePath -> filePath.toString().endsWith(".bal")).forEach(filePath -> {
                try {
                    Files.delete(filePath);
                }
                catch (IOException e) {
                    throw new RuntimeException("error uninstalling package: " + packageStr + ": " + e.getMessage(), e);
                }
            });
            UserRepositoryUtils.deleteEmptyDirsUpTo(dirPathToDelete, userRepoSrcPath);
        }
        catch (DirectoryNotEmptyException e) {
            throw new RuntimeException("error uninstalling package: " + packageStr + ": directory not empty: " + dirPathToDelete.toString(), e);
        }
        catch (IOException e) {
            throw new RuntimeException("error uninstalling package: " + packageStr + ": " + e.getMessage(), e);
        }
    }

    private static void deleteEmptyDirsUpTo(Path from, Path to) throws IOException {
        Path pathsInBetween = to.relativize(from);
        for (int i = pathsInBetween.getNameCount(); i > 0; --i) {
            Path toRemove = to.resolve(pathsInBetween.subpath(0, i));
            if (Files.list(toRemove).findAny().isPresent()) {
                return;
            }
            Files.delete(toRemove);
        }
    }
}

