/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.packerina.cmd;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import java.io.PrintStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import org.ballerinalang.launcher.BLauncherCmd;
import org.ballerinalang.launcher.LauncherUtils;
import org.ballerinalang.packerina.BuilderUtils;

@Parameters(commandNames={"build"}, commandDescription="compile Ballerina program")
public class BuildCommand
implements BLauncherCmd {
    private static final String USER_DIR = "user.dir";
    private static PrintStream outStream = System.err;
    private JCommander parentCmdParser;
    @Parameter(names={"-c"}, description="build a compiled package")
    private boolean buildCompiledPkg;
    @Parameter(names={"-o"}, description="write output to the given file")
    private String outputFileName;
    @Parameter(names={"--offline"})
    private boolean offline;
    @Parameter(arity=1)
    private List<String> argList;
    @Parameter(names={"--help", "-h"}, hidden=true)
    private boolean helpFlag;
    @Parameter(names={"--java.debug"}, hidden=true)
    private String debugPort;

    public void execute() {
        if (this.helpFlag) {
            String commandUsageInfo = BLauncherCmd.getCommandUsageInfo((JCommander)this.parentCmdParser, (String)"build");
            outStream.println(commandUsageInfo);
            return;
        }
        if (this.argList != null && this.argList.size() > 1) {
            throw LauncherUtils.createUsageException((String)"too many arguments");
        }
        Path sourceRootPath = Paths.get(System.getProperty(USER_DIR), new String[0]);
        if (this.argList == null || this.argList.size() == 0) {
            BuilderUtils.compileAndWrite(sourceRootPath, this.offline);
        } else {
            String pkgName = this.argList.get(0);
            if (pkgName.endsWith("/")) {
                pkgName = pkgName.substring(0, pkgName.length() - 1);
            }
            String targetFileName = this.outputFileName != null && !this.outputFileName.isEmpty() ? this.outputFileName : pkgName;
            BuilderUtils.compileAndWrite(sourceRootPath, pkgName, targetFileName, this.buildCompiledPkg, this.offline);
        }
        Runtime.getRuntime().exit(0);
    }

    public String getName() {
        return "build";
    }

    public void printLongDesc(StringBuilder out) {
        out.append("Compiles Ballerina sources and writes the output to a file. \n");
        out.append("\n");
        out.append("By default, output filename is the last part of packagename \n");
        out.append("or the filename (minus the extension) with the extension \".balx\". \n");
        out.append("\n");
        out.append("If the output file is specified with the -o flag, the output \n");
        out.append("will be written to that file. \n");
    }

    public void printUsage(StringBuilder out) {
        out.append("  ballerina build <balfile | packagename> [-o output] \n");
    }

    public void setParentCmdParser(JCommander parentCmdParser) {
        this.parentCmdParser = parentCmdParser;
    }

    public void setSelfCmdParser(JCommander selfCmdParser) {
    }
}

