/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.packerina.cmd;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.charset.Charset;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Scanner;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.ballerinalang.launcher.BLauncherCmd;
import org.ballerinalang.packerina.init.InitHandler;
import org.ballerinalang.packerina.init.models.FileType;
import org.ballerinalang.packerina.init.models.PackageMdFile;
import org.ballerinalang.packerina.init.models.SrcFile;
import org.ballerinalang.toml.model.Manifest;

@Parameters(commandNames={"init"}, commandDescription="initialize ballerina project")
public class InitCommand
implements BLauncherCmd {
    public static final String DEFAULT_VERSION = "0.0.1";
    private static final String USER_DIR = "user.dir";
    private static final PrintStream outStream = System.err;
    private JCommander parentCmdParser;
    @Parameter(names={"--interactive", "-i"})
    private boolean interactiveFlag;
    @Parameter(names={"--help", "-h"}, hidden=true)
    private boolean helpFlag;

    private static boolean isDirEmpty(Path directory) throws IOException {
        try (DirectoryStream<Path> dirStream = Files.newDirectoryStream(directory);){
            boolean bl = !dirStream.iterator().hasNext();
            return bl;
        }
    }

    public void execute() {
        PrintStream out = System.out;
        Path projectPath = Paths.get(System.getProperty(USER_DIR), new String[0]);
        Scanner scanner = new Scanner(System.in, Charset.defaultCharset().name());
        try {
            Manifest manifest = null;
            if (this.helpFlag) {
                String commandUsageInfo = BLauncherCmd.getCommandUsageInfo((JCommander)this.parentCmdParser, (String)"init");
                outStream.println(commandUsageInfo);
                return;
            }
            ArrayList<SrcFile> sourceFiles = new ArrayList<SrcFile>();
            ArrayList<PackageMdFile> packageMdFiles = new ArrayList<PackageMdFile>();
            if (this.interactiveFlag) {
                out.print("Create Ballerina.toml [yes/y, no/n]: (n) ");
                String createToml = scanner.nextLine().trim();
                if (createToml.equalsIgnoreCase("yes") || createToml.equalsIgnoreCase("y")) {
                    String version;
                    manifest = new Manifest();
                    String defaultOrg = this.guessOrgName();
                    out.print("Organization name: (" + defaultOrg + ") ");
                    String orgName = scanner.nextLine().trim();
                    manifest.setName(orgName.isEmpty() ? defaultOrg : orgName);
                    do {
                        out.print("Version: (0.0.1) ");
                        version = scanner.nextLine().trim();
                    } while (!this.validateVersion(out, version = version.isEmpty() ? DEFAULT_VERSION : version));
                    manifest.setVersion(version);
                }
                boolean validInput = false;
                boolean first = true;
                do {
                    PackageMdFile packageMdFile;
                    SrcFile srcFile;
                    String packageName;
                    if (first) {
                        out.print("Ballerina source [service/s, main/m]: (s) ");
                    } else {
                        out.print("Ballerina source [service/s, main/m, finish/f]: (f) ");
                    }
                    String srcInput = scanner.nextLine().trim();
                    if (srcInput.equalsIgnoreCase("service") || srcInput.equalsIgnoreCase("s") || first && srcInput.isEmpty()) {
                        out.print("Package for the service : (no package) ");
                        packageName = scanner.nextLine().trim();
                        srcFile = new SrcFile(packageName, FileType.SERVICE);
                        sourceFiles.add(srcFile);
                        packageMdFile = new PackageMdFile(packageName, FileType.SERVICE);
                        packageMdFiles.add(packageMdFile);
                    } else if (srcInput.equalsIgnoreCase("main") || srcInput.equalsIgnoreCase("m")) {
                        out.print("Package for the main : (no package) ");
                        packageName = scanner.nextLine().trim();
                        srcFile = new SrcFile(packageName, FileType.MAIN);
                        sourceFiles.add(srcFile);
                        packageMdFile = new PackageMdFile(packageName, FileType.MAIN);
                        packageMdFiles.add(packageMdFile);
                    } else if (srcInput.isEmpty() || srcInput.equalsIgnoreCase("f")) {
                        validInput = true;
                    } else {
                        out.println("Invalid input");
                    }
                    first = false;
                } while (!validInput);
                out.print("\n");
            } else if (InitCommand.isDirEmpty(projectPath)) {
                SrcFile srcFile = new SrcFile("", FileType.SERVICE);
                sourceFiles.add(srcFile);
            }
            InitHandler.initialize(projectPath, manifest, sourceFiles, packageMdFiles);
            out.println("Ballerina project initialized");
        }
        catch (IOException e) {
            out.println("Error occurred while creating project: " + e.getMessage());
        }
    }

    public String getName() {
        return "init";
    }

    public void printLongDesc(StringBuilder out) {
        out.append("Initializes a Ballerina Project. \n");
        out.append("\n");
        out.append("Use --interactive or -i to create a ballerina project in interactive mode.\n");
    }

    public void printUsage(StringBuilder out) {
        out.append("  ballerina init [-i] \n");
    }

    public void setParentCmdParser(JCommander parentCmdParser) {
        this.parentCmdParser = parentCmdParser;
    }

    public void setSelfCmdParser(JCommander selfCmdParser) {
    }

    private boolean validateVersion(PrintStream out, String versionAsString) {
        String semverRegex = "((?:0|[1-9]\\d*)\\.(?:0|[1-9]\\d*)\\.(?:0|[1-9]\\d*))";
        Pattern pattern = Pattern.compile(semverRegex);
        Matcher matcher = pattern.matcher(versionAsString);
        int count = 0;
        while (matcher.find()) {
            ++count;
        }
        if (count != 1) {
            out.println("--Invalid version: \"" + versionAsString + "\"");
        }
        return count == 1;
    }

    private String guessOrgName() {
        String guessOrgName = System.getProperty("user.name");
        guessOrgName = guessOrgName == null ? "my_org" : guessOrgName.toLowerCase(Locale.getDefault());
        return guessOrgName;
    }
}

