/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.packerina.cmd;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import java.io.PrintStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import org.ballerinalang.compiler.BLangCompilerException;
import org.ballerinalang.launcher.BLauncherCmd;
import org.ballerinalang.launcher.LauncherUtils;
import org.ballerinalang.packerina.ListUtils;

@Parameters(commandNames={"list"}, commandDescription="list dependencies of packages")
public class ListCommand
implements BLauncherCmd {
    private static final String USER_DIR = "user.dir";
    private static PrintStream outStream = System.err;
    private JCommander parentCmdParser;
    @Parameter(arity=1)
    private List<String> argList;
    @Parameter(names={"--help", "-h"}, hidden=true)
    private boolean helpFlag;
    @Parameter(names={"--java.debug"}, hidden=true)
    private String debugPort;

    public void execute() {
        if (this.helpFlag) {
            String commandUsageInfo = BLauncherCmd.getCommandUsageInfo((JCommander)this.parentCmdParser, (String)"list");
            outStream.println(commandUsageInfo);
            return;
        }
        if (this.argList != null && this.argList.size() > 1) {
            throw LauncherUtils.createUsageException((String)"too many arguments");
        }
        Path sourceRootPath = Paths.get(System.getProperty(USER_DIR), new String[0]);
        if (this.argList == null || this.argList.size() == 0) {
            ListUtils.list(sourceRootPath);
        } else if (Files.exists(sourceRootPath.resolve(".ballerina"), new LinkOption[0])) {
            String pkgName = this.argList.get(0);
            ListUtils.list(sourceRootPath, pkgName);
        } else {
            throw new BLangCompilerException("Current directory is not a project");
        }
        Runtime.getRuntime().exit(0);
    }

    public String getName() {
        return "list";
    }

    public void printLongDesc(StringBuilder out) {
        out.append("lists dependencies of packages \n");
    }

    public void printUsage(StringBuilder out) {
        out.append("  ballerina list <package-name> \n");
    }

    public void setParentCmdParser(JCommander parentCmdParser) {
        this.parentCmdParser = parentCmdParser;
    }

    public void setSelfCmdParser(JCommander selfCmdParser) {
    }
}

