/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.packerina.cmd;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import java.io.PrintStream;
import java.net.URI;
import java.util.List;
import java.util.stream.Collectors;
import org.ballerinalang.compiler.BLangCompilerException;
import org.ballerinalang.launcher.BLauncherCmd;
import org.ballerinalang.model.elements.PackageID;
import org.wso2.ballerinalang.compiler.packaging.Patten;
import org.wso2.ballerinalang.compiler.packaging.converters.Converter;
import org.wso2.ballerinalang.compiler.packaging.repo.RemoteRepo;
import org.wso2.ballerinalang.compiler.util.Name;
import org.wso2.ballerinalang.util.RepoUtils;

@Parameters(commandNames={"pull"}, commandDescription="downloads the package source and binaries from a remote repository,")
public class PullCommand
implements BLauncherCmd {
    private static PrintStream outStream = System.err;
    private JCommander parentCmdParser;
    @Parameter(arity=1)
    private List<String> argList;
    @Parameter(names={"--help", "-h"}, hidden=true)
    private boolean helpFlag;
    @Parameter(names={"--java.debug"}, hidden=true, description="remote java debugging port")
    private String javaDebugPort;
    @Parameter(names={"--debug"}, hidden=true)
    private String debugPort;

    public void execute() {
        String version;
        String packageName;
        String resourceName;
        int orgNameIndex;
        if (this.helpFlag) {
            String commandUsageInfo = BLauncherCmd.getCommandUsageInfo((JCommander)this.parentCmdParser, (String)"pull");
            outStream.println(commandUsageInfo);
            return;
        }
        if (this.argList == null || this.argList.size() == 0) {
            throw new BLangCompilerException("no package given");
        }
        if (this.argList.size() > 1) {
            throw new BLangCompilerException("too many arguments");
        }
        if (null != this.debugPort) {
            System.setProperty("debug", this.debugPort);
        }
        if ((orgNameIndex = (resourceName = this.argList.get(0)).indexOf("/")) == -1) {
            throw new BLangCompilerException("no package-name provided");
        }
        String orgName = resourceName.substring(0, orgNameIndex);
        int packageNameIndex = resourceName.indexOf(":");
        if (packageNameIndex != -1) {
            packageName = resourceName.substring(orgNameIndex + 1, packageNameIndex);
            version = resourceName.substring(packageNameIndex + 1, resourceName.length());
        } else {
            packageName = resourceName.substring(orgNameIndex + 1, resourceName.length());
            version = "*";
        }
        URI baseURI = URI.create(RepoUtils.getRemoteRepoURL());
        RemoteRepo remoteRepo = new RemoteRepo(baseURI);
        PackageID packageID = new PackageID(new Name(orgName), new Name(packageName), new Name(version));
        Patten patten = remoteRepo.calculate(packageID);
        if (patten != Patten.NULL) {
            Converter converter = remoteRepo.getConverterInstance();
            patten.convertToSources(converter, packageID).collect(Collectors.toList());
        } else {
            outStream.println("couldn't find package " + patten);
        }
        Runtime.getRuntime().exit(0);
    }

    public String getName() {
        return "pull";
    }

    public void printLongDesc(StringBuilder out) {
        out.append("download packages to the user repository \n");
    }

    public void printUsage(StringBuilder out) {
        out.append("  ballerina pull <package-name> \n");
    }

    public void setParentCmdParser(JCommander parentCmdParser) {
        this.parentCmdParser = parentCmdParser;
    }

    public void setSelfCmdParser(JCommander selfCmdParser) {
    }
}

