/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.packerina.cmd;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import java.io.PrintStream;
import java.util.List;
import org.ballerinalang.compiler.BLangCompilerException;
import org.ballerinalang.launcher.BLauncherCmd;
import org.ballerinalang.packerina.PushUtils;

@Parameters(commandNames={"push"}, commandDescription="pushes a package source and binaries availablelocally to ballerina central,")
public class PushCommand
implements BLauncherCmd {
    private static PrintStream outStream = System.err;
    private JCommander parentCmdParser;
    @Parameter(arity=1)
    private List<String> argList;
    @Parameter(names={"--help", "-h"}, hidden=true)
    private boolean helpFlag;
    @Parameter(names={"--java.debug"}, hidden=true, description="remote java debugging port")
    private String javaDebugPort;
    @Parameter(names={"--debug"}, hidden=true)
    private String debugPort;
    @Parameter(names={"--repository"}, hidden=true)
    private String repositoryHome;

    public void execute() {
        if (this.helpFlag) {
            String commandUsageInfo = BLauncherCmd.getCommandUsageInfo((JCommander)this.parentCmdParser, (String)"push");
            outStream.println(commandUsageInfo);
            return;
        }
        if (this.argList == null || this.argList.size() == 0) {
            throw new BLangCompilerException("No package given");
        }
        if (this.argList.size() > 1) {
            throw new BLangCompilerException("too many arguments");
        }
        if (null != this.debugPort) {
            System.setProperty("debug", this.debugPort);
        }
        String packageName = this.argList.get(0);
        PushUtils.pushPackages(packageName, this.repositoryHome);
        Runtime.getRuntime().exit(0);
    }

    public String getName() {
        return "push";
    }

    public void printLongDesc(StringBuilder out) {
        out.append("push packages to the ballerina central repository");
    }

    public void printUsage(StringBuilder out) {
        out.append("  ballerina push <package-name> \n");
    }

    public void setParentCmdParser(JCommander parentCmdParser) {
        this.parentCmdParser = parentCmdParser;
    }

    public void setSelfCmdParser(JCommander selfCmdParser) {
    }
}

