/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.packerina.cmd;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import java.io.PrintStream;
import java.util.List;
import org.ballerinalang.compiler.BLangCompilerException;
import org.ballerinalang.launcher.BLauncherCmd;
import org.ballerinalang.packerina.SearchUtils;

@Parameters(commandNames={"search"}, commandDescription="searches for packages within Ballerina Central")
public class SearchCommand
implements BLauncherCmd {
    private static PrintStream outStream = System.err;
    private JCommander parentCmdParser;
    @Parameter(arity=1)
    private List<String> argList;
    @Parameter(names={"--help", "-h"}, hidden=true)
    private boolean helpFlag;
    @Parameter(names={"--java.debug"}, hidden=true, description="remote java debugging port")
    private String javaDebugPort;
    @Parameter(names={"--debug"}, hidden=true)
    private String debugPort;

    public void execute() {
        if (this.helpFlag) {
            String commandUsageInfo = BLauncherCmd.getCommandUsageInfo((JCommander)this.parentCmdParser, (String)"search");
            outStream.println(commandUsageInfo);
            return;
        }
        if (null != this.debugPort) {
            System.setProperty("debug", this.debugPort);
        }
        if (this.argList == null || this.argList.size() == 0) {
            throw new BLangCompilerException("no keyword given");
        }
        if (this.argList.size() > 1) {
            throw new BLangCompilerException("too many arguments");
        }
        String searchArgs = this.argList.get(0);
        SearchUtils.searchInCentral(searchArgs);
        Runtime.getRuntime().exit(0);
    }

    public String getName() {
        return "search";
    }

    public void printLongDesc(StringBuilder out) {
        out.append("searches for packages within Ballerina Central \n");
    }

    public void printUsage(StringBuilder out) {
        out.append(" ballerina search [<org>|<package>|<text>] \n");
    }

    public void setParentCmdParser(JCommander parentCmdParser) {
        this.parentCmdParser = parentCmdParser;
    }

    public void setSelfCmdParser(JCommander selfCmdParser) {
    }
}

