/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.packerina.cmd;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import java.io.PrintStream;
import java.util.List;
import org.ballerinalang.launcher.BLauncherCmd;
import org.ballerinalang.launcher.LauncherUtils;
import org.ballerinalang.packerina.UserRepositoryUtils;

@Parameters(commandNames={"uninstall"}, commandDescription="uninstall packages from the user repository")
public class UninstallCommand
implements BLauncherCmd {
    private static PrintStream outStream = System.err;
    private JCommander parentCmdParser;
    @Parameter(arity=1)
    private List<String> argList;
    @Parameter(names={"--help", "-h"}, hidden=true)
    private boolean helpFlag;
    @Parameter(names={"--java.debug"}, hidden=true)
    private String debugPort;

    public void execute() {
        if (this.helpFlag) {
            String commandUsageInfo = BLauncherCmd.getCommandUsageInfo((JCommander)this.parentCmdParser, (String)"uninstall");
            outStream.println(commandUsageInfo);
            return;
        }
        if (this.argList == null || this.argList.size() == 0) {
            throw LauncherUtils.createUsageException((String)"no package given");
        }
        if (this.argList.size() > 1) {
            throw LauncherUtils.createUsageException((String)"too many arguments");
        }
        String packageStr = this.argList.get(0);
        UserRepositoryUtils.uninstallSourcePackage(packageStr);
    }

    public String getName() {
        return "uninstall";
    }

    public void printLongDesc(StringBuilder out) {
        out.append("uninstall packages from the user repository \n");
    }

    public void printUsage(StringBuilder out) {
        out.append("  ballerina uninstall <packagename> \n");
    }

    public void setParentCmdParser(JCommander parentCmdParser) {
        this.parentCmdParser = parentCmdParser;
    }

    public void setSelfCmdParser(JCommander selfCmdParser) {
    }
}

