/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.packerina.init;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import org.ballerinalang.packerina.init.models.PackageMdFile;
import org.ballerinalang.packerina.init.models.SrcFile;
import org.ballerinalang.toml.model.Manifest;

public class InitHandler {
    public static void initialize(Path projectPath, Manifest manifest, List<SrcFile> srcFiles, List<PackageMdFile> packageMdFile) throws IOException {
        InitHandler.createBallerinaToml(projectPath, manifest);
        InitHandler.createBallerinaCacheFile(projectPath);
        InitHandler.createPackageMd(projectPath, packageMdFile);
        InitHandler.createSrcFolder(projectPath, srcFiles);
        String ignoreFileContent = "target/\n";
        InitHandler.createIgnoreFiles(projectPath, ignoreFileContent);
    }

    private static void createBallerinaToml(Path projectPath, Manifest manifest) throws IOException {
        Path tomlPath;
        if (null != manifest && !Files.exists(tomlPath = Paths.get(projectPath.toString() + File.separator + "Ballerina.toml", new String[0]), new LinkOption[0])) {
            Files.createFile(tomlPath, new FileAttribute[0]);
            InitHandler.writeContent(tomlPath, InitHandler.getManifestContent(manifest));
        }
    }

    private static void createPackageMd(Path projectPath, List<PackageMdFile> packageMdFileList) throws IOException {
        if (null != packageMdFileList && packageMdFileList.size() > 0) {
            for (PackageMdFile packageMdFile : packageMdFileList) {
                Path srcFilePath;
                Path packagePath = projectPath.resolve(packageMdFile.getName());
                if (!Files.exists(packagePath, new LinkOption[0])) {
                    Files.createDirectory(packagePath, new FileAttribute[0]);
                }
                if (Files.exists(srcFilePath = packagePath.resolve("Package.md"), new LinkOption[0])) continue;
                Files.createFile(srcFilePath, new FileAttribute[0]);
                InitHandler.writeContent(srcFilePath, packageMdFile.getContent());
            }
        }
    }

    private static void createBallerinaCacheFile(Path projectPath) throws IOException {
        Path cacheFolder = Paths.get(projectPath.toString() + File.separator + ".ballerina", new String[0]);
        if (!Files.exists(cacheFolder, new LinkOption[0])) {
            Files.createDirectory(cacheFolder, new FileAttribute[0]);
        }
        String ignoreFileContent = "*\n!.gitignore\n";
        InitHandler.createIgnoreFiles(cacheFolder, ignoreFileContent);
    }

    private static void createSrcFolder(Path projectPath, List<SrcFile> srcFiles) throws IOException {
        String testDirName = "tests";
        if (null != srcFiles && srcFiles.size() > 0) {
            for (SrcFile srcFile : srcFiles) {
                Path packagePath = projectPath.resolve(srcFile.getName());
                Path testDirPath = packagePath.resolve("tests");
                if (!Files.exists(packagePath, new LinkOption[0])) {
                    Files.createDirectory(packagePath, new FileAttribute[0]);
                }
                if (!Files.exists(testDirPath, new LinkOption[0])) {
                    Files.createDirectory(testDirPath, new FileAttribute[0]);
                }
                Path srcFilePath = packagePath.resolve(srcFile.getSrcFileType().getFileName());
                Path testFilePath = testDirPath.resolve(srcFile.getTestFileName());
                if (!Files.exists(srcFilePath, new LinkOption[0])) {
                    Files.createFile(srcFilePath, new FileAttribute[0]);
                    InitHandler.writeContent(srcFilePath, srcFile.getContent());
                }
                if (Files.exists(testFilePath, new LinkOption[0])) continue;
                Files.createFile(testFilePath, new FileAttribute[0]);
                InitHandler.writeContent(testFilePath, srcFile.getTestContent());
            }
        }
    }

    private static void createIgnoreFiles(Path projectPath, String ignoreFileContent) throws IOException {
        Path gitIgnorePath = projectPath.resolve(".gitignore");
        if (Files.exists(gitIgnorePath, new LinkOption[0])) {
            InitHandler.writeIgnoreFileContent(gitIgnorePath, ignoreFileContent);
        } else {
            Files.createFile(gitIgnorePath, new FileAttribute[0]);
            InitHandler.writeIgnoreFileContent(gitIgnorePath, ignoreFileContent);
        }
    }

    private static void writeIgnoreFileContent(Path ignoreFile, String ignoreFileContent) throws IOException {
        String content = new String(Files.readAllBytes(ignoreFile), Charset.defaultCharset());
        if (!content.contains(ignoreFileContent)) {
            InitHandler.writeContent(ignoreFile, ignoreFileContent);
        }
    }

    private static void writeContent(Path file, String content) throws IOException {
        byte[] data = content.getBytes(Charset.defaultCharset());
        try (BufferedOutputStream out = new BufferedOutputStream(Files.newOutputStream(file, StandardOpenOption.CREATE, StandardOpenOption.APPEND));){
            ((OutputStream)out).write(data, 0, data.length);
        }
    }

    private static String getManifestContent(Manifest manifest) {
        StringBuilder manifestContent = new StringBuilder("[project]");
        manifestContent.append("\n");
        if (null != manifest.getName() && !manifest.getName().isEmpty()) {
            manifestContent.append("org-name = \"");
            manifestContent.append(manifest.getName());
            manifestContent.append("\"\n");
        }
        if (null != manifest.getVersion() && !manifest.getVersion().isEmpty()) {
            manifestContent.append("version = \"");
            manifestContent.append(manifest.getVersion());
            manifestContent.append("\"\n\n");
        }
        if (null != manifest.getAuthors() && !manifest.getAuthors().isEmpty()) {
            manifestContent.append("authors = [");
            manifestContent.append(String.join((CharSequence)", ", "\"" + manifest.getAuthors() + "\""));
            manifestContent.append("]\n\n");
        }
        if (null != manifest.getKeywords() && !manifest.getKeywords().isEmpty()) {
            manifestContent.append("keywords = [");
            manifestContent.append(String.join((CharSequence)", ", "\"" + manifest.getKeywords() + "\""));
            manifestContent.append("]\n\n");
        }
        return manifestContent.toString();
    }
}

