/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.packerina.init.models;

import org.ballerinalang.packerina.init.models.FileType;

public class SrcFile {
    private static final String SERVICE_CONTENT = "// A system package containing protocol access constructs\n// Package objects referenced with 'http:' in code\nimport ballerina/http;\nimport ballerina/io;\n\n// A service endpoint represents a listener\nendpoint http:Listener listener {\n    port:9090\n};\n\n// A service is a network-accessible API\n// Advertised on '/hello', port comes from listener endpoint\nservice<http:Service> hello bind listener {\n\n    // A resource is an invokable API method\n    // Accessible at '/hello/sayHello\n    // 'caller' is the client invoking this resource \n    sayHello (endpoint caller, http:Request request) {\n\n        // Create object to carry data back to caller\n        http:Response response = new;\n\n        // Objects and structs can have function calls\n        response.setTextPayload(\"Hello Ballerina!\\n\");\n\n        // Send a response back to caller\n        // Errors are ignored with '_'\n        // -> indicates a synchronous network-bound call\n        _ = caller -> respond(response);\n    }\n}";
    private static final String MAIN_FUNCTION_CONTENT = "import ballerina/io;\nfunction main(string... args) {\n    io:println(\"Hello World!\");\n}\n";
    private static final String MAIN_FUNCTION_TEST_CONTENT = "import ballerina/test;\nimport ballerina/io;\n\n// Before Suite Function\n@test:BeforeSuite\nfunction beforeSuiteFunc () {\n    io:println(\"I'm the before suite function!\");\n}\n\n// Before test function\nfunction beforeFunc () {\n    io:println(\"I'm the before function!\");\n}\n\n// Test function\n@test:Config{\n    before:\"beforeFunc\",\n    after:\"afterFunc\"\n}\nfunction testFunction () {\n    io:println(\"I'm in test function!\");\n    test:assertTrue(true , msg = \"Failed!\");\n}\n\n// after test function\nfunction afterFunc () {\n    io:println(\"I'm the after function!\");\n}\n\n// Before Suite Function\n@test:AfterSuite\nfunction afterSuiteFunc () {\n    io:println(\"I'm the After suite function!\");\n}";
    private static final String SERVICE_TEST_CONTENT = "import ballerina/test;%nimport ballerina/io;%n%n// Before Suite Function can be used to start the service%n@test:BeforeSuite%nfunction beforeSuiteFunc () {%n    io:println(\"Start the Service!\");%n    boolean status = test:startServices(\"%1$s\");%n}%n%n// Test function%n@test:Config%nfunction testFunction () {%n    io:println(\"Do your service Tests!\");%n    test:assertTrue(true , msg = \"Failed!\");%n}%n%n// After Suite Function is used to stop the service%n@test:AfterSuite%nfunction afterSuiteFunc () {%n    io:println(\"Stop the service!\");%n    test:stopServices(\"%1$s\");%n}";
    private FileType srcFileType;
    private String content;
    private String testFileContent;
    private String name;
    private String testFileName;

    public SrcFile(String name, FileType fileType) {
        this.srcFileType = fileType;
        this.name = name;
        switch (fileType) {
            case SERVICE: {
                this.content = SERVICE_CONTENT;
                this.testFileContent = String.format(SERVICE_TEST_CONTENT, this.name.isEmpty() ? "." : this.name);
                this.testFileName = "hello_service_test.bal";
                break;
            }
            default: {
                this.content = MAIN_FUNCTION_CONTENT;
                this.testFileContent = MAIN_FUNCTION_TEST_CONTENT;
                this.testFileName = "main_test.bal";
            }
        }
    }

    public FileType getSrcFileType() {
        return this.srcFileType;
    }

    public String getContent() {
        return this.content;
    }

    public String getTestContent() {
        return this.testFileContent;
    }

    public String getName() {
        return this.name;
    }

    public String getTestFileName() {
        return this.testFileName;
    }
}

