/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.packerina.buildcontext;

import java.io.IOException;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import org.ballerinalang.compiler.BLangCompilerException;
import org.ballerinalang.compiler.CompilerOptionName;
import org.ballerinalang.model.elements.PackageID;
import org.ballerinalang.packerina.buildcontext.BuildContextField;
import org.ballerinalang.packerina.buildcontext.sourcecontext.MultiModuleContext;
import org.ballerinalang.packerina.buildcontext.sourcecontext.SingleFileContext;
import org.ballerinalang.packerina.buildcontext.sourcecontext.SingleModuleContext;
import org.ballerinalang.packerina.buildcontext.sourcecontext.SourceType;
import org.ballerinalang.packerina.model.ExecutableJar;
import org.ballerinalang.packerina.utils.EmptyPrintStream;
import org.ballerinalang.toml.model.Dependency;
import org.ballerinalang.toml.model.Manifest;
import org.ballerinalang.toml.parser.ManifestProcessor;
import org.wso2.ballerinalang.compiler.tree.BLangPackage;
import org.wso2.ballerinalang.compiler.util.CompilerContext;
import org.wso2.ballerinalang.compiler.util.CompilerOptions;
import org.wso2.ballerinalang.util.RepoUtils;

public class BuildContext
extends HashMap<BuildContextField, Object> {
    private static final long serialVersionUID = 6363519534259706585L;
    private transient Path executableDir;
    private transient Path targetJarCacheDir;
    private transient Path targetBirCacheDir;
    private transient Path targetTestJsonCacheDir;
    private transient Path baloCacheDir;
    private SourceType srcType;
    private transient PrintStream out;
    private transient PrintStream err;
    public transient Map<PackageID, ExecutableJar> moduleDependencyPathMap = new HashMap<PackageID, ExecutableJar>();

    public BuildContext(Path sourceRootPath, Path targetPath, Path source, CompilerContext compilerContext) {
        try {
            this.out = new EmptyPrintStream();
            this.err = new EmptyPrintStream();
            if (!Files.exists(sourceRootPath, new LinkOption[0])) {
                throw new BLangCompilerException("location of the source root does not exists: " + sourceRootPath);
            }
            this.put(BuildContextField.HOME_REPO, Paths.get(System.getProperty("ballerina.home"), new String[0]));
            this.put(BuildContextField.SOURCE_ROOT, sourceRootPath);
            this.put(BuildContextField.TARGET_DIR, targetPath);
            this.put(BuildContextField.COMPILER_CONTEXT, compilerContext);
            this.setSource(source);
            this.baloCacheDir = targetPath.resolve("balo");
            this.targetBirCacheDir = targetPath.resolve("caches").resolve("bir_cache");
            this.put(BuildContextField.BIR_CACHE_DIR, this.targetBirCacheDir);
            this.targetJarCacheDir = targetPath.resolve("caches").resolve("jar_cache");
            this.targetTestJsonCacheDir = targetPath.resolve("caches").resolve("json_cache");
            this.executableDir = targetPath.resolve("bin");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
    }

    public BuildContext(Path sourceRootPath, Path targetPath, Path source) {
        this(sourceRootPath, targetPath, source, null);
    }

    public BuildContext(Path sourceRootPath, Path source) {
        this(sourceRootPath, sourceRootPath.resolve("target"), source);
    }

    public BuildContext(Path sourceRootPath) {
        this(sourceRootPath, null);
    }

    public void setOut(PrintStream out) {
        this.out = out;
    }

    public PrintStream out() {
        return this.out;
    }

    public void setErr(PrintStream err) {
        this.err = err;
    }

    public PrintStream err() {
        return this.err;
    }

    public <T> T get(BuildContextField key) {
        return (T)super.get((Object)key);
    }

    public void setSource(Path source) {
        if (source == null) {
            this.put(BuildContextField.SOURCE_CONTEXT, new MultiModuleContext());
            this.srcType = SourceType.ALL_MODULES;
        } else {
            Path absoluteSourcePath;
            Path sourceRootPath = (Path)this.get(BuildContextField.SOURCE_ROOT);
            Path path = absoluteSourcePath = RepoUtils.isBallerinaProject((Path)sourceRootPath) ? sourceRootPath.toAbsolutePath().resolve("src").resolve(source) : sourceRootPath.toAbsolutePath().resolve(source);
            if (Files.isRegularFile(absoluteSourcePath, new LinkOption[0]) && source.toString().endsWith(".bal")) {
                this.put(BuildContextField.SOURCE_CONTEXT, new SingleFileContext(source));
                this.srcType = SourceType.SINGLE_BAL_FILE;
            } else if (Files.isDirectory(absoluteSourcePath, new LinkOption[0]) && !source.toString().endsWith(".bal")) {
                Path moduleNameAsPath = source.getFileName();
                if (null != moduleNameAsPath) {
                    String moduleName = moduleNameAsPath.toString();
                    this.put(BuildContextField.SOURCE_CONTEXT, new SingleModuleContext(moduleName));
                    this.srcType = SourceType.SINGLE_MODULE;
                }
            } else {
                throw new BLangCompilerException("invalid source type found: '" + source + "' at: " + sourceRootPath);
            }
        }
        CompilerContext compilerContext = (CompilerContext)this.get(BuildContextField.COMPILER_CONTEXT);
        if (compilerContext != null) {
            CompilerOptions options = CompilerOptions.getInstance((CompilerContext)compilerContext);
            options.put(CompilerOptionName.SOURCE_TYPE, this.srcType.toString());
        }
    }

    public SourceType getSourceType() {
        return this.srcType;
    }

    public void updateExecutableDir(Path executablesDir) {
        this.executableDir = executablesDir;
    }

    public Path getSystemRepoBirCache() {
        return Paths.get(System.getProperty("ballerina.home"), new String[0]).resolve("bir-cache");
    }

    public Path getHomeRepoDir() {
        return RepoUtils.createAndGetHomeReposPath();
    }

    public Path getBirCacheFromHome() {
        return RepoUtils.createAndGetHomeReposPath().resolve("bir_cache-" + RepoUtils.getBallerinaVersion());
    }

    public Path getJarCacheFromHome() {
        return RepoUtils.createAndGetHomeReposPath().resolve("jar_cache-" + RepoUtils.getBallerinaVersion());
    }

    public Path getBaloCacheFromHome() {
        return RepoUtils.createAndGetHomeReposPath().resolve("balo_cache");
    }

    public List<BLangPackage> getModules() {
        LinkedList<BLangPackage> modules = new LinkedList<BLangPackage>();
        switch (this.getSourceType()) {
            case SINGLE_BAL_FILE: {
                SingleFileContext singleFileContext = (SingleFileContext)this.get(BuildContextField.SOURCE_CONTEXT);
                modules.add(singleFileContext.getModule());
                break;
            }
            case SINGLE_MODULE: {
                SingleModuleContext singleModuleContext = (SingleModuleContext)this.get(BuildContextField.SOURCE_CONTEXT);
                modules.add(singleModuleContext.getModule());
                break;
            }
            case ALL_MODULES: {
                MultiModuleContext multiModuleContext = (MultiModuleContext)this.get(BuildContextField.SOURCE_CONTEXT);
                modules = multiModuleContext.getModules();
                break;
            }
            default: {
                throw new BLangCompilerException("unknown source type found: " + (Object)((Object)this.getSourceType()));
            }
        }
        return modules;
    }

    public Path getBirPathFromHomeCache(PackageID moduleID) {
        try {
            Path moduleBirCacheDir = Files.createDirectories(this.getBirCacheFromHome().resolve(moduleID.orgName.value).resolve(moduleID.name.value).resolve(moduleID.version.value), new FileAttribute[0]);
            return moduleBirCacheDir.resolve(moduleID.name.value + ".bir");
        }
        catch (IOException e) {
            throw new BLangCompilerException("error resolving bir_cache dir for module: " + moduleID);
        }
    }

    public Path getJarPathFromHomeCache(PackageID moduleID) {
        try {
            Path moduleJarCacheDir = Files.createDirectories(this.getJarCacheFromHome().resolve(moduleID.orgName.value).resolve(moduleID.name.value).resolve(moduleID.version.value), new FileAttribute[0]);
            return moduleJarCacheDir.resolve(moduleID.name.value + ".jar");
        }
        catch (IOException e) {
            throw new BLangCompilerException("error resolving bir_cache dir for module: " + moduleID);
        }
    }

    public Path getBaloFromHomeCache(PackageID moduleID, String platform) {
        try {
            Path moduleBaloCacheDir = Files.createDirectories(this.getBaloCacheFromHome().resolve(moduleID.orgName.value).resolve(moduleID.name.value).resolve(moduleID.version.value), new FileAttribute[0]);
            String baloFileName = moduleID.name.value + "-" + "2020r1" + "-" + platform + "-" + moduleID.version.value + ".balo";
            Path baloPath = moduleBaloCacheDir.resolve(baloFileName);
            if (!Files.exists(baloPath, new LinkOption[0]) && Files.exists(moduleBaloCacheDir, new LinkOption[0])) {
                Stream<Path> list = Files.list(moduleBaloCacheDir);
                PathMatcher pathMatcher = moduleBaloCacheDir.getFileSystem().getPathMatcher("glob:**/" + moduleID.name.value + "-*-" + platform + "-" + moduleID.version.value + ".balo");
                for (Path file : list::iterator) {
                    if (!pathMatcher.matches(file)) continue;
                    return file;
                }
            }
            return baloPath;
        }
        catch (IOException e) {
            throw new BLangCompilerException("error resolving balo_cache dir for module: " + moduleID);
        }
    }

    public Path getBaloFromTarget(PackageID moduleID) {
        try {
            Files.createDirectories(this.baloCacheDir, new FileAttribute[0]);
            switch (this.getSourceType()) {
                case SINGLE_BAL_FILE: {
                    throw new BLangCompilerException("balo file for single ballerina files are not supported");
                }
                case SINGLE_MODULE: 
                case ALL_MODULES: {
                    CompilerContext context = (CompilerContext)this.get(BuildContextField.COMPILER_CONTEXT);
                    Manifest manifest = ManifestProcessor.getInstance((CompilerContext)context).getManifest();
                    String versionNo = manifest.getProject().getVersion();
                    String platform = manifest.getTargetPlatform(moduleID.name.value);
                    String baloFileName = moduleID.name.value + "-" + "2020r1" + "-" + platform + "-" + versionNo + ".balo";
                    return this.baloCacheDir.resolve(baloFileName);
                }
            }
            throw new BLangCompilerException("unable to resolve balo location for build source");
        }
        catch (IOException e) {
            throw new BLangCompilerException("error creating bir_cache dir for module(s): " + this.baloCacheDir);
        }
    }

    public Path getBirPathFromTargetCache(PackageID moduleID) {
        try {
            Files.createDirectories(this.targetBirCacheDir, new FileAttribute[0]);
            switch (this.getSourceType()) {
                case SINGLE_BAL_FILE: {
                    SingleFileContext singleFileContext = (SingleFileContext)this.get(BuildContextField.SOURCE_CONTEXT);
                    String birFileName = singleFileContext.getBalFileNameWithoutExtension() + ".bir";
                    return this.targetBirCacheDir.resolve(birFileName);
                }
                case SINGLE_MODULE: 
                case ALL_MODULES: {
                    Path moduleBirCacheDir = Files.createDirectories(this.targetBirCacheDir.resolve(moduleID.orgName.value).resolve(moduleID.name.value).resolve(moduleID.version.value), new FileAttribute[0]);
                    return moduleBirCacheDir.resolve(moduleID.name.value + ".bir");
                }
            }
            throw new BLangCompilerException("unknown source type found: " + (Object)((Object)this.getSourceType()));
        }
        catch (IOException e) {
            throw new BLangCompilerException("error creating bir_cache dir for module(s): " + this.targetBirCacheDir);
        }
    }

    public Path getTestBirPathFromTargetCache(PackageID moduleID) {
        try {
            Files.createDirectories(this.targetBirCacheDir, new FileAttribute[0]);
            switch (this.getSourceType()) {
                case SINGLE_BAL_FILE: {
                    SingleFileContext singleFileContext = (SingleFileContext)this.get(BuildContextField.SOURCE_CONTEXT);
                    String birFileName = singleFileContext.getBalFileNameWithoutExtension() + "-testable" + ".bir";
                    return this.targetBirCacheDir.resolve(birFileName);
                }
                case SINGLE_MODULE: 
                case ALL_MODULES: {
                    Path moduleBirCacheDir = Files.createDirectories(this.targetBirCacheDir.resolve(moduleID.orgName.value).resolve(moduleID.name.value).resolve(moduleID.version.value), new FileAttribute[0]);
                    return moduleBirCacheDir.resolve(moduleID.name.value + "-testable" + ".bir");
                }
            }
            throw new BLangCompilerException("unknown source type found: " + (Object)((Object)this.getSourceType()));
        }
        catch (IOException e) {
            throw new BLangCompilerException("error creating bir_cache dir for module(s): " + this.targetBirCacheDir);
        }
    }

    public Path getJarPathFromTargetCache(PackageID moduleID) {
        try {
            Files.createDirectories(this.targetJarCacheDir, new FileAttribute[0]);
            switch (this.getSourceType()) {
                case SINGLE_BAL_FILE: {
                    SingleFileContext singleFileContext = (SingleFileContext)this.get(BuildContextField.SOURCE_CONTEXT);
                    String birFileName = singleFileContext.getBalFileNameWithoutExtension() + ".jar";
                    return this.targetJarCacheDir.resolve(birFileName);
                }
                case SINGLE_MODULE: 
                case ALL_MODULES: {
                    Path moduleBirCacheDir = Files.createDirectories(this.targetJarCacheDir.resolve(moduleID.orgName.value).resolve(moduleID.name.value).resolve(moduleID.version.value), new FileAttribute[0]);
                    return moduleBirCacheDir.resolve(moduleID.orgName.value + "-" + moduleID.name.value + "-" + moduleID.version.value + ".jar");
                }
            }
            throw new BLangCompilerException("unknown source type found: " + (Object)((Object)this.getSourceType()));
        }
        catch (IOException e) {
            throw new BLangCompilerException("error creating bir_cache dir for module(s): " + this.targetJarCacheDir);
        }
    }

    public Path getTestJarPathFromTargetCache(PackageID moduleID) {
        try {
            Files.createDirectories(this.targetJarCacheDir, new FileAttribute[0]);
            switch (this.getSourceType()) {
                case SINGLE_BAL_FILE: {
                    SingleFileContext singleFileContext = (SingleFileContext)this.get(BuildContextField.SOURCE_CONTEXT);
                    String birFileName = singleFileContext.getBalFileNameWithoutExtension() + "-testable" + ".jar";
                    return this.targetJarCacheDir.resolve(birFileName);
                }
                case SINGLE_MODULE: 
                case ALL_MODULES: {
                    Path moduleBirCacheDir = Files.createDirectories(this.targetJarCacheDir.resolve(moduleID.orgName.value).resolve(moduleID.name.value).resolve(moduleID.version.value), new FileAttribute[0]);
                    return moduleBirCacheDir.resolve(moduleID.orgName.value + "-" + moduleID.name.value + "-" + moduleID.version.value + "-testable" + ".jar");
                }
            }
            throw new BLangCompilerException("unknown source type found: " + (Object)((Object)this.getSourceType()));
        }
        catch (IOException e) {
            throw new BLangCompilerException("error creating bir_cache dir for module(s): " + this.targetJarCacheDir);
        }
    }

    public Path getExecutablePathFromTarget(PackageID moduleID) {
        try {
            Files.createDirectories(this.executableDir, new FileAttribute[0]);
            switch (this.getSourceType()) {
                case SINGLE_BAL_FILE: {
                    SingleFileContext singleFileContext = (SingleFileContext)this.get(BuildContextField.SOURCE_CONTEXT);
                    if (null == singleFileContext.getExecutableFilePath()) {
                        String executableFileName = singleFileContext.getBalFileNameWithoutExtension() + ".jar";
                        return this.executableDir.resolve(executableFileName);
                    }
                    return singleFileContext.getExecutableFilePath();
                }
                case SINGLE_MODULE: 
                case ALL_MODULES: {
                    return this.executableDir.resolve(moduleID.name.value + ".jar");
                }
            }
            throw new BLangCompilerException("unable to resolve executable(s) location for build source");
        }
        catch (IOException e) {
            throw new BLangCompilerException("error creating bir_cache dir for module(s): " + this.executableDir);
        }
    }

    public Path getTestJsonPathTargetCache(PackageID moduleID) {
        try {
            Files.createDirectories(this.targetTestJsonCacheDir, new FileAttribute[0]);
            switch (this.getSourceType()) {
                case SINGLE_MODULE: 
                case ALL_MODULES: {
                    return Files.createDirectories(this.targetTestJsonCacheDir.resolve(moduleID.orgName.value).resolve(moduleID.name.value).resolve(moduleID.version.value), new FileAttribute[0]);
                }
            }
            return this.targetTestJsonCacheDir;
        }
        catch (IOException e) {
            throw new BLangCompilerException("error creating test_json_cache dir for module(s): " + this.targetTestJsonCacheDir);
        }
    }

    public Optional<Dependency> getImportPathDependency(PackageID moduleID) {
        CompilerContext context = (CompilerContext)this.get(BuildContextField.COMPILER_CONTEXT);
        if (null == context) {
            return Optional.empty();
        }
        Manifest manifest = ManifestProcessor.getInstance((CompilerContext)context).getManifest();
        return manifest.getDependencies().stream().filter(dep -> dep.getOrgName().equals(moduleID.orgName.value) && dep.getModuleName().equals(moduleID.name.value) && null != dep.getMetadata().getPath()).findFirst();
    }

    public Path getLockFilePath() {
        Path sourceRootPath = (Path)this.get(BuildContextField.SOURCE_ROOT);
        return sourceRootPath.resolve("Ballerina.lock");
    }

    public boolean skipTests() {
        CompilerContext context = (CompilerContext)this.get(BuildContextField.COMPILER_CONTEXT);
        if (context == null) {
            return false;
        }
        CompilerOptions compilerOptions = CompilerOptions.getInstance((CompilerContext)context);
        String skipTestsArg = compilerOptions.get(CompilerOptionName.SKIP_TESTS);
        return skipTestsArg != null && !skipTestsArg.equals("false");
    }
}

