/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.packerina.cmd;

import java.io.IOException;
import java.io.PrintStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import org.ballerinalang.compiler.CompilerOptionName;
import org.ballerinalang.compiler.CompilerPhase;
import org.ballerinalang.packerina.TaskExecutor;
import org.ballerinalang.packerina.buildcontext.BuildContext;
import org.ballerinalang.packerina.cmd.CommandUtil;
import org.ballerinalang.packerina.task.CompileTask;
import org.ballerinalang.packerina.task.CreateDocsTask;
import org.ballerinalang.packerina.task.CreateTargetDirTask;
import org.ballerinalang.tool.BLauncherCmd;
import org.ballerinalang.tool.LauncherUtils;
import org.wso2.ballerinalang.compiler.util.CompilerContext;
import org.wso2.ballerinalang.compiler.util.CompilerOptions;
import org.wso2.ballerinalang.compiler.util.ProjectDirs;
import org.wso2.ballerinalang.util.RepoUtils;
import picocli.CommandLine;

@CommandLine.Command(name="doc", description={"Ballerina doc - Generates API Documentation"})
public class DocCommand
implements BLauncherCmd {
    private final PrintStream outStream;
    private final PrintStream errStream;
    private Path sourceRootPath = Paths.get(System.getProperty("user.dir"), new String[0]);
    @CommandLine.Option(names={"--sourceroot"}, description={"Path to the directory containing source files and modules."})
    private String sourceRoot;
    @CommandLine.Option(names={"--all", "-a"}, description={"Generate docs for all the modules of the project."})
    private boolean buildAll;
    @CommandLine.Option(names={"--output", "-o"}, description={"Path to folder to which API docs will be written."})
    private String output;
    @CommandLine.Option(names={"--offline"}, description={"Compiles offline without downloading dependencies."})
    private boolean offline;
    @CommandLine.Parameters
    private List<String> argList;
    @CommandLine.Option(names={"--exclude", "-e"}, description={"List of modules to be excluded."})
    private String[] excludes;
    @CommandLine.Option(names={"--help", "-h"}, hidden=true)
    private boolean helpFlag;
    @CommandLine.Option(names={"--experimental"}, description={"Enable experimental language features."})
    private boolean experimentalFlag;

    public DocCommand() {
        this.outStream = System.out;
        this.errStream = System.err;
    }

    public void execute() {
        Path targetPath;
        if (this.helpFlag) {
            String commandUsageInfo = BLauncherCmd.getCommandUsageInfo((String)"doc");
            this.errStream.println(commandUsageInfo);
            return;
        }
        if (this.argList != null && this.argList.size() > 1) {
            CommandUtil.printError(this.errStream, "too many arguments.", "ballerina doc [-o <output>] [--sourceroot] [--offline]\n                     {<ballerina-file | module-name> | -a | --all}", false);
            CommandUtil.exitError(true);
            return;
        }
        if (!(this.buildAll || this.argList != null && this.argList.size() != 0)) {
            CommandUtil.printError(this.errStream, "'doc' command requires a module name or a Ballerina file to continue. use '-a' or '--all' flag to generate api documentation for all the modules of the project.", "ballerina doc {<ballerina-file> | <module-name> | -a | --all}", false);
            CommandUtil.exitError(true);
            return;
        }
        this.sourceRootPath = null != this.sourceRoot ? Paths.get(this.sourceRoot, new String[0]).toAbsolutePath() : this.sourceRootPath;
        Path sourcePath = null;
        if (this.buildAll) {
            if (!ProjectDirs.isProject((Path)this.sourceRootPath)) {
                Path findRoot = ProjectDirs.findProjectRoot((Path)this.sourceRootPath);
                if (null == findRoot) {
                    CommandUtil.printError(this.errStream, "you are not in a Ballerina project.", null, false);
                    CommandUtil.exitError(true);
                    return;
                }
                this.sourceRootPath = findRoot;
            }
            targetPath = this.sourceRootPath.resolve("target");
        } else if (this.argList.get(0).endsWith(".bal")) {
            if (Paths.get(this.argList.get(0), new String[0]).isAbsolute()) {
                sourcePath = Paths.get(this.argList.get(0), new String[0]);
                this.sourceRootPath = sourcePath.getParent();
            } else {
                sourcePath = this.sourceRootPath.resolve(this.argList.get(0));
            }
            if (Files.notExists(sourcePath, new LinkOption[0])) {
                CommandUtil.printError(this.errStream, "'" + sourcePath + "' Ballerina file does not exist.", null, false);
                CommandUtil.exitError(true);
                return;
            }
            if (!Files.isRegularFile(sourcePath, new LinkOption[0])) {
                CommandUtil.printError(this.errStream, "'" + sourcePath + "' is not a Ballerina file. check if it is a symlink or a shortcut.", null, false);
                CommandUtil.exitError(true);
                return;
            }
            if (null == this.output) {
                CommandUtil.printError(this.errStream, "'-o' and '--output' flag is required for a single Ballerina file.", "ballerina doc -o <output-path> <ballerina-file>", false);
                CommandUtil.exitError(true);
                return;
            }
            try {
                targetPath = Files.createTempDirectory("ballerina-build-" + System.nanoTime(), new FileAttribute[0]);
            }
            catch (IOException e) {
                throw LauncherUtils.createLauncherException((String)"error occurred when creating output folder.");
            }
        } else if (Files.exists(this.sourceRootPath.resolve("src").resolve(this.argList.get(0)), new LinkOption[0]) && Files.isDirectory(this.sourceRootPath.resolve("src").resolve(this.argList.get(0)), new LinkOption[0])) {
            if (null != this.output) {
                CommandUtil.printError(this.errStream, "'-o' and '--output' flag is only supported for a single Ballerina file.", null, false);
                CommandUtil.exitError(true);
                return;
            }
            if (!RepoUtils.isBallerinaProject((Path)this.sourceRootPath)) {
                CommandUtil.printError(this.errStream, "you are trying to generate docs for a module that is not inside a project.", null, false);
                CommandUtil.exitError(true);
                return;
            }
            if (Paths.get(this.argList.get(0), new String[0]).isAbsolute()) {
                CommandUtil.printError(this.errStream, "you are trying to generate docs for a module by giving the absolute path. you only need give the name of the module.", "ballerina doc <module-name>", true);
                CommandUtil.exitError(true);
                return;
            }
            String moduleName = this.argList.get(0);
            if (moduleName.endsWith("/")) {
                moduleName = moduleName.substring(0, moduleName.length() - 1);
            }
            sourcePath = Paths.get(moduleName, new String[0]);
            if (Files.notExists(this.sourceRootPath.resolve("src").resolve(sourcePath), new LinkOption[0])) {
                CommandUtil.printError(this.errStream, "'" + sourcePath + "' module does not exist.", "ballerina doc <module-name>", true);
                CommandUtil.exitError(true);
                return;
            }
            targetPath = this.sourceRootPath.resolve("target");
        } else {
            CommandUtil.printError(this.errStream, "invalid Ballerina source path. It should either be a name of a module in a Ballerina project or a file with a '.bal' extension. Use the -a or --all flag to generate docs for all modules.", "ballerina doc {<ballerina-file> | <module-name> | -a | --all}", true);
            CommandUtil.exitError(true);
            return;
        }
        this.sourceRootPath = this.sourceRootPath.normalize();
        sourcePath = sourcePath == null ? null : sourcePath.normalize();
        targetPath = targetPath.normalize();
        Path outputPath = this.output != null ? Paths.get(this.output, new String[0]).toAbsolutePath().normalize() : null;
        CompilerContext compilerContext = new CompilerContext();
        CompilerOptions options = CompilerOptions.getInstance((CompilerContext)compilerContext);
        options.put(CompilerOptionName.PROJECT_DIR, this.sourceRootPath.toString());
        options.put(CompilerOptionName.OFFLINE, Boolean.toString(this.offline));
        options.put(CompilerOptionName.COMPILER_PHASE, CompilerPhase.CODE_ANALYZE.toString());
        options.put(CompilerOptionName.SKIP_TESTS, Boolean.toString(true));
        options.put(CompilerOptionName.TEST_ENABLED, "false");
        options.put(CompilerOptionName.EXPERIMENTAL_FEATURES_ENABLED, Boolean.toString(this.experimentalFlag));
        BuildContext buildContext = new BuildContext(this.sourceRootPath, targetPath, sourcePath, compilerContext);
        buildContext.setOut(this.outStream);
        buildContext.setErr(this.errStream);
        TaskExecutor taskExecutor = new TaskExecutor.TaskBuilder().addTask(new CreateTargetDirTask()).addTask(new CompileTask()).addTask(new CreateDocsTask(outputPath)).build();
        taskExecutor.executeTasks(buildContext);
        Runtime.getRuntime().exit(0);
    }

    public String getName() {
        return "doc";
    }

    public void printLongDesc(StringBuilder out) {
        out.append("Generates API Documentation for Ballerina module(s)/file. \n");
        out.append("\n");
    }

    public void printUsage(StringBuilder out) {
        out.append("  ballerina doc [-o <output-path>] {<ballerina-file | module-name> | -a | --all} \n");
    }

    public void setParentCmdParser(CommandLine parentCmdParser) {
    }
}

