/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.packerina.cmd;

import java.io.IOException;
import java.io.PrintStream;
import java.nio.file.AccessDeniedException;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.ballerinalang.packerina.cmd.CommandUtil;
import org.ballerinalang.tool.BLauncherCmd;
import org.wso2.ballerinalang.compiler.util.ProjectDirs;
import picocli.CommandLine;

@CommandLine.Command(name="init", description={"Create a Init Ballerina project"})
public class InitCommand
implements BLauncherCmd {
    private Path userDir;
    private PrintStream errStream;
    @CommandLine.Option(names={"--help", "-h"}, hidden=true)
    private boolean helpFlag;

    public InitCommand() {
        this.userDir = Paths.get(System.getProperty("user.dir"), new String[0]);
        this.errStream = System.err;
    }

    public InitCommand(Path userDir, PrintStream errStream) {
        this.userDir = userDir;
        this.errStream = errStream;
    }

    public void execute() {
        if (this.helpFlag) {
            String commandUsageInfo = BLauncherCmd.getCommandUsageInfo((String)"init");
            this.errStream.println(commandUsageInfo);
            return;
        }
        if (ProjectDirs.isProject((Path)this.userDir)) {
            CommandUtil.printError(this.errStream, "Directory is already a ballerina project", null, false);
            return;
        }
        Path projectRoot = ProjectDirs.findProjectRoot((Path)this.userDir);
        if (projectRoot != null) {
            CommandUtil.printError(this.errStream, "Directory is already within a ballerina project :" + projectRoot.toString(), null, false);
            return;
        }
        try {
            CommandUtil.initProject(this.userDir);
        }
        catch (AccessDeniedException e) {
            this.errStream.println("error: Error occurred while initializing project : Access Denied");
        }
        catch (IOException e) {
            this.errStream.println("error: Error occurred while initializing project : " + e.getMessage());
            return;
        }
        this.errStream.println("Ballerina project initialised ");
        this.errStream.println();
        this.errStream.println("Next:");
        this.errStream.println("    Use `ballerina create` to create a ballerina module.");
    }

    public String getName() {
        return "init";
    }

    public void printLongDesc(StringBuilder out) {
        out.append("initialize a ballerina project in current directory");
    }

    public void printUsage(StringBuilder out) {
        out.append("  ballerina init \n");
    }

    public void setParentCmdParser(CommandLine parentCmdParser) {
    }
}

