/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.packerina.cmd;

import java.io.PrintStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.List;
import org.ballerinalang.packerina.PushUtils;
import org.ballerinalang.packerina.cmd.CommandUtil;
import org.ballerinalang.tool.BLauncherCmd;
import org.ballerinalang.tool.LauncherUtils;
import org.wso2.ballerinalang.compiler.util.ProjectDirs;
import picocli.CommandLine;

@CommandLine.Command(name="push", description={"push modules and binaries available locally to Ballerina Central"})
public class PushCommand
implements BLauncherCmd {
    private static PrintStream outStream = System.err;
    @CommandLine.Parameters
    private List<String> argList;
    @CommandLine.Option(names={"--help", "-h"}, hidden=true)
    private boolean helpFlag;
    @CommandLine.Option(names={"--debug"}, hidden=true)
    private String debugPort;
    @CommandLine.Option(names={"--repository"}, hidden=true)
    private String repositoryHome;
    @CommandLine.Option(names={"--skip-source-check"}, description={"skip checking if source has changed"})
    private boolean skipSourceCheck;
    @CommandLine.Option(names={"--experimental"}, description={"enable experimental language features"})
    private boolean experimentalFlag;
    @CommandLine.Option(names={"--all", "-a"}, description={"Push all the modules of the project."})
    private boolean pushAll;
    private Path userDir;
    private PrintStream errStream;

    public PushCommand() {
        this.userDir = Paths.get(System.getProperty("user.dir"), new String[0]);
        this.errStream = System.err;
    }

    public PushCommand(Path userDir, PrintStream errStream) {
        this.userDir = userDir;
        this.errStream = errStream;
    }

    public void execute() {
        if (this.helpFlag) {
            String commandUsageInfo = BLauncherCmd.getCommandUsageInfo((String)"push");
            outStream.println(commandUsageInfo);
            return;
        }
        Path sourceRootPath = this.userDir;
        if (!ProjectDirs.isProject((Path)sourceRootPath)) {
            Path findRoot = ProjectDirs.findProjectRoot((Path)sourceRootPath);
            if (null == findRoot) {
                CommandUtil.printError(this.errStream, "Push command can be only run inside a Ballerina project", null, false);
                return;
            }
            sourceRootPath = findRoot;
        }
        if (null != this.debugPort) {
            System.setProperty("debug", this.debugPort);
        }
        if (this.pushAll) {
            PushUtils.pushAllModules(sourceRootPath);
        } else if (this.argList != null && this.argList.size() == 1) {
            String moduleName = this.argList.get(0);
            PushUtils.pushModules(Collections.singletonList(moduleName), sourceRootPath);
        } else {
            if (this.argList == null || this.argList.size() == 0) {
                CommandUtil.printError(this.errStream, "Push command requires the name of the module. To push all modules use '-a' or '--all' flag.", "ballerina push {<module-name> | -a | --all}", false);
                Runtime.getRuntime().exit(1);
                return;
            }
            throw LauncherUtils.createUsageExceptionWithHelp((String)"too many arguments");
        }
        Runtime.getRuntime().exit(0);
    }

    public String getName() {
        return "push";
    }

    public void printLongDesc(StringBuilder out) {
        out.append("push modules to Ballerina Central");
    }

    public void printUsage(StringBuilder out) {
        out.append("  ballerina push <module-name> \n");
    }

    public void setParentCmdParser(CommandLine parentCmdParser) {
    }
}

