/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.packerina.cmd;

import java.io.IOException;
import java.io.PrintStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.List;
import org.ballerinalang.compiler.CompilerOptionName;
import org.ballerinalang.compiler.CompilerPhase;
import org.ballerinalang.packerina.TaskExecutor;
import org.ballerinalang.packerina.buildcontext.BuildContext;
import org.ballerinalang.packerina.buildcontext.sourcecontext.SourceType;
import org.ballerinalang.packerina.cmd.CommandUtil;
import org.ballerinalang.packerina.task.CleanTargetDirTask;
import org.ballerinalang.packerina.task.CompileTask;
import org.ballerinalang.packerina.task.CopyModuleJarTask;
import org.ballerinalang.packerina.task.CopyNativeLibTask;
import org.ballerinalang.packerina.task.CopyResourcesTask;
import org.ballerinalang.packerina.task.CreateBaloTask;
import org.ballerinalang.packerina.task.CreateBirTask;
import org.ballerinalang.packerina.task.CreateJarTask;
import org.ballerinalang.packerina.task.CreateTargetDirTask;
import org.ballerinalang.packerina.task.PrintExecutablePathTask;
import org.ballerinalang.packerina.task.PrintRunningExecutableTask;
import org.ballerinalang.packerina.task.RunExecutableTask;
import org.ballerinalang.tool.BLauncherCmd;
import org.ballerinalang.tool.LauncherUtils;
import org.wso2.ballerinalang.compiler.util.CompilerContext;
import org.wso2.ballerinalang.compiler.util.CompilerOptions;
import org.wso2.ballerinalang.util.RepoUtils;
import picocli.CommandLine;

@CommandLine.Command(name="run", description={"Build and execute a Ballerina program."})
public class RunCommand
implements BLauncherCmd {
    private final PrintStream outStream;
    private final PrintStream errStream;
    private boolean isInDebugMode = false;
    @CommandLine.Parameters(description={"Program arguments"})
    private List<String> argList;
    @CommandLine.Option(names={"--sourceroot"}, description={"Path to the directory containing source files and modules"})
    private String sourceRoot;
    @CommandLine.Option(names={"--help", "-h", "?"}, hidden=true)
    private boolean helpFlag;
    @CommandLine.Option(names={"--offline"}, description={"Builds offline without downloading dependencies and then run."})
    private boolean offline;
    @CommandLine.Option(names={"--debug"}, hidden=true)
    private String debugPort;
    @CommandLine.Option(names={"--native"}, hidden=true, description={"Compile Ballerina program to a native binary"})
    private boolean nativeBinary;
    @CommandLine.Option(names={"--dump-llvm-ir"}, hidden=true)
    private boolean dumpLLVMIR;
    @CommandLine.Option(names={"--no-optimize-llvm"}, hidden=true)
    private boolean noOptimizeLLVM;
    @CommandLine.Option(names={"--dump-bir"}, hidden=true)
    private boolean dumpBIR;
    @CommandLine.Option(names={"--experimental"}, description={"Enable experimental language features."})
    private boolean experimentalFlag;

    public RunCommand() {
        this.outStream = System.err;
        this.errStream = System.err;
    }

    public RunCommand(PrintStream outStream, PrintStream errStream) {
        this.outStream = outStream;
        this.errStream = errStream;
    }

    public void execute() {
        Path targetPath;
        Path sourcePath;
        Path sourceRootPath;
        if (this.helpFlag) {
            String commandUsageInfo = BLauncherCmd.getCommandUsageInfo((String)"run");
            this.errStream.println(commandUsageInfo);
            return;
        }
        if (this.argList == null || this.argList.size() == 0) {
            CommandUtil.printError(this.errStream, "no ballerina program given.", "ballerina run {<bal-file> | <module-name> | <executable-jar>}", true);
            Runtime.getRuntime().exit(1);
            return;
        }
        if (null != this.debugPort) {
            this.isInDebugMode = true;
            System.setProperty("debug", this.debugPort);
        }
        String[] programArgs = this.getProgramArgs(this.argList);
        Path path = sourceRootPath = this.sourceRoot == null ? Paths.get(System.getProperty("user.dir"), new String[0]) : Paths.get(this.sourceRoot, new String[0]);
        if (this.argList.get(0).endsWith(".bal")) {
            sourcePath = Paths.get(this.argList.get(0), new String[0]).isAbsolute() ? Paths.get(this.argList.get(0), new String[0]) : sourceRootPath.resolve(this.argList.get(0));
            sourceRootPath = sourcePath.getParent();
            if (Files.notExists(sourcePath, new LinkOption[0])) {
                CommandUtil.printError(this.errStream, "'" + sourcePath + "' Ballerina file does not exist.", null, false);
                Runtime.getRuntime().exit(1);
                return;
            }
            if (!Files.isRegularFile(sourcePath, new LinkOption[0])) {
                CommandUtil.printError(this.errStream, "'" + sourcePath + "' is not a Ballerina file. check if it is a symlink or a shortcut.", null, false);
                Runtime.getRuntime().exit(1);
                return;
            }
            try {
                targetPath = Files.createTempDirectory("ballerina-run-" + System.nanoTime(), new FileAttribute[0]);
            }
            catch (IOException e) {
                throw LauncherUtils.createLauncherException((String)"error occurred when creating executable.");
            }
        } else if (Files.exists(sourceRootPath.resolve("src").resolve(this.argList.get(0)), new LinkOption[0]) && Files.isDirectory(sourceRootPath.resolve("src").resolve(this.argList.get(0)), new LinkOption[0])) {
            if (!RepoUtils.isBallerinaProject((Path)sourceRootPath)) {
                CommandUtil.printError(this.errStream, "you are trying to run a module that is not inside a project.", null, false);
                Runtime.getRuntime().exit(1);
                return;
            }
            if (Paths.get(this.argList.get(0), new String[0]).isAbsolute()) {
                CommandUtil.printError(this.errStream, "you are trying to run a module by giving the absolute path. you only need give the name of the module.", "ballerina run <module-name>", true);
                Runtime.getRuntime().exit(1);
                return;
            }
            String moduleName = this.argList.get(0);
            if (moduleName.endsWith("/")) {
                moduleName = moduleName.substring(0, moduleName.length() - 1);
            }
            sourcePath = Paths.get(moduleName, new String[0]);
            if (Files.notExists(sourceRootPath.resolve("src").resolve(sourcePath), new LinkOption[0])) {
                CommandUtil.printError(this.errStream, "'" + sourcePath + "' module does not exist.", "ballerina run <module-name>", true);
                Runtime.getRuntime().exit(1);
                return;
            }
            targetPath = sourceRootPath.resolve("target");
        } else {
            CommandUtil.printError(this.errStream, "invalid Ballerina source path. It should either be a name of a module in a Ballerina project, a file with a '.bal' extension, or an executable '.jar' file.", "ballerina run {<bal-file> | <module-name> | <executable-jar>}", true);
            Runtime.getRuntime().exit(1);
            return;
        }
        sourceRootPath = sourceRootPath.normalize();
        sourcePath = sourcePath == null ? null : sourcePath.normalize();
        targetPath = targetPath.normalize();
        CompilerContext compilerContext = new CompilerContext();
        CompilerOptions options = CompilerOptions.getInstance((CompilerContext)compilerContext);
        options.put(CompilerOptionName.PROJECT_DIR, sourceRootPath.toString());
        options.put(CompilerOptionName.OFFLINE, Boolean.toString(this.offline));
        options.put(CompilerOptionName.COMPILER_PHASE, CompilerPhase.BIR_GEN.toString());
        options.put(CompilerOptionName.LOCK_ENABLED, Boolean.toString(true));
        options.put(CompilerOptionName.SKIP_TESTS, Boolean.toString(true));
        options.put(CompilerOptionName.TEST_ENABLED, Boolean.toString(false));
        options.put(CompilerOptionName.EXPERIMENTAL_FEATURES_ENABLED, Boolean.toString(this.experimentalFlag));
        BuildContext buildContext = new BuildContext(sourceRootPath, targetPath, sourcePath, compilerContext);
        buildContext.setOut(this.outStream);
        buildContext.setErr(this.errStream);
        boolean isSingleFileBuild = buildContext.getSourceType().equals((Object)SourceType.SINGLE_BAL_FILE);
        TaskExecutor taskExecutor = new TaskExecutor.TaskBuilder().addTask(new CleanTargetDirTask(), isSingleFileBuild).addTask(new CreateTargetDirTask()).addTask(new CompileTask()).addTask(new CreateBaloTask(), isSingleFileBuild).addTask(new CreateBirTask()).addTask(new CopyNativeLibTask()).addTask(new CreateJarTask(this.dumpBIR)).addTask(new CopyResourcesTask(), isSingleFileBuild).addTask(new CopyModuleJarTask(false, true)).addTask(new PrintExecutablePathTask(), isSingleFileBuild).addTask(new PrintRunningExecutableTask(!isSingleFileBuild)).addTask(new RunExecutableTask(programArgs, this.isInDebugMode)).build();
        taskExecutor.executeTasks(buildContext);
    }

    private String[] getProgramArgs(List<String> argList) {
        String[] argsArray = argList.toArray(new String[0]);
        return Arrays.copyOfRange(argsArray, 1, argsArray.length);
    }

    public String getName() {
        return "run";
    }

    public void printLongDesc(StringBuilder out) {
        out.append("Run command runs a compiled Ballerina program. \n");
        out.append("\n");
        out.append("If a Ballerina source file or a module is given, \n");
        out.append("run command compiles and runs it. \n");
        out.append("\n");
        out.append("By default, 'ballerina run' executes the main function. \n");
        out.append("If the main function is not there, it executes services. \n");
        out.append("\n");
        out.append("If the -s flag is given, 'ballerina run' executes\n");
        out.append("services instead of the main function.\n");
    }

    public void printUsage(StringBuilder out) {
        out.append("  ballerina run [--offline]\n                [--sourceroot]\n                {<balfile> | module-name | executable-jar} [(--key=value)...] [--] [args...] \n");
    }

    public void setParentCmdParser(CommandLine parentCmdParser) {
    }
}

