/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.packerina.cmd;

import java.io.IOException;
import java.io.PrintStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.List;
import org.ballerinalang.compiler.CompilerOptionName;
import org.ballerinalang.compiler.CompilerPhase;
import org.ballerinalang.jvm.launch.LaunchUtils;
import org.ballerinalang.packerina.TaskExecutor;
import org.ballerinalang.packerina.buildcontext.BuildContext;
import org.ballerinalang.packerina.buildcontext.sourcecontext.SourceType;
import org.ballerinalang.packerina.cmd.CommandUtil;
import org.ballerinalang.packerina.task.CleanTargetDirTask;
import org.ballerinalang.packerina.task.CompileTask;
import org.ballerinalang.packerina.task.CopyModuleJarTask;
import org.ballerinalang.packerina.task.CopyNativeLibTask;
import org.ballerinalang.packerina.task.CopyResourcesTask;
import org.ballerinalang.packerina.task.CreateBaloTask;
import org.ballerinalang.packerina.task.CreateBirTask;
import org.ballerinalang.packerina.task.CreateJarTask;
import org.ballerinalang.packerina.task.CreateTargetDirTask;
import org.ballerinalang.packerina.task.ListTestGroupsTask;
import org.ballerinalang.packerina.task.RunTestsTask;
import org.ballerinalang.tool.BLauncherCmd;
import org.ballerinalang.tool.LauncherUtils;
import org.wso2.ballerinalang.compiler.util.CompilerContext;
import org.wso2.ballerinalang.compiler.util.CompilerOptions;
import org.wso2.ballerinalang.compiler.util.ProjectDirs;
import org.wso2.ballerinalang.util.RepoUtils;
import picocli.CommandLine;

@CommandLine.Command(name="test", description={"Test Ballerina modules"})
public class TestCommand
implements BLauncherCmd {
    private final PrintStream outStream;
    private final PrintStream errStream;
    private Path sourceRootPath;
    private boolean exitWhenFinish;
    private boolean skipCopyLibsFromDist;
    @CommandLine.Option(names={"--sourceroot"}, description={"Path to the directory containing source files and modules"})
    private String sourceRoot;
    @CommandLine.Option(names={"--all", "-a"}, description={"Build or compile all the modules of the project."})
    private boolean buildAll;
    @CommandLine.Option(names={"--offline"}, description={"Builds/Compiles offline without downloading dependencies."})
    private boolean offline;
    @CommandLine.Option(names={"--skip-lock"}, description={"Skip using the lock file to resolve dependencies."})
    private boolean skipLock;
    @CommandLine.Parameters
    private List<String> argList;
    @CommandLine.Option(names={"--native"}, hidden=true, description={"Compile Ballerina program to a native binary"})
    private boolean nativeBinary;
    @CommandLine.Option(names={"--dump-bir"}, hidden=true)
    private boolean dumpBIR;
    @CommandLine.Option(names={"--dump-llvm-ir"}, hidden=true)
    private boolean dumpLLVMIR;
    @CommandLine.Option(names={"--no-optimize-llvm"}, hidden=true)
    private boolean noOptimizeLLVM;
    @CommandLine.Option(names={"--help", "-h"}, hidden=true)
    private boolean helpFlag;
    @CommandLine.Option(names={"--experimental"}, description={"Enable experimental language features."})
    private boolean experimentalFlag;
    @CommandLine.Option(names={"--debug"}, description={"start Ballerina in remote debugging mode"})
    private String debugPort;
    @CommandLine.Option(names={"--list-groups"}, description={"list the groups available in the tests"})
    private boolean listGroups;
    @CommandLine.Option(names={"--groups"}, split=",", description={"test groups to be executed"})
    private List<String> groupList;
    @CommandLine.Option(names={"--disable-groups"}, split=",", description={"test groups to be disabled"})
    private List<String> disableGroupList;
    @CommandLine.Option(names={"--test-report"}, description={"enable test report generation"})
    private boolean testReport;
    @CommandLine.Option(names={"--code-coverage"}, description={"enable code coverage"})
    private boolean coverage;

    public TestCommand() {
        this.sourceRootPath = Paths.get(System.getProperty("user.dir"), new String[0]);
        this.outStream = System.out;
        this.errStream = System.err;
        this.exitWhenFinish = true;
        this.skipCopyLibsFromDist = false;
    }

    public TestCommand(Path userDir, PrintStream outStream, PrintStream errStream, boolean exitWhenFinish, boolean skipCopyLibsFromDist) {
        this.sourceRootPath = userDir;
        this.outStream = outStream;
        this.errStream = errStream;
        this.exitWhenFinish = exitWhenFinish;
        this.skipCopyLibsFromDist = skipCopyLibsFromDist;
    }

    public void execute() {
        if (this.helpFlag) {
            String commandUsageInfo = BLauncherCmd.getCommandUsageInfo((String)"test");
            this.errStream.println(commandUsageInfo);
            return;
        }
        String[] args = this.argList == null ? new String[]{} : (this.buildAll ? this.argList.toArray(new String[0]) : this.argList.subList(1, this.argList.size()).toArray(new String[0]));
        String[] userArgs = LaunchUtils.getUserArgs((String[])args, new HashMap());
        if (userArgs.length > 0) {
            CommandUtil.printError(this.errStream, "too many arguments.", "ballerina test [--offline] [--sourceroot <path>] [--experimental] [--skip-lock]\n                      [<module-name> | -a | --all]  [--] [(--key=value)...]", false);
            CommandUtil.exitError(this.exitWhenFinish);
            return;
        }
        if (!(this.buildAll || this.argList != null && this.argList.size() != 0)) {
            CommandUtil.printError(this.errStream, "'test' command requires a module name or '-a | --all' flag to test all the modules of the project.", "ballerina test <module-name> | -a | --all", false);
            CommandUtil.exitError(this.exitWhenFinish);
            return;
        }
        this.sourceRootPath = null != this.sourceRoot ? Paths.get(this.sourceRoot, new String[0]).toAbsolutePath() : this.sourceRootPath;
        Path sourcePath = null;
        Path targetPath = this.sourceRootPath.resolve("target");
        if (this.groupList != null && this.disableGroupList != null) {
            CommandUtil.printError(this.errStream, "Cannot specify both --groups and --disable-groups flags at the same time", "ballerina test --groups <group1, ...> <module-name> | -a | --all", true);
            CommandUtil.exitError(this.exitWhenFinish);
            return;
        }
        if (this.listGroups && this.disableGroupList != null || this.listGroups && this.groupList != null) {
            CommandUtil.printError(this.errStream, "Cannot specify both --list-groups and --disable-groups/--groups flags at the same time", "ballerina test --list-groups <module-name> | -a | --all", true);
            CommandUtil.exitError(this.exitWhenFinish);
            return;
        }
        if (this.buildAll) {
            if (!ProjectDirs.isProject((Path)this.sourceRootPath)) {
                Path findRoot = ProjectDirs.findProjectRoot((Path)this.sourceRootPath);
                if (null == findRoot) {
                    CommandUtil.printError(this.errStream, "you are trying to test a Ballerina project but there is no Ballerina.toml file.", null, false);
                    CommandUtil.exitError(this.exitWhenFinish);
                    return;
                }
                this.sourceRootPath = findRoot;
            }
        } else if (this.argList.get(0).endsWith(".bal")) {
            if (this.coverage) {
                this.coverage = false;
                this.outStream.println("Code coverage is not yet supported with single bal files. Ignoring the flag and continuing the test run...");
            }
            sourcePath = Paths.get(this.argList.get(0), new String[0]).isAbsolute() ? Paths.get(this.argList.get(0), new String[0]) : this.sourceRootPath.resolve(this.argList.get(0));
            this.sourceRootPath = sourcePath.getParent();
            if (ProjectDirs.findProjectRoot((Path)this.sourceRootPath) != null) {
                CommandUtil.printError(this.errStream, "you are trying to test a single file within a ballerina project. To run tests within a project, the module name must be specified.", "ballerina test <module-name>", false);
                Runtime.getRuntime().exit(1);
                return;
            }
            if (Files.notExists(sourcePath, new LinkOption[0])) {
                CommandUtil.printError(this.errStream, "'" + sourcePath + "' Ballerina file does not exist", null, false);
                Runtime.getRuntime().exit(1);
                return;
            }
            if (!Files.isRegularFile(sourcePath, new LinkOption[0])) {
                CommandUtil.printError(this.errStream, "'" + sourcePath + "' is not a Ballerina file. check if it is a symlink or shortcut.", null, false);
                Runtime.getRuntime().exit(1);
                return;
            }
            try {
                targetPath = Files.createTempDirectory("ballerina-test-" + System.nanoTime(), new FileAttribute[0]);
            }
            catch (IOException e) {
                throw LauncherUtils.createLauncherException((String)"error occured when creating executable.");
            }
        } else if (Files.exists(this.sourceRootPath.resolve("src").resolve(this.argList.get(0)), new LinkOption[0]) && Files.isDirectory(this.sourceRootPath.resolve("src").resolve(this.argList.get(0)), new LinkOption[0])) {
            if (!RepoUtils.isBallerinaProject((Path)this.sourceRootPath)) {
                CommandUtil.printError(this.errStream, "you are trying to test a module that is not inside a project.", null, false);
                CommandUtil.exitError(this.exitWhenFinish);
                return;
            }
            if (Paths.get(this.argList.get(0), new String[0]).isAbsolute()) {
                CommandUtil.printError(this.errStream, "you are trying to test a module by giving the absolute path. you only need give the name of the module.", "ballerina test <module-name>", true);
                CommandUtil.exitError(this.exitWhenFinish);
                return;
            }
            String moduleName = this.argList.get(0);
            if (moduleName.endsWith("/")) {
                moduleName = moduleName.substring(0, moduleName.length() - 1);
            }
            sourcePath = Paths.get(moduleName, new String[0]);
            if (Files.notExists(this.sourceRootPath.resolve("src").resolve(sourcePath), new LinkOption[0])) {
                CommandUtil.printError(this.errStream, "'" + sourcePath + "' module does not exist.", "ballerina test <module-name>", true);
                CommandUtil.exitError(this.exitWhenFinish);
                return;
            }
        } else {
            CommandUtil.printError(this.errStream, "invalid Ballerina project", "ballerina test  <module-name> | -a | --all", true);
            CommandUtil.exitError(this.exitWhenFinish);
            return;
        }
        this.sourceRootPath = this.sourceRootPath.normalize();
        sourcePath = sourcePath == null ? null : sourcePath.normalize();
        targetPath = targetPath.normalize();
        CompilerContext compilerContext = new CompilerContext();
        CompilerOptions options = CompilerOptions.getInstance((CompilerContext)compilerContext);
        options.put(CompilerOptionName.PROJECT_DIR, this.sourceRootPath.toString());
        options.put(CompilerOptionName.OFFLINE, Boolean.toString(this.offline));
        options.put(CompilerOptionName.COMPILER_PHASE, CompilerPhase.BIR_GEN.toString());
        options.put(CompilerOptionName.LOCK_ENABLED, Boolean.toString(!this.skipLock));
        options.put(CompilerOptionName.TEST_ENABLED, "true");
        options.put(CompilerOptionName.SKIP_TESTS, "false");
        options.put(CompilerOptionName.EXPERIMENTAL_FEATURES_ENABLED, Boolean.toString(this.experimentalFlag));
        BuildContext buildContext = new BuildContext(this.sourceRootPath, targetPath, sourcePath, compilerContext);
        buildContext.setOut(this.outStream);
        buildContext.setErr(this.errStream);
        boolean isSingleFileBuild = buildContext.getSourceType().equals((Object)SourceType.SINGLE_BAL_FILE);
        TaskExecutor taskExecutor = new TaskExecutor.TaskBuilder().addTask(new CleanTargetDirTask(), isSingleFileBuild).addTask(new CreateTargetDirTask()).addTask(new CompileTask()).addTask(new CreateBaloTask(), isSingleFileBuild || this.listGroups).addTask(new CreateBirTask(), this.listGroups).addTask(new CopyNativeLibTask(this.skipCopyLibsFromDist), this.listGroups).addTask(new CreateJarTask(this.dumpBIR, this.skipCopyLibsFromDist), this.listGroups).addTask(new CopyResourcesTask(), isSingleFileBuild || this.listGroups).addTask(new CopyModuleJarTask(this.skipCopyLibsFromDist, false), this.listGroups).addTask(new ListTestGroupsTask(), !this.listGroups).addTask(new RunTestsTask(this.testReport, this.coverage, args, this.groupList, this.disableGroupList), this.listGroups).build();
        taskExecutor.executeTasks(buildContext);
        if (this.exitWhenFinish) {
            Runtime.getRuntime().exit(0);
        }
    }

    public String getName() {
        return "test";
    }

    public void printLongDesc(StringBuilder out) {
        out.append("Compiles Ballerina modules and create balo files. \n");
    }

    public void printUsage(StringBuilder out) {
        out.append(" ballerina test [--offline] [--sourceroot <path>] [--experimental] [--skip-lock]\n[<module-name> | -a | --all] [--] [(--key=value)...]\n");
    }

    public void setParentCmdParser(CommandLine parentCmdParser) {
    }
}

