/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.packerina.task;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Map;
import org.ballerinalang.docgen.docs.BallerinaDocGenerator;
import org.ballerinalang.packerina.buildcontext.BuildContext;
import org.ballerinalang.packerina.buildcontext.BuildContextField;
import org.ballerinalang.packerina.buildcontext.sourcecontext.SourceType;
import org.ballerinalang.packerina.task.Task;
import org.ballerinalang.tool.LauncherUtils;
import org.wso2.ballerinalang.compiler.tree.BLangPackage;

public class CreateDocsTask
implements Task {
    private Path output;

    public CreateDocsTask(Path output) {
        this.output = output;
    }

    @Override
    public void execute(BuildContext buildContext) {
        Path sourceRootPath = (Path)buildContext.get(BuildContextField.SOURCE_ROOT);
        Path targetDir = (Path)buildContext.get(BuildContextField.TARGET_DIR);
        boolean isSingleFileBuild = buildContext.getSourceType().equals((Object)SourceType.SINGLE_BAL_FILE);
        Path outputPath = isSingleFileBuild ? this.output : targetDir.resolve("apidocs");
        List<BLangPackage> modules = buildContext.getModules();
        buildContext.out().println();
        buildContext.out().println("Generating API Documentation");
        try {
            BallerinaDocGenerator.setPrintStream((PrintStream)new EmptyPrintStream());
            Map moduleDocMap = BallerinaDocGenerator.generateModuleDocsFromBLangPackages((String)sourceRootPath.toString(), modules);
            Files.createDirectories(outputPath, new FileAttribute[0]);
            BallerinaDocGenerator.writeAPIDocsForModules((Map)moduleDocMap, (String)outputPath.toString());
            buildContext.out().println("\t" + sourceRootPath.relativize(outputPath).toString());
        }
        catch (IOException e) {
            throw LauncherUtils.createLauncherException((String)"Unable to generate API Documentation.");
        }
    }

    static class EmptyPrintStream
    extends PrintStream {
        EmptyPrintStream() throws UnsupportedEncodingException {
            super(new OutputStream(){

                @Override
                public void write(int b) {
                }
            }, true, "UTF-8");
        }
    }
}

