/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.packerina.task;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.ballerinalang.config.ConfigRegistry;
import org.ballerinalang.model.elements.PackageID;
import org.ballerinalang.packerina.buildcontext.BuildContext;
import org.ballerinalang.packerina.buildcontext.BuildContextField;
import org.ballerinalang.packerina.task.Task;
import org.wso2.ballerinalang.compiler.PackageCache;
import org.wso2.ballerinalang.compiler.bir.BackendDriver;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BPackageSymbol;
import org.wso2.ballerinalang.compiler.tree.BLangPackage;
import org.wso2.ballerinalang.compiler.util.CompilerContext;
import org.wso2.ballerinalang.compiler.util.ProjectDirs;
import org.wso2.ballerinalang.util.RepoUtils;

public class CreateJarTask
implements Task {
    private boolean dumpBir;
    private boolean skipCopyLibsFromDist = false;

    public CreateJarTask(boolean dumpBir) {
        this.dumpBir = dumpBir;
    }

    public CreateJarTask(boolean dumpBir, boolean skipCopyLibsFromDist) {
        this.dumpBir = dumpBir;
        this.skipCopyLibsFromDist = skipCopyLibsFromDist;
    }

    @Override
    public void execute(BuildContext buildContext) {
        ConfigRegistry.getInstance().setInitialized(true);
        Path sourceRoot = (Path)buildContext.get(BuildContextField.SOURCE_ROOT);
        String balHomePath = buildContext.get(BuildContextField.HOME_REPO).toString();
        Path runtimeJar = this.getRuntimeAllJar(buildContext);
        CompilerContext context = (CompilerContext)buildContext.get(BuildContextField.COMPILER_CONTEXT);
        PackageCache packageCache = PackageCache.getInstance((CompilerContext)context);
        BackendDriver backendDriver = BackendDriver.getInstance((CompilerContext)context);
        List<BLangPackage> moduleBirMap = buildContext.getModules();
        HashSet<PackageID> alreadyImportedModuleSet = new HashSet<PackageID>();
        for (BLangPackage module : moduleBirMap) {
            BLangPackage bLangPackage = packageCache.get(module.packageID);
            if (bLangPackage == null) continue;
            PackageID packageID = bLangPackage.packageID;
            HashSet<Path> moduleDependencies = buildContext.moduleDependencyPathMap.get((Object)packageID).moduleLibs;
            if (!this.skipCopyLibsFromDist) {
                moduleDependencies.add(runtimeJar);
            }
            this.writeImportJar(backendDriver, bLangPackage.symbol.imports, sourceRoot, buildContext, runtimeJar, alreadyImportedModuleSet, balHomePath);
            Path jarOutput = buildContext.getJarPathFromTargetCache(module.packageID);
            if (!Files.exists(jarOutput, new LinkOption[0])) {
                backendDriver.execute(bLangPackage.symbol.bir, this.dumpBir, jarOutput, moduleDependencies);
                alreadyImportedModuleSet.add(module.packageID);
            }
            if (buildContext.skipTests() || !bLangPackage.hasTestablePackage()) continue;
            for (BLangPackage testPkg : bLangPackage.getTestablePkgs()) {
                this.writeImportJar(backendDriver, testPkg.symbol.imports, sourceRoot, buildContext, runtimeJar, alreadyImportedModuleSet, balHomePath);
                Path testJarOutput = buildContext.getTestJarPathFromTargetCache(testPkg.packageID);
                if (Files.exists(testJarOutput, new LinkOption[0])) continue;
                backendDriver.execute(testPkg.symbol.bir, this.dumpBir, testJarOutput, moduleDependencies);
                alreadyImportedModuleSet.add(testPkg.packageID);
            }
        }
        ConfigRegistry.getInstance().setInitialized(false);
    }

    private void writeImportJar(BackendDriver backendDriver, List<BPackageSymbol> imports, Path sourceRoot, BuildContext buildContext, Path runtimeJar, Set<PackageID> alreadyImportedModuleSet, String balHomePath) {
        for (BPackageSymbol bimport : imports) {
            PackageID id = bimport.pkgID;
            String version = "0.0.0";
            if (!id.version.value.equals("")) {
                version = id.version.value;
            }
            if (alreadyImportedModuleSet.contains(id) || Paths.get(balHomePath, "bir-cache", id.orgName.value, id.name.value, version).toFile().exists()) continue;
            alreadyImportedModuleSet.add(id);
            Path jarFilePath = ProjectDirs.isModuleExist((Path)sourceRoot, (String)id.name.value) || buildContext.getImportPathDependency(id).isPresent() ? buildContext.getJarPathFromTargetCache(id) : buildContext.getJarPathFromHomeCache(id);
            this.writeImportJar(backendDriver, bimport.imports, sourceRoot, buildContext, runtimeJar, alreadyImportedModuleSet, balHomePath);
            if (bimport.bir == null || !buildContext.moduleDependencyPathMap.containsKey(id)) continue;
            HashSet<Path> moduleDependencySet = buildContext.moduleDependencyPathMap.get((Object)id).moduleLibs;
            if (!this.skipCopyLibsFromDist) {
                moduleDependencySet.add(runtimeJar);
            }
            backendDriver.execute(bimport.bir, this.dumpBir, jarFilePath, moduleDependencySet);
        }
    }

    private Path getRuntimeAllJar(BuildContext buildContext) {
        if (this.skipCopyLibsFromDist) {
            return null;
        }
        String balHomePath = buildContext.get(BuildContextField.HOME_REPO).toString();
        String ballerinaVersion = RepoUtils.getBallerinaVersion();
        String runtimeJarName = "ballerina-rt-" + ballerinaVersion + ".jar";
        return Paths.get(balHomePath, "bre", "lib", runtimeJarName);
    }
}

