/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.packerina.cmd;

import com.moandjiezana.toml.Toml;
import java.io.IOException;
import java.io.PrintStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.nio.file.AccessDeniedException;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.ballerinalang.packerina.cmd.CommandUtil;
import org.ballerinalang.toml.model.Module;
import org.ballerinalang.tool.BLauncherCmd;
import org.wso2.ballerinalang.compiler.util.ProjectDirs;
import org.wso2.ballerinalang.util.RepoUtils;
import picocli.CommandLine;

@CommandLine.Command(name="add", description={"Add a new module to Ballerina project"})
public class AddCommand
implements BLauncherCmd {
    private Path userDir;
    private PrintStream errStream;
    private static FileSystem jarFs;
    private static Map<String, String> env;
    private Path homeCache;
    @CommandLine.Parameters
    private List<String> argList;
    @CommandLine.Option(names={"--help", "-h"}, hidden=true)
    private boolean helpFlag;
    @CommandLine.Option(names={"--template", "-t"})
    private String template = "main";
    @CommandLine.Option(names={"--list", "-l"})
    private boolean list = false;

    public AddCommand() {
        this.userDir = Paths.get(System.getProperty("user.dir"), new String[0]);
        this.errStream = System.err;
        this.homeCache = RepoUtils.createAndGetHomeReposPath();
        this.initJarFs();
    }

    public AddCommand(Path userDir, PrintStream errStream) {
        this(userDir, errStream, RepoUtils.createAndGetHomeReposPath());
    }

    public AddCommand(Path userDir, PrintStream errStream, Path homeCache) {
        this.userDir = userDir;
        this.errStream = errStream;
        this.initJarFs();
        this.homeCache = homeCache;
    }

    private void initJarFs() {
        URI uri = null;
        try {
            uri = AddCommand.class.getClassLoader().getResource("create_cmd_templates").toURI();
            if (uri.toString().contains("!")) {
                String[] array = uri.toString().split("!");
                if (null == jarFs) {
                    env = new HashMap<String, String>();
                    jarFs = FileSystems.newFileSystem(URI.create(array[0]), env);
                }
            }
        }
        catch (IOException | URISyntaxException e) {
            throw new AssertionError();
        }
    }

    public void execute() {
        if (this.helpFlag) {
            String commandUsageInfo = BLauncherCmd.getCommandUsageInfo((String)"add");
            this.errStream.println(commandUsageInfo);
            return;
        }
        if (this.list) {
            this.errStream.println("Available templates:");
            for (String template : this.getTemplates()) {
                this.errStream.println("    - " + template);
            }
            for (String template : this.getBaloTemplates()) {
                this.errStream.println("    - " + template);
            }
            return;
        }
        Path projectPath = ProjectDirs.findProjectRoot((Path)this.userDir);
        if (null == projectPath) {
            CommandUtil.printError(this.errStream, "not a ballerina project (or any parent up to mount point)\nYou should run this command inside a ballerina project", null, false);
            return;
        }
        if (null == this.argList) {
            CommandUtil.printError(this.errStream, "The following required arguments were not provided:\n    <module-name>", "ballerina add <module-name> [-t|--template <template-name>]", true);
            return;
        }
        if (1 != this.argList.size()) {
            CommandUtil.printError(this.errStream, "too many arguments.", "ballerina add <project-name>", true);
            return;
        }
        String moduleName = this.argList.get(0);
        boolean matches = RepoUtils.validatePkg((String)moduleName);
        if (!matches) {
            CommandUtil.printError(this.errStream, "Invalid module name : '" + moduleName + "' :\nModule name can only contain alphanumerics, underscores and periods and the maximum length is 256 characters", null, false);
            return;
        }
        if (ProjectDirs.isModuleExist((Path)projectPath, (String)moduleName)) {
            CommandUtil.printError(this.errStream, "A module already exists with the given name : '" + moduleName + "' :\nExisting module path " + projectPath.resolve("src").resolve(moduleName), null, false);
            return;
        }
        if (!this.getTemplates().contains(this.template) && this.findBaloTemplate(this.template) == null) {
            CommandUtil.printError(this.errStream, "Template not found, use `ballerina add --list` to view available templates.", null, false);
            return;
        }
        try {
            this.createModule(projectPath, moduleName, this.template);
        }
        catch (ModuleCreateException e) {
            CommandUtil.printError(this.errStream, "Error occurred while creating module : " + e.getMessage(), null, false);
            return;
        }
        this.errStream.println("Added new ballerina module at '" + this.userDir.relativize(projectPath.resolve("src").resolve(moduleName)) + "'");
    }

    public String getName() {
        return "add";
    }

    public void printLongDesc(StringBuilder out) {
        out.append("add a new ballerina module");
    }

    public void printUsage(StringBuilder out) {
        out.append("  ballerina add <module-name> [-t|--template <template-name>]\n");
    }

    public void setParentCmdParser(CommandLine parentCmdParser) {
    }

    private void createModule(Path projectPath, String moduleName, String template) throws ModuleCreateException {
        Path modulePath = projectPath.resolve("src").resolve(moduleName);
        try {
            Files.createDirectories(modulePath, new FileAttribute[0]);
            if (this.getTemplates().contains(template)) {
                this.applyTemplate(modulePath, template);
            } else {
                this.applyBaloTemplate(modulePath, template);
            }
        }
        catch (AccessDeniedException e) {
            throw new ModuleCreateException("Insufficient Permission");
        }
        catch (IOException | TemplateException e) {
            throw new ModuleCreateException(e.getMessage());
        }
    }

    private void applyBaloTemplate(Path modulePath, String template) {
        Path baloTemplate = this.findBaloTemplate(template);
        if (baloTemplate != null) {
            String moduleName = this.getModuleName(baloTemplate);
            URI zipURI = URI.create("jar:" + baloTemplate.toUri().toString());
            try (FileSystem zipfs = FileSystems.newFileSystem(zipURI, new HashMap());){
                Path srcDir = zipfs.getPath("/src", new String[0]).resolve(moduleName);
                Files.walkFileTree(srcDir, new Copy(srcDir, modulePath));
                Path resourcesDir = zipfs.getPath("/resources", new String[0]);
                Path moduleResources = modulePath.resolve("resources");
                Files.createDirectories(moduleResources, new FileAttribute[0]);
                Files.walkFileTree(resourcesDir, new Copy(resourcesDir, moduleResources));
                Path moduleMd = zipfs.getPath("/docs", new String[0]).resolve("Module.md");
                Path toModuleMd = modulePath.resolve("Module.md");
                Files.copy(moduleMd, toModuleMd, StandardCopyOption.REPLACE_EXISTING);
            }
            catch (IOException e) {
                CommandUtil.printError(this.errStream, "Error while applying template : " + e.getMessage(), null, false);
                Runtime.getRuntime().exit(1);
            }
        }
    }

    private String getModuleName(Path baloTemplate) {
        Path baloName = baloTemplate.getFileName();
        if (baloName != null) {
            String fileName = baloName.toString();
            return fileName.split("-")[0];
        }
        return "";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Path findBaloTemplate(String template) {
        String[] orgSplit = template.split("/");
        String orgName = orgSplit[0].trim();
        String moduleName = "";
        String version = "*";
        String modulePart = orgSplit.length > 1 ? orgSplit[1] : "";
        String[] moduleSplit = modulePart.split(":");
        moduleName = moduleSplit[0].trim();
        version = moduleSplit.length > 1 ? moduleSplit[1].trim() : version;
        String baloGlob = "glob:**/" + orgName + "/" + moduleName + "/" + version + "/*.balo";
        PathMatcher pathMatcher = FileSystems.getDefault().getPathMatcher(baloGlob);
        Path baloCache = this.homeCache.resolve("balo_cache");
        try (Stream<Path> walk = Files.walk(baloCache, new FileVisitOption[0]);){
            List baloList = walk.filter(pathMatcher::matches).collect(Collectors.toList());
            Collections.sort(baloList);
            if (baloList.size() > 0) {
                Path path2 = (Path)baloList.get(baloList.size() - 1);
                return path2;
            }
            Path path = null;
            return path;
        }
        catch (IOException e) {
            CommandUtil.printError(this.errStream, "Unable to read home cache", null, false);
            Runtime.getRuntime().exit(1);
            return this.homeCache.resolve("balo_cache");
        }
    }

    private List<String> getTemplates() {
        try {
            Path templateDir = this.getTemplatePath();
            Stream<Path> walk = Files.walk(templateDir, 1, new FileVisitOption[0]);
            List<String> templates = walk.filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])).filter(directory -> !templateDir.equals(directory)).filter(directory -> directory.getFileName() != null).map(directory -> directory.getFileName()).map(fileName -> fileName.toString()).collect(Collectors.toList());
            if (null != jarFs) {
                return templates.stream().map(t -> t.replace(jarFs.getSeparator(), "")).collect(Collectors.toList());
            }
            return templates;
        }
        catch (IOException | TemplateException e) {
            return new ArrayList<String>();
        }
    }

    private List<String> getBaloTemplates() {
        List<String> templates = new ArrayList<String>();
        Path baloCache = this.homeCache.resolve("balo_cache");
        PathMatcher pathMatcher = FileSystems.getDefault().getPathMatcher("glob:**/*.balo");
        try (Stream<Path> walk = Files.walk(baloCache, new FileVisitOption[0]);){
            List baloList = walk.filter(pathMatcher::matches).filter(this::isTemplateBalo).collect(Collectors.toList());
            templates = baloList.stream().map(this::getModuleToml).filter(o -> o != null).map(m -> m.getModule_organization() + "/" + m.getModule_name()).distinct().collect(Collectors.toList());
        }
        catch (IOException e) {
            CommandUtil.printError(this.errStream, "Unable to read home cache", null, false);
            Runtime.getRuntime().exit(1);
        }
        return templates;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Module getModuleToml(Path baloPath) {
        URI zipURI = URI.create("jar:" + baloPath.toUri().toString());
        try (FileSystem zipfs = FileSystems.newFileSystem(zipURI, new HashMap());){
            Path metaDataToml = zipfs.getPath("metadata", "MODULE.toml");
            String content = new String(Files.readAllBytes(metaDataToml), Charset.forName("UTF-8"));
            Toml toml = new Toml().read(content);
            Module module = (Module)toml.to(Module.class);
            return module;
        }
        catch (IOException e) {
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isTemplateBalo(Path baloPath) {
        URI zipURI = URI.create("jar:" + baloPath.toUri().toString());
        try (FileSystem zipfs = FileSystems.newFileSystem(zipURI, new HashMap());){
            Path metaDataToml = zipfs.getPath("metadata", "MODULE.toml");
            boolean bl = new String(Files.readAllBytes(metaDataToml), Charset.forName("UTF-8")).contains("template = \"true\"");
            return bl;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    private Path getTemplatePath() throws TemplateException {
        try {
            URI uri = this.getClass().getClassLoader().getResource("create_cmd_templates").toURI();
            if (uri.toString().contains("!")) {
                String[] array = uri.toString().split("!");
                return jarFs.getPath(array[1], new String[0]);
            }
            return Paths.get(uri);
        }
        catch (URISyntaxException e) {
            throw new TemplateException(e.getMessage());
        }
    }

    private void applyTemplate(Path modulePath, String template) throws TemplateException {
        Path templateDir = this.getTemplatePath().resolve(template);
        try {
            Files.walkFileTree(templateDir, new Copy(templateDir, modulePath));
        }
        catch (IOException e) {
            throw new TemplateException(e.getMessage());
        }
    }

    static class ModuleCreateException
    extends Exception {
        public ModuleCreateException(String message) {
            super(message);
        }
    }

    static class TemplateException
    extends Exception {
        public TemplateException(String message) {
            super(message);
        }
    }

    static class Copy
    extends SimpleFileVisitor<Path> {
        private Path fromPath;
        private Path toPath;
        private StandardCopyOption copyOption;

        public Copy(Path fromPath, Path toPath, StandardCopyOption copyOption) {
            this.fromPath = fromPath;
            this.toPath = toPath;
            this.copyOption = copyOption;
        }

        public Copy(Path fromPath, Path toPath) {
            this(fromPath, toPath, StandardCopyOption.REPLACE_EXISTING);
        }

        @Override
        public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
            Path targetPath = this.toPath.resolve(this.fromPath.relativize(dir).toString());
            if (!Files.exists(targetPath, new LinkOption[0])) {
                Files.createDirectory(targetPath, new FileAttribute[0]);
            }
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
            Files.copy(file, this.toPath.resolve(this.fromPath.relativize(file).toString()), this.copyOption);
            return FileVisitResult.CONTINUE;
        }
    }
}

