/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.packerina.cmd;

import java.io.PrintStream;
import java.net.URI;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.ballerinalang.model.elements.PackageID;
import org.ballerinalang.packerina.cmd.CommandUtil;
import org.ballerinalang.tool.BLauncherCmd;
import org.ballerinalang.tool.LauncherUtils;
import org.wso2.ballerinalang.compiler.packaging.Patten;
import org.wso2.ballerinalang.compiler.packaging.converters.Converter;
import org.wso2.ballerinalang.compiler.packaging.repo.RemoteRepo;
import org.wso2.ballerinalang.compiler.util.Name;
import org.wso2.ballerinalang.compiler.util.Names;
import org.wso2.ballerinalang.util.RepoUtils;
import picocli.CommandLine;

@CommandLine.Command(name="pull", description={"download the module source and binaries from a remote repository"})
public class PullCommand
implements BLauncherCmd {
    private static PrintStream outStream = System.err;
    @CommandLine.Parameters
    private List<String> argList;
    @CommandLine.Option(names={"--help", "-h"}, hidden=true)
    private boolean helpFlag;
    @CommandLine.Option(names={"--debug"}, hidden=true)
    private String debugPort;

    public void execute() {
        String version;
        String moduleName;
        String resourceName;
        if (this.helpFlag) {
            String commandUsageInfo = BLauncherCmd.getCommandUsageInfo((String)"pull");
            outStream.println(commandUsageInfo);
            return;
        }
        if (this.argList == null || this.argList.size() == 0) {
            throw LauncherUtils.createUsageExceptionWithHelp((String)"no module given");
        }
        if (this.argList.size() > 1) {
            throw LauncherUtils.createUsageExceptionWithHelp((String)"too many arguments");
        }
        if (null != this.debugPort) {
            System.setProperty("debug", this.debugPort);
        }
        if (!this.validModuleName(resourceName = this.argList.get(0))) {
            CommandUtil.printError(outStream, "invalid module name. Provide the module name with the org name ", "ballerina pull {<org-name>/<module-name> | <org-name>/<module-name>:<version>}", false);
            Runtime.getRuntime().exit(1);
            return;
        }
        String[] moduleInfo = resourceName.split("/");
        String orgName = moduleInfo[0];
        String packageName = moduleInfo[1];
        String[] packageInfo = packageName.split(":");
        if (packageInfo.length == 2) {
            moduleName = packageInfo[0];
            version = packageInfo[1];
        } else {
            moduleName = packageName;
            version = Names.EMPTY.getValue();
        }
        URI baseURI = URI.create(RepoUtils.getRemoteRepoURL());
        String ballerinaHome = System.getProperty("ballerina.home");
        RemoteRepo remoteRepo = new RemoteRepo(baseURI, new HashMap(), false, Paths.get(ballerinaHome, new String[0]));
        PackageID moduleID = new PackageID(new Name(orgName), new Name(moduleName), new Name(version));
        Patten patten = remoteRepo.calculate(moduleID);
        if (patten != Patten.NULL) {
            Converter converter = remoteRepo.getConverterInstance();
            List compilerInputs = patten.convertToSources(converter, moduleID).collect(Collectors.toList());
            if (compilerInputs.size() == 0) {
                Runtime.getRuntime().exit(1);
            }
        } else {
            outStream.println("couldn't find module " + patten);
            Runtime.getRuntime().exit(1);
        }
        Runtime.getRuntime().exit(0);
    }

    public String getName() {
        return "pull";
    }

    public void printLongDesc(StringBuilder out) {
        out.append("download modules to the user repository \n");
    }

    public void printUsage(StringBuilder out) {
        out.append("  ballerina pull <module-name> \n");
    }

    public void setParentCmdParser(CommandLine parentCmdParser) {
    }

    private String getPullCommandRegex() {
        return "[^0-9_][_\\w]+/[^0-9_][_\\.\\w]+|[^0-9_][_\\w]+/[^0-9_][_\\.\\w]+:[*\\d]+|[^0-9_][_\\w]+/[^0-9_][_\\.\\w]+:[*\\d]+\\.[*\\d]+|[^0-9_][_\\w]+/[^0-9_][_\\.\\w]+:[*\\d]+\\.[*\\d]+\\.[*\\d]+";
    }

    public boolean validModuleName(String str) {
        return Pattern.matches(this.getPullCommandRegex(), str);
    }
}

