/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.packerina.task;

import java.nio.file.Path;
import java.util.List;
import org.ballerinalang.packerina.buildcontext.BuildContext;
import org.ballerinalang.packerina.buildcontext.BuildContextField;
import org.ballerinalang.packerina.buildcontext.sourcecontext.MultiModuleContext;
import org.ballerinalang.packerina.buildcontext.sourcecontext.SingleFileContext;
import org.ballerinalang.packerina.buildcontext.sourcecontext.SingleModuleContext;
import org.ballerinalang.packerina.buildcontext.sourcecontext.SourceType;
import org.ballerinalang.packerina.model.ExecutableJar;
import org.ballerinalang.packerina.task.Task;
import org.ballerinalang.tool.LauncherUtils;
import org.wso2.ballerinalang.compiler.Compiler;
import org.wso2.ballerinalang.compiler.tree.BLangPackage;
import org.wso2.ballerinalang.compiler.util.CompilerContext;

public class CompileTask
implements Task {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void execute(BuildContext buildContext) {
        CompilerContext context = (CompilerContext)buildContext.get(BuildContextField.COMPILER_CONTEXT);
        Compiler compiler = Compiler.getInstance((CompilerContext)context);
        compiler.setOutStream(buildContext.out());
        if (buildContext.getSourceType() == SourceType.SINGLE_BAL_FILE) {
            SingleFileContext singleFileContext = (SingleFileContext)buildContext.get(BuildContextField.SOURCE_CONTEXT);
            Path balFile = singleFileContext.getBalFile().getFileName();
            if (null == balFile) throw LauncherUtils.createLauncherException((String)"unable to find ballerina source");
            BLangPackage compiledModule = compiler.build(balFile.toString());
            singleFileContext.setModule(compiledModule);
            buildContext.moduleDependencyPathMap.put(compiledModule.packageID, new ExecutableJar());
        } else if (buildContext.getSourceType() == SourceType.SINGLE_MODULE) {
            SingleModuleContext moduleContext = (SingleModuleContext)buildContext.get(BuildContextField.SOURCE_CONTEXT);
            BLangPackage compiledModule = compiler.build(moduleContext.getModuleName());
            moduleContext.setModule(compiledModule);
            buildContext.moduleDependencyPathMap.put(compiledModule.packageID, new ExecutableJar());
        } else {
            MultiModuleContext multiModuleContext = (MultiModuleContext)buildContext.get(BuildContextField.SOURCE_CONTEXT);
            List compiledModules = compiler.compilePackages(true);
            if (compiledModules.size() == 0) {
                throw LauncherUtils.createLauncherException((String)"no modules found to compile.");
            }
            multiModuleContext.setModules(compiledModules);
            for (BLangPackage bLangPackage : compiledModules) {
                buildContext.moduleDependencyPathMap.put(bLangPackage.packageID, new ExecutableJar());
            }
        }
        List<BLangPackage> modules = buildContext.getModules();
        for (BLangPackage module : modules) {
            if (!module.diagCollector.hasErrors()) continue;
            throw LauncherUtils.createLauncherException((String)"compilation contains errors");
        }
        buildContext.put(BuildContextField.COMPILER_CONTEXT, context);
    }
}

