/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.packerina.task;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import org.ballerinalang.model.elements.PackageID;
import org.ballerinalang.packerina.buildcontext.BuildContext;
import org.ballerinalang.packerina.buildcontext.BuildContextField;
import org.ballerinalang.packerina.task.Task;
import org.ballerinalang.packerina.writer.BirFileWriter;
import org.wso2.ballerinalang.compiler.PackageCache;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BPackageSymbol;
import org.wso2.ballerinalang.compiler.tree.BLangPackage;
import org.wso2.ballerinalang.compiler.util.CompilerContext;
import org.wso2.ballerinalang.compiler.util.ProjectDirs;

public class CreateBirTask
implements Task {
    @Override
    public void execute(BuildContext buildContext) {
        CompilerContext context = (CompilerContext)buildContext.get(BuildContextField.COMPILER_CONTEXT);
        PackageCache packageCache = PackageCache.getInstance((CompilerContext)context);
        boolean skipTests = buildContext.skipTests();
        Path sourceRootPath = (Path)buildContext.get(BuildContextField.SOURCE_ROOT);
        String balHomePath = buildContext.get(BuildContextField.HOME_REPO).toString();
        BirFileWriter birFileWriter = BirFileWriter.getInstance(context);
        List<BLangPackage> modules = buildContext.getModules();
        for (BLangPackage module : modules) {
            BLangPackage bLangPackage;
            birFileWriter.write(module, buildContext.getBirPathFromTargetCache(module.packageID));
            if (module.testablePkgs.size() > 0) {
                birFileWriter.write((BLangPackage)module.testablePkgs.get(0), buildContext.getTestBirPathFromTargetCache(module.packageID));
            }
            if ((bLangPackage = packageCache.get(module.packageID)) == null) continue;
            this.writeImportBir(buildContext, bLangPackage.symbol.imports, sourceRootPath, birFileWriter, balHomePath);
            if (skipTests || !bLangPackage.hasTestablePackage()) continue;
            bLangPackage.getTestablePkgs().forEach(testablePackage -> this.writeImportBir(buildContext, testablePackage.symbol.imports, sourceRootPath, birFileWriter, balHomePath));
        }
    }

    private void writeImportBir(BuildContext buildContext, List<BPackageSymbol> importz, Path project, BirFileWriter birWriter, String balHomePath) {
        for (BPackageSymbol bPackageSymbol : importz) {
            Path importBir;
            PackageID id = bPackageSymbol.pkgID;
            String version = "0.0.0";
            if (!id.version.value.equals("")) {
                version = id.version.value;
            }
            if (Paths.get(balHomePath, "bir-cache", id.orgName.value, id.name.value, version).toFile().exists()) continue;
            if (ProjectDirs.isModuleExist((Path)project, (String)id.name.value) || buildContext.getImportPathDependency(id).isPresent()) {
                importBir = buildContext.getBirPathFromTargetCache(id);
                birWriter.writeBIRToPath(bPackageSymbol.birPackageFile, id, importBir);
            } else {
                importBir = buildContext.getBirPathFromHomeCache(id);
                if (Files.notExists(importBir, new LinkOption[0])) {
                    birWriter.writeBIRToPath(bPackageSymbol.birPackageFile, id, importBir);
                }
            }
            this.writeImportBir(buildContext, bPackageSymbol.imports, project, birWriter, balHomePath);
        }
    }
}

