/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.packerina.task;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.ballerinalang.model.elements.PackageID;
import org.ballerinalang.packerina.buildcontext.BuildContext;
import org.ballerinalang.packerina.task.Task;
import org.ballerinalang.test.runtime.entity.Test;
import org.ballerinalang.test.runtime.entity.TestSuite;
import org.ballerinalang.testerina.core.TesterinaRegistry;
import org.wso2.ballerinalang.compiler.tree.BLangPackage;

public class ListTestGroupsTask
implements Task {
    @Override
    public void execute(BuildContext buildContext) {
        List<BLangPackage> moduleBirMap = buildContext.getModules();
        for (BLangPackage bLangPackage : moduleBirMap) {
            PackageID packageID = bLangPackage.packageID;
            TestSuite suite = (TestSuite)TesterinaRegistry.getInstance().getTestSuites().get(packageID.toString());
            this.listGroups(suite, buildContext.out());
        }
    }

    private void listGroups(TestSuite testSuite, PrintStream outStream) {
        List<String> groupList = this.getGroupList(testSuite);
        if (groupList.size() == 0) {
            outStream.println("There are no groups available!");
        } else {
            outStream.println("Following groups are available : ");
            outStream.println(groupList);
        }
    }

    private List<String> getGroupList(TestSuite testSuite) {
        ArrayList groupList = new ArrayList();
        for (Test test : testSuite.getTests()) {
            if (test.getGroups().size() <= 0) continue;
            groupList.addAll(test.getGroups());
        }
        return groupList.stream().distinct().collect(Collectors.toList());
    }
}

