/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.packerina.task;

import java.io.File;
import java.nio.file.Path;
import org.ballerinalang.packerina.buildcontext.BuildContext;
import org.ballerinalang.packerina.buildcontext.BuildContextField;
import org.ballerinalang.packerina.task.Task;
import org.wso2.ballerinalang.compiler.tree.BLangPackage;

public class PrintExecutablePathTask
implements Task {
    @Override
    public void execute(BuildContext buildContext) {
        Path sourceRootPath = (Path)buildContext.get(BuildContextField.SOURCE_ROOT);
        for (BLangPackage module : buildContext.getModules()) {
            if (!module.symbol.entryPointExists) continue;
            Path executablePath = buildContext.getExecutablePathFromTarget(module.packageID);
            Path relativePathToExecutable = sourceRootPath.relativize(executablePath);
            if (relativePathToExecutable.toString().contains("..") || relativePathToExecutable.toString().contains("." + File.separator)) {
                buildContext.out().println("\t" + executablePath.toString());
                continue;
            }
            buildContext.out().println("\t" + relativePathToExecutable.toString());
        }
    }
}

