/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.packerina.task;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.StringJoiner;
import org.ballerinalang.packerina.buildcontext.BuildContext;
import org.ballerinalang.packerina.buildcontext.BuildContextField;
import org.ballerinalang.packerina.buildcontext.sourcecontext.SingleFileContext;
import org.ballerinalang.packerina.buildcontext.sourcecontext.SingleModuleContext;
import org.ballerinalang.packerina.buildcontext.sourcecontext.SourceType;
import org.ballerinalang.packerina.task.Task;
import org.ballerinalang.packerina.utils.DebugUtils;
import org.ballerinalang.tool.LauncherUtils;
import org.ballerinalang.tool.util.BFileUtil;
import org.wso2.ballerinalang.compiler.tree.BLangPackage;
import org.wso2.ballerinalang.util.Lists;

public class RunExecutableTask
implements Task {
    private final String[] args;
    private Path executableJarPath;

    public RunExecutableTask(String[] args) {
        this.args = args;
        this.executableJarPath = null;
    }

    @Override
    public void execute(BuildContext buildContext) {
        Path sourceRootPath = (Path)buildContext.get(BuildContextField.SOURCE_ROOT);
        BLangPackage executableModule = null;
        for (BLangPackage module : buildContext.getModules()) {
            if (!module.symbol.entryPointExists) continue;
            executableModule = module;
            this.executableJarPath = buildContext.getJarPathFromTargetCache(executableModule.packageID);
            break;
        }
        if (executableModule == null) {
            switch (buildContext.getSourceType()) {
                case SINGLE_BAL_FILE: {
                    SingleFileContext singleFileContext = (SingleFileContext)buildContext.get(BuildContextField.SOURCE_CONTEXT);
                    throw LauncherUtils.createLauncherException((String)String.format("no entry points found in '%s'.", singleFileContext.getBalFile()));
                }
                case SINGLE_MODULE: {
                    SingleModuleContext singleModuleContext = (SingleModuleContext)buildContext.get(BuildContextField.SOURCE_CONTEXT);
                    throw LauncherUtils.createLauncherException((String)String.format("no entry points found in '%s'.", singleModuleContext.getModuleName()));
                }
            }
            throw LauncherUtils.createLauncherException((String)"unknown source type found when running executable.");
        }
        if (Files.notExists(this.executableJarPath, new LinkOption[0])) {
            throw LauncherUtils.createLauncherException((String)String.format("cannot run '%s' as it does not exist.", this.executableJarPath.toAbsolutePath().toString()));
        }
        if (!Files.isRegularFile(this.executableJarPath, new LinkOption[0]) || !this.executableJarPath.toString().endsWith(".jar")) {
            throw LauncherUtils.createLauncherException((String)String.format("cannot run '%s' as it is not an executable with .jar extension.", this.executableJarPath.toAbsolutePath().toString()));
        }
        System.setProperty("ballerina.source.root", sourceRootPath.toString());
        this.runGeneratedExecutable(executableModule, buildContext);
    }

    private void runGeneratedExecutable(BLangPackage executableModule, BuildContext buildContext) {
        String initClassName = BFileUtil.getQualifiedClassName((String)executableModule.packageID.orgName.value, (String)executableModule.packageID.name.value, (String)"___init");
        try {
            ArrayList<String> commands = new ArrayList<String>();
            commands.add("java");
            commands.add("-cp");
            commands.add(this.getAllClassPaths(executableModule, buildContext));
            if (DebugUtils.isInDebugMode()) {
                commands.add(DebugUtils.getDebugArgs(buildContext));
            }
            commands.add(initClassName);
            commands.addAll(Lists.of((Object[])this.args));
            ProcessBuilder pb = new ProcessBuilder(commands).inheritIO();
            Process process = pb.start();
            process.waitFor();
        }
        catch (IOException | InterruptedException e) {
            throw LauncherUtils.createLauncherException((String)"Error occurred while running the executable ", (Throwable)e.getCause());
        }
    }

    private String getAllClassPaths(BLangPackage executableModule, BuildContext buildContext) {
        StringJoiner cp = new StringJoiner(File.pathSeparator);
        cp.add(this.executableJarPath.toString());
        buildContext.moduleDependencyPathMap.get((Object)executableModule.packageID).moduleLibs.forEach(path -> cp.add(path.toString()));
        if (buildContext.getSourceType().equals((Object)SourceType.SINGLE_BAL_FILE)) {
            cp.add(buildContext.get(BuildContextField.HOME_REPO).toString() + "/bre/lib/*");
        }
        return cp.toString();
    }
}

