/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.database.sql;

import java.math.BigDecimal;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Struct;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.List;
import javax.sql.rowset.CachedRowSet;
import org.ballerinalang.database.sql.SQLDatasourceUtils;
import org.ballerinalang.model.ColumnDefinition;
import org.ballerinalang.model.types.BArrayType;
import org.ballerinalang.model.types.BField;
import org.ballerinalang.model.types.BRecordType;
import org.ballerinalang.model.types.BStructureType;
import org.ballerinalang.model.types.BType;
import org.ballerinalang.model.types.BUnionType;
import org.ballerinalang.model.types.TypeKind;
import org.ballerinalang.model.values.BBoolean;
import org.ballerinalang.model.values.BFloat;
import org.ballerinalang.model.values.BInteger;
import org.ballerinalang.model.values.BMap;
import org.ballerinalang.model.values.BNewArray;
import org.ballerinalang.model.values.BRefType;
import org.ballerinalang.model.values.BString;
import org.ballerinalang.model.values.BValue;
import org.ballerinalang.model.values.BValueArray;
import org.ballerinalang.stdlib.time.util.TimeUtils;
import org.ballerinalang.util.TableIterator;
import org.ballerinalang.util.TableResourceManager;
import org.ballerinalang.util.codegen.StructureTypeInfo;
import org.ballerinalang.util.exceptions.BallerinaException;

public class SQLDataIterator
extends TableIterator {
    private Calendar utcCalendar;
    private StructureTypeInfo timeStructInfo;
    private StructureTypeInfo zoneStructInfo;
    private static final String UNASSIGNABLE_UNIONTYPE_EXCEPTION = "Corresponding Union type in the record is not an assignable nillable type";
    private static final String MISMATCHING_FIELD_ASSIGNMENT = "Trying to assign to a mismatching type";
    private String sourceDatabase;
    private ErrorHandlerFunction mismatchingFieldAssignmentHandler = this::handleMismatchingFieldAssignment;
    private ErrorHandlerFunction unassignableUnionTypeAssignmentHandler = this::handleUnAssignableUnionTypeAssignment;

    public SQLDataIterator(TableResourceManager rm, ResultSet rs, Calendar utcCalendar, List<ColumnDefinition> columnDefs, BStructureType structType, StructureTypeInfo timeStructInfo, StructureTypeInfo zoneStructInfo, String databaseProductName) {
        super(rm, rs, structType, columnDefs);
        this.utcCalendar = utcCalendar;
        this.timeStructInfo = timeStructInfo;
        this.zoneStructInfo = zoneStructInfo;
        this.sourceDatabase = databaseProductName;
    }

    public void close() {
        try {
            if (this.rs != null && !(this.rs instanceof CachedRowSet) && !this.rs.isClosed()) {
                this.rs.close();
            }
            this.resourceManager.gracefullyReleaseResources();
            this.rs = null;
        }
        catch (SQLException e) {
            throw new BallerinaException(e.getMessage(), (Throwable)e);
        }
    }

    public void reset() {
        try {
            if (this.rs instanceof CachedRowSet) {
                this.rs.beforeFirst();
            } else {
                this.close();
            }
        }
        catch (SQLException e) {
            throw new BallerinaException(e.getMessage(), (Throwable)e);
        }
    }

    public String getBlob(int columnIndex) {
        try {
            Blob bValue = this.rs.getBlob(columnIndex);
            return this.rs.wasNull() ? null : SQLDatasourceUtils.getString(bValue);
        }
        catch (SQLException e) {
            throw new BallerinaException(e.getMessage(), (Throwable)e);
        }
    }

    public BMap<String, BValue> generateNext() {
        if (this.type == null) {
            throw new BallerinaException("the expected record type is not specified in the remote function");
        }
        BMap bStruct = new BMap((BType)this.type);
        int index = 0;
        String columnName = null;
        int sqlType = -1;
        try {
            BField[] structFields = this.type.getFields().values().toArray(new BField[0]);
            if (this.columnDefs.size() != structFields.length) {
                throw new BallerinaException("Number of fields in the constraint type is " + (structFields.length > this.columnDefs.size() ? "greater" : "lower") + " than column count of the result set");
            }
            for (ColumnDefinition columnDef : this.columnDefs) {
                if (!(columnDef instanceof SQLColumnDefinition)) continue;
                SQLColumnDefinition def = (SQLColumnDefinition)columnDef;
                columnName = def.getName();
                sqlType = def.getSqlType();
                BField field = structFields[++index - 1];
                BType fieldType = field.getFieldType();
                String fieldName = field.fieldName;
                switch (sqlType) {
                    case 2003: {
                        Array data = this.rs.getArray(index);
                        this.handleArrayValue((BMap<String, BValue>)bStruct, fieldName, data, fieldType);
                        break;
                    }
                    case -16: 
                    case -15: 
                    case -9: 
                    case -1: 
                    case 1: 
                    case 12: {
                        String sValue = this.rs.getString(index);
                        this.handleStringValue(sValue, fieldName, (BMap<String, BValue>)bStruct, fieldType);
                        break;
                    }
                    case -4: 
                    case -3: 
                    case -2: {
                        byte[] binaryValue = this.rs.getBytes(index);
                        this.handleBinaryValue((BMap<String, BValue>)bStruct, fieldName, binaryValue, fieldType);
                        break;
                    }
                    case 2004: {
                        Blob blobValue = this.rs.getBlob(index);
                        this.handleBinaryValue((BMap<String, BValue>)bStruct, fieldName, blobValue == null ? null : blobValue.getBytes(1L, (int)blobValue.length()), fieldType);
                        break;
                    }
                    case 2005: {
                        String clobValue = SQLDatasourceUtils.getString(this.rs.getClob(index));
                        this.handleStringValue(clobValue, fieldName, (BMap<String, BValue>)bStruct, fieldType);
                        break;
                    }
                    case 2011: {
                        String nClobValue = SQLDatasourceUtils.getString(this.rs.getNClob(index));
                        this.handleStringValue(nClobValue, fieldName, (BMap<String, BValue>)bStruct, fieldType);
                        break;
                    }
                    case 91: {
                        Date date = this.rs.getDate(index);
                        this.handleDateValue((BMap<String, BValue>)bStruct, fieldName, date, fieldType);
                        break;
                    }
                    case 92: 
                    case 2013: {
                        Time time = this.rs.getTime(index, this.utcCalendar);
                        this.handleDateValue((BMap<String, BValue>)bStruct, fieldName, time, fieldType);
                        break;
                    }
                    case 93: 
                    case 2014: {
                        Timestamp timestamp = this.rs.getTimestamp(index, this.utcCalendar);
                        this.handleDateValue((BMap<String, BValue>)bStruct, fieldName, timestamp, fieldType);
                        break;
                    }
                    case -8: {
                        String sValue = new String(this.rs.getRowId(index).getBytes(), "UTF-8");
                        this.handleStringValue(sValue, fieldName, (BMap<String, BValue>)bStruct, fieldType);
                        break;
                    }
                    case -6: 
                    case 5: {
                        long iValue = this.rs.getInt(index);
                        this.handleLongValue(iValue, (BMap<String, BValue>)bStruct, fieldName, fieldType);
                        break;
                    }
                    case -5: 
                    case 4: {
                        if (this.sourceDatabase.equalsIgnoreCase("postgresql")) {
                            boolean isOID = this.rs.getMetaData().getColumnTypeName(index).equalsIgnoreCase("oid");
                            if (isOID) {
                                this.handleOIDValue(index, (BMap<String, BValue>)bStruct, fieldName, fieldType);
                                break;
                            }
                            long lValue = this.rs.getLong(index);
                            this.handleLongValue(lValue, (BMap<String, BValue>)bStruct, fieldName, fieldType);
                            break;
                        }
                        long lValue = this.rs.getLong(index);
                        this.handleLongValue(lValue, (BMap<String, BValue>)bStruct, fieldName, fieldType);
                        break;
                    }
                    case 6: 
                    case 7: {
                        double fValue = this.rs.getFloat(index);
                        this.handleDoubleValue(fValue, (BMap<String, BValue>)bStruct, fieldName, fieldType);
                        break;
                    }
                    case 8: {
                        double dValue = this.rs.getDouble(index);
                        this.handleDoubleValue(dValue, (BMap<String, BValue>)bStruct, fieldName, fieldType);
                        break;
                    }
                    case 2: 
                    case 3: {
                        double decimalValue = 0.0;
                        BigDecimal bigDecimalValue = this.rs.getBigDecimal(index);
                        if (bigDecimalValue != null) {
                            decimalValue = bigDecimalValue.doubleValue();
                        }
                        this.handleDoubleValue(decimalValue, (BMap<String, BValue>)bStruct, fieldName, fieldType);
                        break;
                    }
                    case -7: 
                    case 16: {
                        boolean boolValue = this.rs.getBoolean(index);
                        this.handleBooleanValue((BMap<String, BValue>)bStruct, fieldName, boolValue, fieldType);
                        break;
                    }
                    case 2002: {
                        Struct structData = (Struct)this.rs.getObject(index);
                        this.handleStructValue((BMap<String, BValue>)bStruct, fieldName, structData, fieldType);
                        break;
                    }
                    default: {
                        throw new BallerinaException("unsupported sql type " + sqlType + " found for the column " + columnName + " index:" + index);
                    }
                }
            }
        }
        catch (Throwable e) {
            throw new BallerinaException("error in retrieving next value for column: " + columnName + ": of SQL Type: " + sqlType + ": at index:" + index + ":" + e.getMessage());
        }
        return bStruct;
    }

    private void validateAndSetRefRecordField(BMap<String, BValue> bStruct, String fieldName, int expectedTypeTag, int actualTypeTag, BRefType value, String exceptionMessage) {
        if (expectedTypeTag != actualTypeTag) {
            throw new BallerinaException(exceptionMessage);
        }
        bStruct.put((Object)fieldName, (BValue)value);
    }

    private void handleNilToNonNillableFieldAssignment() {
        throw new BallerinaException("Trying to assign a Nil value to a non-nillable field");
    }

    private void handleMismatchingFieldAssignment() {
        throw new BallerinaException(MISMATCHING_FIELD_ASSIGNMENT);
    }

    private void handleUnAssignableUnionTypeAssignment() {
        throw new BallerinaException(UNASSIGNABLE_UNIONTYPE_EXCEPTION);
    }

    private int retrieveNonNilTypeTag(BType fieldType) {
        List members = ((BUnionType)fieldType).getMemberTypes();
        return this.retrieveNonNilType(members).getTag();
    }

    private BMap<String, BValue> createTimeStruct(long millis) {
        return TimeUtils.createTimeStruct((StructureTypeInfo)this.zoneStructInfo, (StructureTypeInfo)this.timeStructInfo, (long)millis, (String)"UTC");
    }

    private BMap<String, BValue> createUserDefinedType(Struct structValue, BStructureType structType) {
        if (structValue == null) {
            return null;
        }
        BField[] internalStructFields = structType.getFields().values().toArray(new BField[0]);
        BMap struct = new BMap((BType)structType);
        try {
            Object[] dataArray = structValue.getAttributes();
            if (dataArray != null) {
                if (dataArray.length != internalStructFields.length) {
                    throw new BallerinaException("specified struct and returned struct are not compatible");
                }
                int index = 0;
                for (BField internalField : internalStructFields) {
                    int type = internalField.getFieldType().getTag();
                    String fieldName = internalField.fieldName;
                    Object value = dataArray[index];
                    switch (type) {
                        case 1: {
                            if (value instanceof BigDecimal) {
                                struct.put((Object)fieldName, (BValue)new BInteger((long)((BigDecimal)value).intValue()));
                                break;
                            }
                            struct.put((Object)fieldName, (BValue)new BInteger(((Long)value).longValue()));
                            break;
                        }
                        case 3: {
                            if (value instanceof BigDecimal) {
                                struct.put((Object)fieldName, (BValue)new BFloat(((BigDecimal)value).doubleValue()));
                                break;
                            }
                            struct.put((Object)fieldName, (BValue)new BFloat(((Double)value).doubleValue()));
                            break;
                        }
                        case 5: {
                            struct.put((Object)fieldName, (BValue)new BString((String)value));
                            break;
                        }
                        case 6: {
                            struct.put((Object)fieldName, (BValue)new BBoolean((Integer)value == 1));
                            break;
                        }
                        case 12: 
                        case 35: {
                            struct.put((Object)fieldName, this.createUserDefinedType((Struct)value, (BStructureType)internalField.fieldType));
                            break;
                        }
                        default: {
                            throw new BallerinaException("error in retrieving UDT data for unsupported type:" + type);
                        }
                    }
                    ++index;
                }
            }
        }
        catch (SQLException e) {
            throw new BallerinaException("error in retrieving UDT data:" + e.getMessage());
        }
        return struct;
    }

    private void handleArrayValue(BMap<String, BValue> bStruct, String fieldName, Array data, BType fieldType) throws SQLException {
        int fieldTypeTag = fieldType.getTag();
        BNewArray dataArray = this.getDataArray(data);
        if (dataArray != null) {
            BType nonNilType = fieldType;
            if (fieldTypeTag == 21) {
                nonNilType = this.retrieveNonNilType(((BUnionType)fieldType).getMemberTypes());
            }
            boolean containsNull = dataArray.getType().getTag() == 20 && ((BArrayType)dataArray.getType()).getElementType().getTag() == 21;
            this.handleMappingArrayValue(nonNilType, bStruct, dataArray, fieldName, containsNull);
        } else if (fieldTypeTag == 21) {
            bStruct.put((Object)fieldName, null);
        } else {
            this.handleNilToNonNillableFieldAssignment();
        }
    }

    private void handleMappingArrayValue(BType nonNilType, BMap<String, BValue> bStruct, BNewArray dataArray, String fieldName, boolean containsNull) {
        if (nonNilType.getTag() == 20) {
            BArrayType expectedArrayType = (BArrayType)nonNilType;
            if (((BArrayType)nonNilType).getElementType().getTag() == 21) {
                this.handleMappingArrayElementToUnionType(expectedArrayType, dataArray, fieldName, bStruct);
            } else {
                this.handleMappingArrayElementToNonUnionType(containsNull, nonNilType, dataArray, bStruct, fieldName);
            }
        } else {
            this.handleMismatchingFieldAssignment();
        }
    }

    private void handleMappingArrayElementToNonUnionType(boolean containsNull, BType nonNilType, BNewArray newArray, BMap<String, BValue> bStruct, String fieldName) {
        if (containsNull) {
            throw new BallerinaException("Trying to assign an array containing NULL values to an array of a non-nillable element type");
        }
        this.validateAndSetRefRecordField(bStruct, fieldName, ((BArrayType)nonNilType).getElementType().getTag(), ((BArrayType)newArray.getType()).getElementType().getTag(), (BRefType)newArray, MISMATCHING_FIELD_ASSIGNMENT);
    }

    private void handleMappingArrayElementToUnionType(BArrayType expectedArrayType, BNewArray arrayTobeSet, String fieldName, BMap<String, BValue> bStruct) {
        BArrayType arrayType = (BArrayType)arrayTobeSet.getType();
        if (arrayType.getElementType().getTag() == 10) {
            bStruct.put((Object)fieldName, (BValue)arrayTobeSet);
        } else {
            BUnionType expectedArrayElementUnionType = (BUnionType)expectedArrayType.getElementType();
            BType expectedNonNilArrayElementType = this.retrieveNonNilType(expectedArrayElementUnionType.getMemberTypes());
            BType actualNonNilArrayElementType = this.getActualNonNilArrayElementType(arrayType.getElementType());
            this.validateAndSetRefRecordField(bStruct, fieldName, expectedNonNilArrayElementType.getTag(), actualNonNilArrayElementType.getTag(), (BRefType)arrayTobeSet, UNASSIGNABLE_UNIONTYPE_EXCEPTION);
        }
    }

    private BType getActualNonNilArrayElementType(BType actualArrayElementType) {
        if (actualArrayElementType.getTag() == 21) {
            return (BType)((BUnionType)actualArrayElementType).getMemberTypes().get(0);
        }
        return actualArrayElementType;
    }

    private BType retrieveNonNilType(List<BType> members) {
        if (members.size() != 2) {
            throw new BallerinaException(UNASSIGNABLE_UNIONTYPE_EXCEPTION);
        }
        if (members.get(0).getTag() == 10) {
            return members.get(1);
        }
        if (members.get(1).getTag() == 10) {
            return members.get(0);
        }
        throw new BallerinaException(UNASSIGNABLE_UNIONTYPE_EXCEPTION);
    }

    private void handleStructValue(BMap<String, BValue> bStruct, String fieldName, Struct structData, BType fieldType) {
        int fieldTypeTag = fieldType.getTag();
        if (fieldTypeTag == 21) {
            BType structFieldType = this.retrieveNonNilType(((BUnionType)fieldType).getMemberTypes());
            if (structFieldType.getTag() == 12) {
                BMap<String, BValue> userDefinedType = this.createUserDefinedType(structData, (BStructureType)((BRecordType)structFieldType));
                bStruct.put((Object)fieldName, userDefinedType);
            } else {
                this.handleUnAssignableUnionTypeAssignment();
            }
        } else if (fieldTypeTag == 12) {
            this.validateAndSetRefRecordField(bStruct, fieldName, 12, fieldTypeTag, (BRefType)this.createUserDefinedType(structData, (BStructureType)((BRecordType)fieldType)), MISMATCHING_FIELD_ASSIGNMENT);
        } else {
            this.handleMismatchingFieldAssignment();
        }
    }

    private void handleBooleanValue(BMap<String, BValue> bStruct, String fieldName, boolean boolValue, BType fieldType) throws SQLException {
        int fieldTypeTag = fieldType.getTag();
        boolean isOriginalValueNull = this.rs.wasNull();
        if (fieldTypeTag == 21) {
            BBoolean refValue = isOriginalValueNull ? null : new BBoolean(boolValue);
            this.validateAndSetRefRecordField(bStruct, fieldName, 6, this.retrieveNonNilTypeTag(fieldType), (BRefType)refValue, UNASSIGNABLE_UNIONTYPE_EXCEPTION);
        } else if (isOriginalValueNull) {
            this.handleNilToNonNillableFieldAssignment();
        } else {
            this.validateAndSetRefRecordField(bStruct, fieldName, 6, fieldTypeTag, (BRefType)new BBoolean(boolValue), MISMATCHING_FIELD_ASSIGNMENT);
        }
    }

    private void handleDateValue(BMap<String, BValue> bStruct, String fieldName, java.util.Date date, BType fieldType) {
        int fieldTypeTag = fieldType.getTag();
        if (fieldTypeTag == 21) {
            this.handleMappingDateValueToUnionType(fieldType, bStruct, fieldName, date);
        } else {
            this.handleMappingDateValueToNonUnionType(date, fieldTypeTag, bStruct, fieldName);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void handleBinaryValue(BMap<String, BValue> bStruct, String fieldName, byte[] bytes, BType fieldType) {
        int fieldTypeTag = fieldType.getTag();
        if (fieldTypeTag == 21) {
            BType nonNillType = this.retrieveNonNilType(((BUnionType)fieldType).getMemberTypes());
            if (nonNillType.getTag() == 20) {
                int elementTypeTag = ((BArrayType)nonNillType).getElementType().getTag();
                if (elementTypeTag == 2) {
                    BValueArray refValue = bytes == null ? null : new BValueArray(bytes);
                    bStruct.put((Object)fieldName, (BValue)refValue);
                    return;
                } else {
                    this.handleUnAssignableUnionTypeAssignment();
                }
                return;
            } else {
                this.handleUnAssignableUnionTypeAssignment();
            }
            return;
        } else if (bytes != null) {
            if (20 != fieldTypeTag) throw new BallerinaException(MISMATCHING_FIELD_ASSIGNMENT);
            int elementTypeTag = ((BArrayType)fieldType).getElementType().getTag();
            if (elementTypeTag != 2) throw new BallerinaException(MISMATCHING_FIELD_ASSIGNMENT);
            bStruct.put((Object)fieldName, (BValue)new BValueArray(bytes));
            return;
        } else {
            this.handleNilToNonNillableFieldAssignment();
        }
    }

    private void handleStringValue(String stringValue, String fieldName, BMap<String, BValue> bStruct, BType fieldType) {
        int fieldTypeTag = fieldType.getTag();
        if (fieldTypeTag == 21) {
            BString refValue = stringValue == null ? null : new BString(stringValue);
            this.validateAndSetRefRecordField(bStruct, fieldName, 5, this.retrieveNonNilTypeTag(fieldType), (BRefType)refValue, UNASSIGNABLE_UNIONTYPE_EXCEPTION);
        } else if (stringValue != null) {
            this.validateAndSetRefRecordField(bStruct, fieldName, 5, fieldTypeTag, (BRefType)new BString(stringValue), MISMATCHING_FIELD_ASSIGNMENT);
        } else {
            this.handleNilToNonNillableFieldAssignment();
        }
    }

    private void handleOIDValue(int index, BMap<String, BValue> bStruct, String fieldName, BType fieldType) throws SQLException {
        int fieldTypeTag = fieldType.getTag();
        if (fieldTypeTag == 21) {
            BType nonNilType = this.retrieveNonNilType(((BUnionType)fieldType).getMemberTypes());
            this.assignOIDValue(nonNilType.getTag(), nonNilType, fieldName, index, bStruct, this.unassignableUnionTypeAssignmentHandler);
        } else {
            long longValue = this.rs.getLong(index);
            boolean isOriginalValueNull = this.rs.wasNull();
            if (longValue == 0L && isOriginalValueNull) {
                this.handleNilToNonNillableFieldAssignment();
            } else {
                this.assignOIDValue(fieldTypeTag, fieldType, fieldName, index, bStruct, this.mismatchingFieldAssignmentHandler);
            }
        }
    }

    private void assignOIDValue(int fieldTypeTag, BType fieldType, String fieldName, int index, BMap<String, BValue> bStruct, ErrorHandlerFunction errorHandlerFunction) throws SQLException {
        if (fieldTypeTag == 20) {
            int elementTypeTag = ((BArrayType)fieldType).getElementType().getTag();
            if (elementTypeTag == 2) {
                Blob blobValue = this.rs.getBlob(index);
                byte[] bytes = blobValue.getBytes(1L, (int)blobValue.length());
                bStruct.put((Object)fieldName, (BValue)(bytes == null ? null : new BValueArray(bytes)));
            } else {
                errorHandlerFunction.apply();
            }
        } else if (fieldTypeTag == 1) {
            bStruct.put((Object)fieldName, (BValue)new BInteger(this.rs.getLong(index)));
        } else {
            errorHandlerFunction.apply();
        }
    }

    private void handleLongValue(long longValue, BMap<String, BValue> bStruct, String fieldName, BType fieldType) throws SQLException {
        boolean isOriginalValueNull = this.rs.wasNull();
        int fieldTypeTag = fieldType.getTag();
        if (fieldTypeTag == 21) {
            BInteger refValue = isOriginalValueNull ? null : new BInteger(longValue);
            this.validateAndSetRefRecordField(bStruct, fieldName, 1, this.retrieveNonNilTypeTag(fieldType), (BRefType)refValue, UNASSIGNABLE_UNIONTYPE_EXCEPTION);
        } else if (isOriginalValueNull) {
            this.handleNilToNonNillableFieldAssignment();
        } else {
            this.validateAndSetRefRecordField(bStruct, fieldName, 1, fieldTypeTag, (BRefType)new BInteger(longValue), MISMATCHING_FIELD_ASSIGNMENT);
        }
    }

    private void handleDoubleValue(double fValue, BMap<String, BValue> bStruct, String fieldName, BType fieldType) throws SQLException {
        boolean isOriginalValueNull = this.rs.wasNull();
        int fieldTypeTag = fieldType.getTag();
        if (fieldTypeTag == 21) {
            BFloat refValue = isOriginalValueNull ? null : new BFloat(fValue);
            this.validateAndSetRefRecordField(bStruct, fieldName, 3, this.retrieveNonNilTypeTag(fieldType), (BRefType)refValue, UNASSIGNABLE_UNIONTYPE_EXCEPTION);
        } else if (isOriginalValueNull) {
            this.handleNilToNonNillableFieldAssignment();
        } else {
            this.validateAndSetRefRecordField(bStruct, fieldName, 3, fieldTypeTag, (BRefType)new BFloat(fValue), MISMATCHING_FIELD_ASSIGNMENT);
        }
    }

    private void handleMappingDateValueToUnionType(BType fieldType, BMap<String, BValue> bStruct, String fieldName, java.util.Date date) {
        int type = this.retrieveNonNilTypeTag(fieldType);
        switch (type) {
            case 5: {
                String dateValue = SQLDatasourceUtils.getString(date);
                bStruct.put((Object)fieldName, (BValue)(dateValue != null ? new BString(dateValue) : null));
                break;
            }
            case 12: 
            case 35: {
                bStruct.put((Object)fieldName, date != null ? this.createTimeStruct(date.getTime()) : null);
                break;
            }
            case 1: {
                bStruct.put((Object)fieldName, (BValue)(date != null ? new BInteger(date.getTime()) : null));
                break;
            }
            default: {
                this.handleMismatchingFieldAssignment();
            }
        }
    }

    private void handleMappingDateValueToNonUnionType(java.util.Date date, int fieldTypeTag, BMap<String, BValue> bStruct, String fieldName) {
        if (date != null) {
            switch (fieldTypeTag) {
                case 5: {
                    String dateValue = SQLDatasourceUtils.getString(date);
                    bStruct.put((Object)fieldName, (BValue)new BString(dateValue));
                    break;
                }
                case 12: 
                case 35: {
                    bStruct.put((Object)fieldName, this.createTimeStruct(date.getTime()));
                    break;
                }
                case 1: {
                    bStruct.put((Object)fieldName, (BValue)new BInteger(date.getTime()));
                    break;
                }
                default: {
                    this.handleMismatchingFieldAssignment();
                    break;
                }
            }
        } else {
            this.handleNilToNonNillableFieldAssignment();
        }
    }

    public static class SQLColumnDefinition
    extends ColumnDefinition {
        private int sqlType;

        public SQLColumnDefinition(String name, TypeKind mappedType, int sqlType) {
            super(name, mappedType);
            this.sqlType = sqlType;
        }

        public String getName() {
            return this.name;
        }

        public TypeKind getType() {
            return this.mappedType;
        }

        public int getSqlType() {
            return this.sqlType;
        }
    }

    @FunctionalInterface
    private static interface ErrorHandlerFunction {
        public void apply();
    }
}

