/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.database.sql;

import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import java.io.File;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import javax.sql.XADataSource;
import org.ballerinalang.bre.bvm.BVM;
import org.ballerinalang.connector.api.Struct;
import org.ballerinalang.connector.api.Value;
import org.ballerinalang.model.types.BType;
import org.ballerinalang.model.values.BBoolean;
import org.ballerinalang.model.values.BFloat;
import org.ballerinalang.model.values.BInteger;
import org.ballerinalang.model.values.BMap;
import org.ballerinalang.model.values.BRefType;
import org.ballerinalang.model.values.BString;
import org.ballerinalang.model.values.BValue;
import org.ballerinalang.util.exceptions.BallerinaException;

public class SQLDatasource
implements BValue {
    private HikariDataSource hikariDataSource;
    private String peerAddress;
    private String databaseName;
    private String databaseProductName;
    private String connectorId;
    private boolean xaConn;

    public boolean init(SQLDatasourceParams sqlDatasourceParams) {
        this.databaseName = sqlDatasourceParams.dbName;
        this.peerAddress = sqlDatasourceParams.jdbcUrl;
        this.buildDataSource(sqlDatasourceParams);
        this.connectorId = UUID.randomUUID().toString();
        this.xaConn = this.isXADataSource();
        try (Connection con = this.getSQLConnection();){
            this.databaseProductName = con.getMetaData().getDatabaseProductName().toLowerCase(Locale.ENGLISH);
        }
        catch (SQLException e) {
            throw new BallerinaException("error in get connection: ClientConnector: " + e.getMessage(), (Throwable)e);
        }
        return true;
    }

    public String getPeerAddress() {
        return this.peerAddress;
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public String getDatabaseProductName() {
        return this.databaseProductName;
    }

    public Connection getSQLConnection() {
        try {
            return this.hikariDataSource.getConnection();
        }
        catch (SQLException e) {
            throw new BallerinaException("error in get connection: ClientConnector: " + e.getMessage(), (Throwable)e);
        }
    }

    public String getConnectorId() {
        return this.connectorId;
    }

    public boolean isXAConnection() {
        return this.xaConn;
    }

    public XADataSource getXADataSource() {
        XADataSource xaDataSource;
        try {
            xaDataSource = (XADataSource)this.hikariDataSource.unwrap(XADataSource.class);
        }
        catch (SQLException e) {
            throw new BallerinaException("error in get distributed data source");
        }
        return xaDataSource;
    }

    public void closeConnectionPool() {
        this.hikariDataSource.close();
    }

    private void buildDataSource(SQLDatasourceParams sqlDatasourceParams) {
        try {
            HikariConfig config = new HikariConfig();
            config.setUsername(sqlDatasourceParams.username);
            config.setPassword(sqlDatasourceParams.password);
            if (sqlDatasourceParams.jdbcUrl.isEmpty()) {
                sqlDatasourceParams.jdbcUrl = this.constructJDBCURL(sqlDatasourceParams.dbType, sqlDatasourceParams.hostOrPath, sqlDatasourceParams.port, sqlDatasourceParams.dbName, sqlDatasourceParams.username, sqlDatasourceParams.password, sqlDatasourceParams.urlOptions);
            }
            if (sqlDatasourceParams.options != null) {
                long validationTimeout;
                long maxLifetime;
                int minimumIdle;
                long idleTimeout;
                long connectionTimeout;
                int maximumPoolSize;
                boolean isXA = sqlDatasourceParams.options.getBooleanField("isXA");
                BMap<String, BRefType> dataSourceConfigMap = this.populatePropertiesMap(sqlDatasourceParams.dbOptionsMap);
                String dataSourceClassName = sqlDatasourceParams.options.getStringField("dataSourceClassName");
                if (isXA && dataSourceClassName.isEmpty()) {
                    dataSourceClassName = this.getXADatasourceClassName(sqlDatasourceParams.dbType, sqlDatasourceParams.jdbcUrl, sqlDatasourceParams.username, sqlDatasourceParams.password);
                }
                if (!dataSourceClassName.isEmpty()) {
                    config.setDataSourceClassName(dataSourceClassName);
                    dataSourceConfigMap = this.setDataSourcePropertiesMap(dataSourceConfigMap, sqlDatasourceParams.jdbcUrl, sqlDatasourceParams.username, sqlDatasourceParams.password);
                } else {
                    config.setJdbcUrl(sqlDatasourceParams.jdbcUrl);
                }
                String connectionInitSQL = sqlDatasourceParams.options.getStringField("connectionInitSql");
                if (!connectionInitSQL.isEmpty()) {
                    config.setConnectionInitSql(connectionInitSQL);
                }
                if ((maximumPoolSize = (int)sqlDatasourceParams.options.getIntField("maximumPoolSize")) != -1) {
                    config.setMaximumPoolSize(maximumPoolSize);
                }
                if ((connectionTimeout = sqlDatasourceParams.options.getIntField("connectionTimeout")) != -1L) {
                    config.setConnectionTimeout(connectionTimeout);
                }
                if ((idleTimeout = sqlDatasourceParams.options.getIntField("idleTimeout")) != -1L) {
                    config.setIdleTimeout(idleTimeout);
                }
                if ((minimumIdle = (int)sqlDatasourceParams.options.getIntField("minimumIdle")) != -1) {
                    config.setMinimumIdle(minimumIdle);
                }
                if ((maxLifetime = sqlDatasourceParams.options.getIntField("maxLifetime")) != -1L) {
                    config.setMaxLifetime(maxLifetime);
                }
                if ((validationTimeout = sqlDatasourceParams.options.getIntField("validationTimeout")) != -1L) {
                    config.setValidationTimeout(validationTimeout);
                }
                boolean autoCommit = sqlDatasourceParams.options.getBooleanField("autoCommit");
                config.setAutoCommit(autoCommit);
                if (dataSourceConfigMap != null) {
                    this.setDataSourceProperties(dataSourceConfigMap, config);
                }
            } else {
                config.setJdbcUrl(sqlDatasourceParams.jdbcUrl);
            }
            this.hikariDataSource = new HikariDataSource(config);
        }
        catch (Throwable t) {
            String message = "error in sql connector configuration:" + t.getMessage();
            if (t.getCause() != null) {
                message = message + ":" + t.getCause().getMessage();
            }
            throw new BallerinaException(message);
        }
    }

    private BMap<String, BRefType> populatePropertiesMap(Map<String, Value> dataSourceConfigMap) {
        if (dataSourceConfigMap == null) {
            return null;
        }
        BMap mapProperties = null;
        if (dataSourceConfigMap.size() > 0) {
            mapProperties = new BMap();
            for (Map.Entry<String, Value> entry : dataSourceConfigMap.entrySet()) {
                Value propValue = entry.getValue();
                BInteger dataValue = null;
                switch (propValue.getType()) {
                    case INT: {
                        dataValue = new BInteger(propValue.getIntValue());
                        break;
                    }
                    case FLOAT: {
                        dataValue = new BFloat(propValue.getFloatValue());
                        break;
                    }
                    case BOOLEAN: {
                        dataValue = new BBoolean(propValue.getBooleanValue());
                        break;
                    }
                    case NULL: {
                        break;
                    }
                    default: {
                        dataValue = new BString(propValue.getStringValue());
                    }
                }
                mapProperties.put((Object)entry.getKey(), (BValue)dataValue);
            }
        }
        return mapProperties;
    }

    private BMap<String, BRefType<?>> setDataSourcePropertiesMap(BMap<String, BRefType<?>> dataSourceConfigMap, String jdbcurl, String username, String password) {
        if (dataSourceConfigMap != null) {
            if (!dataSourceConfigMap.hasKey((Object)"url")) {
                dataSourceConfigMap.put((Object)"url", (BValue)new BString(jdbcurl));
            }
        } else {
            dataSourceConfigMap = new BMap();
            dataSourceConfigMap.put((Object)"url", (BValue)new BString(jdbcurl));
        }
        dataSourceConfigMap.put((Object)"user", (BValue)new BString(username));
        dataSourceConfigMap.put((Object)"password", (BValue)new BString(password));
        return dataSourceConfigMap;
    }

    private String constructJDBCURL(String dbType, String hostOrPath, int port, String dbName, String username, String password, String dbOptions) {
        StringBuilder jdbcUrl = new StringBuilder();
        dbType = dbType.toUpperCase(Locale.ENGLISH);
        hostOrPath = hostOrPath.replaceAll("/$", "");
        switch (dbType) {
            case "MYSQL": {
                if (port <= 0) {
                    port = 3306;
                }
                jdbcUrl.append("jdbc:mysql://").append(hostOrPath).append(":").append(port).append("/").append(dbName);
                break;
            }
            case "SQLSERVER": {
                if (port <= 0) {
                    port = 1433;
                }
                jdbcUrl.append("jdbc:sqlserver://").append(hostOrPath).append(":").append(port).append(";databaseName=").append(dbName);
                break;
            }
            case "ORACLE": {
                if (port <= 0) {
                    port = 1521;
                }
                jdbcUrl.append("jdbc:oracle:thin:").append(username).append("/").append(password).append("@").append(hostOrPath).append(":").append(port).append("/").append(dbName);
                break;
            }
            case "SYBASE": {
                if (port <= 0) {
                    port = 5000;
                }
                jdbcUrl.append("jdbc:sybase:Tds:").append(hostOrPath).append(":").append(port).append("/").append(dbName);
                break;
            }
            case "POSTGRESQL": {
                if (port <= 0) {
                    port = 5432;
                }
                jdbcUrl.append("jdbc:postgresql://").append(hostOrPath).append(":").append(port).append("/").append(dbName);
                break;
            }
            case "DB2": {
                if (port <= 0) {
                    port = 50000;
                }
                jdbcUrl.append("jdbc:db2:").append(hostOrPath).append(":").append(port).append("/").append(dbName);
                break;
            }
            case "HSQLDB_SERVER": {
                if (port <= 0) {
                    port = 9001;
                }
                jdbcUrl.append("jdbc:hsqldb:hsql://").append(hostOrPath).append(":").append(port).append("/").append(dbName);
                break;
            }
            case "HSQLDB_FILE": {
                jdbcUrl.append("jdbc:hsqldb:file:").append(hostOrPath).append(File.separator).append(dbName);
                break;
            }
            case "H2_SERVER": {
                if (port <= 0) {
                    port = 9092;
                }
                jdbcUrl.append("jdbc:h2:tcp:").append(hostOrPath).append(":").append(port).append("/").append(dbName);
                break;
            }
            case "H2_FILE": {
                jdbcUrl.append("jdbc:h2:file:").append(hostOrPath).append(File.separator).append(dbName);
                break;
            }
            case "H2_MEMORY": {
                jdbcUrl.append("jdbc:h2:mem:").append(dbName);
                break;
            }
            case "DERBY_SERVER": {
                if (port <= 0) {
                    port = 1527;
                }
                jdbcUrl.append("jdbc:derby:").append(hostOrPath).append(":").append(port).append("/").append(dbName);
                break;
            }
            case "DERBY_FILE": {
                jdbcUrl.append("jdbc:derby:").append(hostOrPath).append(File.separator).append(dbName);
                break;
            }
            default: {
                throw new BallerinaException("cannot generate url for unknown database type : " + dbType);
            }
        }
        this.peerAddress = hostOrPath + ":" + port;
        return dbOptions.isEmpty() ? jdbcUrl.toString() : jdbcUrl.append(dbOptions).toString();
    }

    /*
     * Unable to fully structure code
     */
    private String getXADatasourceClassName(String dbType, String url, String userName, String password) {
        xaDataSource = null;
        var6_6 = dbType;
        var7_7 = -1;
        switch (var6_6.hashCode()) {
            case 73844866: {
                if (!var6_6.equals("MYSQL")) break;
                var7_7 = 0;
                break;
            }
            case 912124529: {
                if (!var6_6.equals("SQLSERVER")) break;
                var7_7 = 1;
                break;
            }
            case -1955532418: {
                if (!var6_6.equals("ORACLE")) break;
                var7_7 = 2;
                break;
            }
            case -1834523081: {
                if (!var6_6.equals("SYBASE")) break;
                var7_7 = 3;
                break;
            }
            case -1620389036: {
                if (!var6_6.equals("POSTGRESQL")) break;
                var7_7 = 4;
                break;
            }
            case 67444: {
                if (!var6_6.equals("DB2")) break;
                var7_7 = 5;
                break;
            }
            case 2140439396: {
                if (!var6_6.equals("HSQLDB")) break;
                var7_7 = 6;
                break;
            }
            case -1831025538: {
                if (!var6_6.equals("HSQLDB_SERVER")) break;
                var7_7 = 7;
                break;
            }
            case 1472569719: {
                if (!var6_6.equals("HSQLDB_FILE")) break;
                var7_7 = 8;
                break;
            }
            case 2282: {
                if (!var6_6.equals("H2")) break;
                var7_7 = 9;
                break;
            }
            case 809442360: {
                if (!var6_6.equals("H2_SERVER")) break;
                var7_7 = 10;
                break;
            }
            case 997105585: {
                if (!var6_6.equals("H2_FILE")) break;
                var7_7 = 11;
                break;
            }
            case 637512182: {
                if (!var6_6.equals("H2_MEMORY")) break;
                var7_7 = 12;
                break;
            }
            case -162746534: {
                if (!var6_6.equals("DERBY_SERVER")) break;
                var7_7 = 13;
                break;
            }
            case 1621791571: {
                if (!var6_6.equals("DERBY_FILE")) break;
                var7_7 = 14;
            }
        }
        switch (var7_7) {
            case 0: {
                try {
                    conn = DriverManager.getConnection(url, userName, password);
                    var10_10 = null;
                    driverMajorVersion = conn.getMetaData().getDriverMajorVersion();
                    if (driverMajorVersion == 5) {
                        xaDataSource = "com.mysql.jdbc.jdbc2.optional.MysqlXADataSource";
                    } else if (driverMajorVersion > 5) {
                        xaDataSource = "com.mysql.cj.jdbc.MysqlXADataSource";
                    }
                    if (conn == null) break;
                    if (var10_10 == null) ** GOTO lbl84
                    try {
                        conn.close();
                    }
                    catch (Throwable var11_12) {
                        var10_10.addSuppressed(var11_12);
                    }
                    break;
lbl84:
                    // 1 sources

                    conn.close();
                    ** break;
                    catch (Throwable var11_13) {
                        try {
                            var10_10 = var11_13;
                            throw var11_13;
                        }
                        catch (Throwable var12_14) {
                            if (conn != null) {
                                if (var10_10 != null) {
                                    try {
                                        conn.close();
                                    }
                                    catch (Throwable var13_15) {
                                        var10_10.addSuppressed(var13_15);
                                    }
                                } else {
                                    conn.close();
                                }
                            }
                            throw var12_14;
lbl101:
                            // 1 sources

                            break;
                        }
                    }
                }
                catch (SQLException e) {
                    throw new BallerinaException("error in get connection: ClientConnector: " + e.getMessage(), (Throwable)e);
                }
            }
            case 1: {
                xaDataSource = "com.microsoft.sqlserver.jdbc.SQLServerXADataSource";
                break;
            }
            case 2: {
                xaDataSource = "oracle.jdbc.xa.client.OracleXADataSource";
                break;
            }
            case 3: {
                xaDataSource = "com.sybase.jdbc3.jdbc.SybXADataSource";
                break;
            }
            case 4: {
                xaDataSource = "org.postgresql.xa.PGXADataSource";
                break;
            }
            case 5: {
                xaDataSource = "com.ibm.db2.jdbc.DB2XADataSource";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                xaDataSource = "org.hsqldb.jdbc.pool.JDBCXADataSource";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                xaDataSource = "org.h2.jdbcx.JdbcDataSource";
                break;
            }
            case 13: {
                xaDataSource = "org.apache.derby.jdbc.ClientXADataSource";
                break;
            }
            case 14: {
                xaDataSource = "org.apache.derby.jdbc.EmbeddedXADataSource";
                break;
            }
            default: {
                throw new BallerinaException("unknown database type used for xa connection : " + dbType);
            }
        }
        return xaDataSource;
    }

    private void setDataSourceProperties(BMap<String, BRefType<?>> options, HikariConfig config) {
        for (String key : (String[])options.keys()) {
            BValue value = options.get((Object)key);
            if (value instanceof BString) {
                config.addDataSourceProperty(key, (Object)value.stringValue());
                continue;
            }
            if (value instanceof BInteger) {
                config.addDataSourceProperty(key, (Object)((BInteger)value).intValue());
                continue;
            }
            if (value instanceof BBoolean) {
                config.addDataSourceProperty(key, (Object)((BBoolean)value).booleanValue());
                continue;
            }
            if (!(value instanceof BFloat)) continue;
            config.addDataSourceProperty(key, (Object)((BFloat)value).floatValue());
        }
    }

    public String stringValue() {
        return null;
    }

    public BType getType() {
        return null;
    }

    public void stamp(BType type, List<BVM.TypeValuePair> unresolvedValues) {
    }

    public BValue copy(Map<BValue, BValue> refs) {
        return null;
    }

    private boolean isXADataSource() {
        try {
            return this.hikariDataSource.isWrapperFor(XADataSource.class);
        }
        catch (SQLException e) {
            throw new BallerinaException("error in check distributed data source: " + e.getCause().getMessage());
        }
    }

    public static class SQLDatasourceParamsBuilder {
        private Struct options;
        private String jdbcUrl;
        private String dbType;
        private String hostOrPath;
        private int port;
        private String username;
        private String password;
        private String dbName;
        private String urlOptions;
        private Map<String, Value> dbOptionsMap;

        public SQLDatasourceParamsBuilder(String dbType) {
            this.dbType = dbType;
        }

        public SQLDatasourceParams build() {
            return new SQLDatasourceParams(this);
        }

        public SQLDatasourceParamsBuilder withJdbcUrl(String jdbcUrl) {
            this.jdbcUrl = jdbcUrl;
            return this;
        }

        public SQLDatasourceParamsBuilder withDbType(String dbType) {
            this.dbType = dbType;
            return this;
        }

        public SQLDatasourceParamsBuilder withHostOrPath(String hostOrPath) {
            this.hostOrPath = hostOrPath;
            return this;
        }

        public SQLDatasourceParamsBuilder withPort(int port) {
            this.port = port;
            return this;
        }

        public SQLDatasourceParamsBuilder withUsername(String username) {
            this.username = username;
            return this;
        }

        public SQLDatasourceParamsBuilder withPassword(String password) {
            this.password = password;
            return this;
        }

        public SQLDatasourceParamsBuilder withUrlOptions(String urlOptions) {
            this.urlOptions = urlOptions;
            return this;
        }

        public SQLDatasourceParamsBuilder withDbOptionsMap(Map<String, Value> dbOptionsMap) {
            this.dbOptionsMap = dbOptionsMap;
            return this;
        }

        public SQLDatasourceParamsBuilder withOptions(Struct options) {
            this.options = options;
            return this;
        }

        public SQLDatasourceParamsBuilder withDbName(String dbName) {
            this.dbName = dbName;
            return this;
        }
    }

    protected static class SQLDatasourceParams {
        private Struct options;
        private String jdbcUrl;
        private String dbType;
        private String hostOrPath;
        private int port;
        private String username;
        private String password;
        private String dbName;
        private String urlOptions;
        private Map dbOptionsMap;

        private SQLDatasourceParams(SQLDatasourceParamsBuilder builder) {
            this.options = builder.options;
            this.jdbcUrl = builder.jdbcUrl;
            this.dbType = builder.dbType;
            this.hostOrPath = builder.hostOrPath;
            this.port = builder.port;
            this.username = builder.username;
            this.password = builder.password;
            this.dbName = builder.dbName;
            this.urlOptions = builder.urlOptions;
            this.dbOptionsMap = builder.dbOptionsMap;
        }
    }
}

