/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.database.sql;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigDecimal;
import java.nio.charset.Charset;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Calendar;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.StringJoiner;
import java.util.TimeZone;
import javax.sql.XAConnection;
import javax.transaction.xa.XAResource;
import org.ballerinalang.bre.Context;
import org.ballerinalang.bre.bvm.BLangVMErrors;
import org.ballerinalang.bre.bvm.Strand;
import org.ballerinalang.connector.api.BLangConnectorSPIUtil;
import org.ballerinalang.connector.api.Struct;
import org.ballerinalang.connector.api.Value;
import org.ballerinalang.database.sql.SQLDataIterator;
import org.ballerinalang.database.sql.SQLDatasource;
import org.ballerinalang.database.sql.SQLTransactionContext;
import org.ballerinalang.model.ColumnDefinition;
import org.ballerinalang.model.types.BArrayType;
import org.ballerinalang.model.types.BErrorType;
import org.ballerinalang.model.types.BField;
import org.ballerinalang.model.types.BStructureType;
import org.ballerinalang.model.types.BType;
import org.ballerinalang.model.types.BTypes;
import org.ballerinalang.model.types.TypeKind;
import org.ballerinalang.model.values.BBoolean;
import org.ballerinalang.model.values.BError;
import org.ballerinalang.model.values.BFloat;
import org.ballerinalang.model.values.BInteger;
import org.ballerinalang.model.values.BMap;
import org.ballerinalang.model.values.BString;
import org.ballerinalang.model.values.BValue;
import org.ballerinalang.model.values.BValueArray;
import org.ballerinalang.util.codegen.ProgramFile;
import org.ballerinalang.util.exceptions.BallerinaException;
import org.ballerinalang.util.transactions.BallerinaTransactionContext;
import org.ballerinalang.util.transactions.TransactionLocalContext;
import org.ballerinalang.util.transactions.TransactionResourceManager;
import org.ballerinalang.util.transactions.TransactionUtils;

public class SQLDatasourceUtils {
    private static final String ORACLE_DATABASE_NAME = "oracle";
    public static final String POSTGRES_DATABASE_NAME = "postgresql";
    private static final String POSTGRES_DOUBLE = "float8";
    public static final String POSTGRES_OID_COLUMN_TYPE_NAME = "oid";
    private static final int ORACLE_CURSOR_TYPE = -10;
    private static final String TIME_FIELD = "time";

    public static void setIntValue(PreparedStatement stmt, BValue value, int index, int direction, int sqlType) {
        block9: {
            Integer val = SQLDatasourceUtils.obtainIntegerValue(value);
            try {
                if (0 == direction) {
                    if (val == null) {
                        stmt.setNull(index + 1, sqlType);
                    } else {
                        stmt.setInt(index + 1, val);
                    }
                    break block9;
                }
                if (2 == direction) {
                    if (val == null) {
                        stmt.setNull(index + 1, sqlType);
                    } else {
                        stmt.setInt(index + 1, val);
                    }
                    ((CallableStatement)stmt).registerOutParameter(index + 1, sqlType);
                    break block9;
                }
                if (1 == direction) {
                    ((CallableStatement)stmt).registerOutParameter(index + 1, sqlType);
                    break block9;
                }
                throw new BallerinaException("invalid direction for the parameter with index: " + index);
            }
            catch (SQLException e) {
                throw new BallerinaException("error in set integer to statement: " + e.getMessage(), (Throwable)e);
            }
        }
    }

    public static void setSmallIntValue(PreparedStatement stmt, BValue value, int index, int direction, int sqlType) {
        block9: {
            Integer val = SQLDatasourceUtils.obtainIntegerValue(value);
            try {
                if (0 == direction) {
                    if (val == null) {
                        stmt.setNull(index + 1, sqlType);
                    } else {
                        stmt.setShort(index + 1, val.shortValue());
                    }
                    break block9;
                }
                if (2 == direction) {
                    if (val == null) {
                        stmt.setNull(index + 1, sqlType);
                    } else {
                        stmt.setShort(index + 1, val.shortValue());
                    }
                    ((CallableStatement)stmt).registerOutParameter(index + 1, sqlType);
                    break block9;
                }
                if (1 == direction) {
                    ((CallableStatement)stmt).registerOutParameter(index + 1, sqlType);
                    break block9;
                }
                throw new BallerinaException("invalid direction for the parameter with index: " + index);
            }
            catch (SQLException e) {
                throw new BallerinaException("error in set integer to statement: " + e.getMessage(), (Throwable)e);
            }
        }
    }

    public static void setStringValue(PreparedStatement stmt, BValue value, int index, int direction, int sqlType) {
        block9: {
            try {
                if (0 == direction) {
                    if (value == null) {
                        stmt.setNull(index + 1, sqlType);
                    } else {
                        stmt.setString(index + 1, value.stringValue());
                    }
                    break block9;
                }
                if (2 == direction) {
                    if (value == null) {
                        stmt.setNull(index + 1, sqlType);
                    } else {
                        stmt.setString(index + 1, value.stringValue());
                    }
                    ((CallableStatement)stmt).registerOutParameter(index + 1, sqlType);
                    break block9;
                }
                if (1 == direction) {
                    ((CallableStatement)stmt).registerOutParameter(index + 1, sqlType);
                    break block9;
                }
                throw new BallerinaException("invalid direction for the parameter with index: " + index);
            }
            catch (SQLException e) {
                throw new BallerinaException("error in set string to statement: " + e.getMessage(), (Throwable)e);
            }
        }
    }

    public static void setNStringValue(PreparedStatement stmt, BValue value, int index, int direction, int sqlType) {
        block9: {
            try {
                if (0 == direction) {
                    if (value == null) {
                        stmt.setNull(index + 1, sqlType);
                    } else {
                        stmt.setNString(index + 1, value.stringValue());
                    }
                    break block9;
                }
                if (2 == direction) {
                    if (value == null) {
                        stmt.setNull(index + 1, sqlType);
                    } else {
                        stmt.setNString(index + 1, value.stringValue());
                    }
                    ((CallableStatement)stmt).registerOutParameter(index + 1, sqlType);
                    break block9;
                }
                if (1 == direction) {
                    ((CallableStatement)stmt).registerOutParameter(index + 1, sqlType);
                    break block9;
                }
                throw new BallerinaException("invalid direction for the parameter with index: " + index);
            }
            catch (SQLException e) {
                throw new BallerinaException("error in set string to statement: " + e.getMessage(), (Throwable)e);
            }
        }
    }

    public static void setDoubleValue(PreparedStatement stmt, BValue value, int index, int direction, int sqlType) {
        block12: {
            String strValue;
            Double val = null;
            if (value != null && !(strValue = value.stringValue()).isEmpty()) {
                try {
                    val = Double.parseDouble(strValue);
                }
                catch (NumberFormatException e) {
                    throw new BallerinaException("invalid value for double: " + strValue);
                }
            }
            try {
                if (0 == direction) {
                    if (val == null) {
                        stmt.setNull(index + 1, sqlType);
                    } else {
                        stmt.setDouble(index + 1, val);
                    }
                    break block12;
                }
                if (2 == direction) {
                    if (val == null) {
                        stmt.setNull(index + 1, sqlType);
                    } else {
                        stmt.setDouble(index + 1, val);
                    }
                    ((CallableStatement)stmt).registerOutParameter(index + 1, sqlType);
                    break block12;
                }
                if (1 == direction) {
                    ((CallableStatement)stmt).registerOutParameter(index + 1, sqlType);
                    break block12;
                }
                throw new BallerinaException("invalid direction for the parameter with index: " + index);
            }
            catch (SQLException e) {
                throw new BallerinaException("error in set double to statement: " + e.getMessage(), (Throwable)e);
            }
        }
    }

    public static void setNumericValue(PreparedStatement stmt, BValue value, int index, int direction, int sqlType) {
        block12: {
            String strValue;
            BigDecimal val = null;
            if (value != null && !(strValue = value.stringValue()).isEmpty()) {
                try {
                    val = new BigDecimal(strValue);
                }
                catch (NumberFormatException e) {
                    throw new BallerinaException("invalid value for numeric: " + strValue);
                }
            }
            try {
                if (0 == direction) {
                    if (val == null) {
                        stmt.setNull(index + 1, sqlType);
                    } else {
                        stmt.setBigDecimal(index + 1, val);
                    }
                    break block12;
                }
                if (2 == direction) {
                    if (val == null) {
                        stmt.setNull(index + 1, sqlType);
                    } else {
                        stmt.setBigDecimal(index + 1, val);
                    }
                    ((CallableStatement)stmt).registerOutParameter(index + 1, sqlType);
                    break block12;
                }
                if (1 == direction) {
                    ((CallableStatement)stmt).registerOutParameter(index + 1, sqlType);
                    break block12;
                }
                throw new BallerinaException("invalid direction for the parameter with index: " + index);
            }
            catch (SQLException e) {
                throw new BallerinaException("error in set numeric value to statement: " + e.getMessage(), (Throwable)e);
            }
        }
    }

    public static void setBooleanValue(PreparedStatement stmt, BValue value, int index, int direction, int sqlType) {
        block10: {
            String strValue;
            Boolean val = null;
            if (value != null && !(strValue = value.stringValue()).isEmpty()) {
                val = Boolean.valueOf(strValue);
            }
            try {
                if (0 == direction) {
                    if (val == null) {
                        stmt.setNull(index + 1, sqlType);
                    } else {
                        stmt.setBoolean(index + 1, val);
                    }
                    break block10;
                }
                if (2 == direction) {
                    if (val == null) {
                        stmt.setNull(index + 1, sqlType);
                    } else {
                        stmt.setBoolean(index + 1, val);
                    }
                    ((CallableStatement)stmt).registerOutParameter(index + 1, sqlType);
                    break block10;
                }
                if (1 == direction) {
                    ((CallableStatement)stmt).registerOutParameter(index + 1, sqlType);
                    break block10;
                }
                throw new BallerinaException("invalid direction for the parameter with index: " + index);
            }
            catch (SQLException e) {
                throw new BallerinaException("error in set boolean value to statement: " + e.getMessage(), (Throwable)e);
            }
        }
    }

    public static void setTinyIntValue(PreparedStatement stmt, BValue value, int index, int direction, int sqlType) {
        block12: {
            String strValue;
            Byte val = null;
            if (value != null && !(strValue = value.stringValue()).isEmpty()) {
                try {
                    val = Byte.valueOf(strValue);
                }
                catch (NumberFormatException e) {
                    throw new BallerinaException("invalid value for byte: " + strValue);
                }
            }
            try {
                if (0 == direction) {
                    if (val == null) {
                        stmt.setNull(index + 1, sqlType);
                    } else {
                        stmt.setByte(index + 1, val);
                    }
                    break block12;
                }
                if (2 == direction) {
                    if (val == null) {
                        stmt.setNull(index + 1, sqlType);
                    } else {
                        stmt.setByte(index + 1, val);
                    }
                    ((CallableStatement)stmt).registerOutParameter(index + 1, sqlType);
                    break block12;
                }
                if (1 == direction) {
                    ((CallableStatement)stmt).registerOutParameter(index + 1, sqlType);
                    break block12;
                }
                throw new BallerinaException("invalid direction for the parameter with index: " + index);
            }
            catch (SQLException e) {
                throw new BallerinaException("error in set tinyint value to statement: " + e.getMessage(), (Throwable)e);
            }
        }
    }

    public static void setBigIntValue(PreparedStatement stmt, BValue value, int index, int direction, int sqlType) {
        block12: {
            String strValue;
            Long val = null;
            if (value != null && !(strValue = value.stringValue()).isEmpty()) {
                try {
                    val = Long.parseLong(strValue);
                }
                catch (NumberFormatException e) {
                    throw new BallerinaException("invalid value for bigint: " + strValue);
                }
            }
            try {
                if (0 == direction) {
                    if (val == null) {
                        stmt.setNull(index + 1, sqlType);
                    } else {
                        stmt.setLong(index + 1, val);
                    }
                    break block12;
                }
                if (2 == direction) {
                    if (val == null) {
                        stmt.setNull(index + 1, sqlType);
                    } else {
                        stmt.setLong(index + 1, val);
                    }
                    ((CallableStatement)stmt).registerOutParameter(index + 1, sqlType);
                    break block12;
                }
                if (1 == direction) {
                    ((CallableStatement)stmt).registerOutParameter(index + 1, sqlType);
                    break block12;
                }
                throw new BallerinaException("invalid direction for the parameter with index: " + index);
            }
            catch (SQLException e) {
                throw new BallerinaException("error in set bigint value to statement: " + e.getMessage(), (Throwable)e);
            }
        }
    }

    public static void setRealValue(PreparedStatement stmt, BValue value, int index, int direction, int sqlType) {
        block12: {
            String strValue;
            Float val = null;
            if (value != null && !(strValue = value.stringValue()).isEmpty()) {
                try {
                    val = Float.valueOf(Float.parseFloat(strValue));
                }
                catch (NumberFormatException e) {
                    throw new BallerinaException("invalid value for float: " + strValue);
                }
            }
            try {
                if (0 == direction) {
                    if (val == null) {
                        stmt.setNull(index + 1, sqlType);
                    } else {
                        stmt.setFloat(index + 1, val.floatValue());
                    }
                    break block12;
                }
                if (2 == direction) {
                    if (val == null) {
                        stmt.setNull(index + 1, sqlType);
                    } else {
                        stmt.setFloat(index + 1, val.floatValue());
                    }
                    ((CallableStatement)stmt).registerOutParameter(index + 1, sqlType);
                    break block12;
                }
                if (1 == direction) {
                    ((CallableStatement)stmt).registerOutParameter(index + 1, sqlType);
                    break block12;
                }
                throw new BallerinaException("invalid direction for the parameter, index: " + index);
            }
            catch (SQLException e) {
                throw new BallerinaException("error in set float value to statement." + e.getMessage(), (Throwable)e);
            }
        }
    }

    public static void setDateValue(PreparedStatement stmt, BValue value, int index, int direction, int sqlType) {
        block16: {
            Date val = null;
            if (value != null) {
                if (value instanceof BMap && value.getType().getName().equals("Time") && value.getType().getPackagePath().equals("ballerina/time")) {
                    BValue timeVal = ((BMap)value).get((Object)TIME_FIELD);
                    long time = ((BInteger)timeVal).intValue();
                    val = new Date(time);
                } else if (value instanceof BInteger) {
                    val = new Date(((BInteger)value).intValue());
                } else if (value instanceof BString) {
                    val = SQLDatasourceUtils.convertToDate(value.stringValue());
                } else {
                    throw new BallerinaException("invalid input type for date parameter with index: " + index);
                }
            }
            try {
                if (0 == direction) {
                    if (val == null) {
                        stmt.setNull(index + 1, sqlType);
                    } else {
                        stmt.setDate(index + 1, val);
                    }
                    break block16;
                }
                if (2 == direction) {
                    if (val == null) {
                        stmt.setNull(index + 1, sqlType);
                    } else {
                        stmt.setDate(index + 1, val);
                    }
                    ((CallableStatement)stmt).registerOutParameter(index + 1, sqlType);
                    break block16;
                }
                if (1 == direction) {
                    ((CallableStatement)stmt).registerOutParameter(index + 1, sqlType);
                    break block16;
                }
                throw new BallerinaException("invalid direction for the parameter with index: " + index);
            }
            catch (SQLException e) {
                throw new BallerinaException("error in set date value to statement: " + e.getMessage(), (Throwable)e);
            }
        }
    }

    public static void setTimeStampValue(PreparedStatement stmt, BValue value, int index, int direction, int sqlType, Calendar utcCalendar) {
        block16: {
            Timestamp val = null;
            if (value != null) {
                if (value instanceof BMap && value.getType().getName().equals("Time") && value.getType().getPackagePath().equals("ballerina/time")) {
                    BValue timeVal = ((BMap)value).get((Object)TIME_FIELD);
                    long time = ((BInteger)timeVal).intValue();
                    val = new Timestamp(time);
                } else if (value instanceof BInteger) {
                    val = new Timestamp(((BInteger)value).intValue());
                } else if (value instanceof BString) {
                    val = SQLDatasourceUtils.convertToTimeStamp(value.stringValue());
                } else {
                    throw new BallerinaException("invalid input type for timestamp parameter with index: " + index);
                }
            }
            try {
                if (0 == direction) {
                    if (val == null) {
                        stmt.setNull(index + 1, sqlType);
                    } else {
                        stmt.setTimestamp(index + 1, val, utcCalendar);
                    }
                    break block16;
                }
                if (2 == direction) {
                    if (val == null) {
                        stmt.setNull(index + 1, sqlType);
                    } else {
                        stmt.setTimestamp(index + 1, val, utcCalendar);
                    }
                    ((CallableStatement)stmt).registerOutParameter(index + 1, sqlType);
                    break block16;
                }
                if (1 == direction) {
                    ((CallableStatement)stmt).registerOutParameter(index + 1, sqlType);
                    break block16;
                }
                throw new BallerinaException("invalid direction for the parameter, index: " + index);
            }
            catch (SQLException e) {
                throw new BallerinaException("error in set timestamp value to statement: " + e.getMessage(), (Throwable)e);
            }
        }
    }

    public static void setTimeValue(PreparedStatement stmt, BValue value, int index, int direction, int sqlType, Calendar utcCalendar) {
        block15: {
            Time val = null;
            if (value != null) {
                if (value instanceof BMap && value.getType().getName().equals("Time") && value.getType().getPackagePath().equals("ballerina/time")) {
                    BValue timeVal = ((BMap)value).get((Object)TIME_FIELD);
                    long time = ((BInteger)timeVal).intValue();
                    val = new Time(time);
                } else if (value instanceof BInteger) {
                    val = new Time(((BInteger)value).intValue());
                } else if (value instanceof BString) {
                    val = SQLDatasourceUtils.convertToTime(value.stringValue());
                }
            }
            try {
                if (0 == direction) {
                    if (val == null) {
                        stmt.setNull(index + 1, sqlType);
                    } else {
                        stmt.setTime(index + 1, val, utcCalendar);
                    }
                    break block15;
                }
                if (2 == direction) {
                    if (val == null) {
                        stmt.setNull(index + 1, sqlType);
                    } else {
                        stmt.setTime(index + 1, val, utcCalendar);
                    }
                    ((CallableStatement)stmt).registerOutParameter(index + 1, sqlType);
                    break block15;
                }
                if (1 == direction) {
                    ((CallableStatement)stmt).registerOutParameter(index + 1, sqlType);
                    break block15;
                }
                throw new BallerinaException("invalid direction for the parameter with index: " + index);
            }
            catch (SQLException e) {
                throw new BallerinaException("error in set timestamp value to statement: " + e.getMessage(), (Throwable)e);
            }
        }
    }

    public static void setBinaryValue(PreparedStatement stmt, BValue value, int index, int direction, int sqlType) {
        block9: {
            byte[] val = SQLDatasourceUtils.getByteArray(value);
            try {
                if (0 == direction) {
                    if (val == null) {
                        stmt.setNull(index + 1, sqlType);
                    } else {
                        stmt.setBinaryStream(index + 1, (InputStream)new ByteArrayInputStream(val), val.length);
                    }
                    break block9;
                }
                if (2 == direction) {
                    if (val == null) {
                        stmt.setNull(index + 1, sqlType);
                    } else {
                        stmt.setBinaryStream(index + 1, (InputStream)new ByteArrayInputStream(val), val.length);
                    }
                    ((CallableStatement)stmt).registerOutParameter(index + 1, sqlType);
                    break block9;
                }
                if (1 == direction) {
                    ((CallableStatement)stmt).registerOutParameter(index + 1, sqlType);
                    break block9;
                }
                throw new BallerinaException("invalid direction for the parameter with index: " + index);
            }
            catch (SQLException e) {
                throw new BallerinaException("error in set binary value to statement: " + e.getMessage(), (Throwable)e);
            }
        }
    }

    public static void setBlobValue(PreparedStatement stmt, BValue value, int index, int direction, int sqlType) {
        block9: {
            byte[] val = SQLDatasourceUtils.getByteArray(value);
            try {
                if (0 == direction) {
                    if (val == null) {
                        stmt.setNull(index + 1, sqlType);
                    } else {
                        stmt.setBlob(index + 1, new ByteArrayInputStream(val), val.length);
                    }
                    break block9;
                }
                if (2 == direction) {
                    if (val == null) {
                        stmt.setNull(index + 1, sqlType);
                    } else {
                        stmt.setBlob(index + 1, new ByteArrayInputStream(val), val.length);
                    }
                    ((CallableStatement)stmt).registerOutParameter(index + 1, sqlType);
                    break block9;
                }
                if (1 == direction) {
                    ((CallableStatement)stmt).registerOutParameter(index + 1, sqlType);
                    break block9;
                }
                throw new BallerinaException("invalid direction for the parameter with index: " + index);
            }
            catch (SQLException e) {
                throw new BallerinaException("error in set binary value to statement: " + e.getMessage(), (Throwable)e);
            }
        }
    }

    private static Integer obtainIntegerValue(BValue value) {
        String strValue;
        if (value != null && !(strValue = value.stringValue()).isEmpty()) {
            try {
                return Integer.parseInt(strValue);
            }
            catch (NumberFormatException e) {
                throw new BallerinaException("invalid value for integer: " + strValue);
            }
        }
        return null;
    }

    private static byte[] getByteArray(BValue value) {
        byte[] val = null;
        if (value instanceof BValueArray) {
            val = ((BValueArray)value).getBytes();
        } else if (value instanceof BString) {
            val = SQLDatasourceUtils.getBytesFromBase64String(value.stringValue());
        }
        return val;
    }

    public static void setClobValue(PreparedStatement stmt, BValue value, int index, int direction, int sqlType) {
        block10: {
            BufferedReader val = null;
            if (value != null) {
                val = new BufferedReader(new StringReader(value.stringValue()));
            }
            try {
                if (0 == direction) {
                    if (val == null) {
                        stmt.setNull(index + 1, sqlType);
                    } else {
                        stmt.setClob(index + 1, val, value.stringValue().length());
                    }
                    break block10;
                }
                if (2 == direction) {
                    if (val == null) {
                        stmt.setNull(index + 1, sqlType);
                    } else {
                        stmt.setClob(index + 1, val, value.stringValue().length());
                    }
                    ((CallableStatement)stmt).registerOutParameter(index + 1, sqlType);
                    break block10;
                }
                if (1 == direction) {
                    ((CallableStatement)stmt).registerOutParameter(index + 1, sqlType);
                    break block10;
                }
                throw new BallerinaException("invalid direction for the parameter with index: " + index);
            }
            catch (SQLException e) {
                throw new BallerinaException("error in set binary value to statement: " + e.getMessage(), (Throwable)e);
            }
        }
    }

    public static void setNClobValue(PreparedStatement stmt, BValue value, int index, int direction, int sqlType) {
        block10: {
            BufferedReader val = null;
            if (value != null) {
                val = new BufferedReader(new StringReader(value.stringValue()));
            }
            try {
                if (0 == direction) {
                    if (val == null) {
                        stmt.setNull(index + 1, sqlType);
                    } else {
                        stmt.setNClob(index + 1, val, value.stringValue().length());
                    }
                    break block10;
                }
                if (2 == direction) {
                    if (val == null) {
                        stmt.setNull(index + 1, sqlType);
                    } else {
                        stmt.setNClob(index + 1, val, value.stringValue().length());
                    }
                    ((CallableStatement)stmt).registerOutParameter(index + 1, sqlType);
                    break block10;
                }
                if (1 == direction) {
                    ((CallableStatement)stmt).registerOutParameter(index + 1, sqlType);
                    break block10;
                }
                throw new BallerinaException("invalid direction for the parameter with index: " + index);
            }
            catch (SQLException e) {
                throw new BallerinaException("error in set binary value to statement: " + e.getMessage(), (Throwable)e);
            }
        }
    }

    public static void setRefCursorValue(PreparedStatement stmt, int index, int direction, String databaseProductName) {
        block5: {
            try {
                if (1 == direction) {
                    if (ORACLE_DATABASE_NAME.equals(databaseProductName)) {
                        ((CallableStatement)stmt).registerOutParameter(index + 1, -10);
                    } else {
                        ((CallableStatement)stmt).registerOutParameter(index + 1, 2012);
                    }
                    break block5;
                }
                throw new BallerinaException("invalid direction for the parameter with index: " + index);
            }
            catch (SQLException e) {
                throw new BallerinaException("error in setting ref cursor value to statement: " + e.getMessage(), (Throwable)e);
            }
        }
    }

    public static void setArrayValue(Connection conn, PreparedStatement stmt, BValue value, int index, int direction, int sqlType, String databaseProductName) {
        block5: {
            Object[] arrayData = SQLDatasourceUtils.getArrayData(value);
            Object[] arrayValue = (Object[])arrayData[0];
            String structuredSQLType = (String)arrayData[1];
            try {
                if (0 == direction) {
                    SQLDatasourceUtils.setArrayValue(arrayValue, conn, stmt, index, sqlType, databaseProductName, structuredSQLType);
                    break block5;
                }
                if (2 == direction) {
                    SQLDatasourceUtils.setArrayValue(arrayValue, conn, stmt, index, sqlType, databaseProductName, structuredSQLType);
                    SQLDatasourceUtils.registerArrayOutParameter(stmt, index, sqlType, structuredSQLType, databaseProductName);
                    break block5;
                }
                if (1 == direction) {
                    SQLDatasourceUtils.registerArrayOutParameter(stmt, index, sqlType, structuredSQLType, databaseProductName);
                    break block5;
                }
                throw new BallerinaException("invalid direction for the parameter with index: " + index);
            }
            catch (SQLException e) {
                throw new BallerinaException("error in set array value to statement: " + e.getMessage(), (Throwable)e);
            }
        }
    }

    public static void setNullObject(PreparedStatement stmt, int index) {
        try {
            stmt.setObject(index + 1, null);
        }
        catch (SQLException e) {
            throw new BallerinaException("error in set null to parameter with index: " + index);
        }
    }

    private static Object[] getArrayData(BValue value) {
        if (value == null || value.getType().getTag() != 20) {
            return new Object[]{null, null};
        }
        int typeTag = ((BArrayType)value.getType()).getElementType().getTag();
        switch (typeTag) {
            case 1: {
                int arrayLength = (int)((BValueArray)value).size();
                Long[] arrayData = new Long[arrayLength];
                for (int i = 0; i < arrayLength; ++i) {
                    arrayData[i] = ((BValueArray)value).getInt((long)i);
                }
                return new Object[]{arrayData, "BIGINT"};
            }
            case 3: {
                int arrayLength = (int)((BValueArray)value).size();
                Double[] arrayData = new Double[arrayLength];
                for (int i = 0; i < arrayLength; ++i) {
                    arrayData[i] = ((BValueArray)value).getFloat((long)i);
                }
                return new Object[]{arrayData, "DOUBLE"};
            }
            case 5: {
                int arrayLength = (int)((BValueArray)value).size();
                String[] arrayData = new String[arrayLength];
                for (int i = 0; i < arrayLength; ++i) {
                    arrayData[i] = ((BValueArray)value).getString((long)i);
                }
                return new Object[]{arrayData, "VARCHAR"};
            }
            case 6: {
                int arrayLength = (int)((BValueArray)value).size();
                Boolean[] arrayData = new Boolean[arrayLength];
                for (int i = 0; i < arrayLength; ++i) {
                    arrayData[i] = ((BValueArray)value).getBoolean((long)i) > 0;
                }
                return new Object[]{arrayData, "BOOLEAN"};
            }
            case 20: {
                BType elementType = ((BArrayType)((BArrayType)value.getType()).getElementType()).getElementType();
                if (elementType.getTag() == 2) {
                    int arrayLength = (int)((BValueArray)value).size();
                    Blob[] arrayData = new Blob[arrayLength];
                    for (int i = 0; i < arrayLength; ++i) {
                        arrayData[i] = ((BValueArray)value).getByte((long)i);
                    }
                    return new Object[]{arrayData, "BLOB"};
                }
                throw new BallerinaException("unsupported data type for array parameter");
            }
        }
        throw new BallerinaException("unsupported data type for array parameter");
    }

    public static void setUserDefinedValue(Connection conn, PreparedStatement stmt, BValue value, int index, int direction, int sqlType) {
        block9: {
            try {
                Object[] structData = SQLDatasourceUtils.getStructData(value, conn);
                Object[] dataArray = (Object[])structData[0];
                String structuredSQLType = (String)structData[1];
                if (0 == direction) {
                    if (dataArray == null) {
                        stmt.setNull(index + 1, sqlType);
                    } else {
                        java.sql.Struct struct = conn.createStruct(structuredSQLType, dataArray);
                        stmt.setObject(index + 1, struct);
                    }
                    break block9;
                }
                if (2 == direction) {
                    if (dataArray == null) {
                        stmt.setNull(index + 1, sqlType);
                    } else {
                        java.sql.Struct struct = conn.createStruct(structuredSQLType, dataArray);
                        stmt.setObject(index + 1, struct);
                    }
                    ((CallableStatement)stmt).registerOutParameter(index + 1, sqlType, structuredSQLType);
                    break block9;
                }
                if (1 == direction) {
                    ((CallableStatement)stmt).registerOutParameter(index + 1, sqlType, structuredSQLType);
                    break block9;
                }
                throw new BallerinaException("invalid direction for the parameter with index: " + index);
            }
            catch (SQLException e) {
                throw new BallerinaException("error in set struct value to statement: " + e.getMessage(), (Throwable)e);
            }
        }
    }

    private static Object[] getStructData(BValue value, Connection conn) throws SQLException {
        if (value == null || value.getType().getTag() != 35 && value.getType().getTag() != 12) {
            return new Object[]{null, null};
        }
        String structuredSQLType = value.getType().getName().toUpperCase(Locale.getDefault());
        Map structFields = ((BStructureType)value.getType()).getFields();
        int fieldCount = structFields.size();
        Object[] structData = new Object[fieldCount];
        Iterator fieldIterator = structFields.values().iterator();
        block8: for (int i = 0; i < fieldCount; ++i) {
            BField field = (BField)fieldIterator.next();
            BValue bValue = ((BMap)value).get((Object)field.fieldName);
            int typeTag = field.getFieldType().getTag();
            switch (typeTag) {
                case 1: {
                    structData[i] = ((BInteger)bValue).intValue();
                    continue block8;
                }
                case 3: {
                    structData[i] = ((BFloat)bValue).floatValue();
                    continue block8;
                }
                case 5: {
                    structData[i] = bValue.stringValue();
                    continue block8;
                }
                case 6: {
                    structData[i] = ((BBoolean)bValue).booleanValue();
                    continue block8;
                }
                case 20: {
                    BType elementType = ((BArrayType)field.getFieldType()).getElementType();
                    if (elementType.getTag() == 2) {
                        structData[i] = ((BValueArray)bValue).getBytes();
                        continue block8;
                    }
                    throw new BallerinaException("unsupported data type for struct parameter: " + structuredSQLType);
                }
                case 12: 
                case 35: {
                    Object structValue = bValue;
                    if (structValue instanceof BMap) {
                        Object[] internalStructData = SQLDatasourceUtils.getStructData((BValue)((BMap)structValue), conn);
                        Object[] dataArray = (Object[])internalStructData[0];
                        String internalStructType = (String)internalStructData[1];
                        structValue = conn.createStruct(internalStructType, dataArray);
                    }
                    structData[i] = structValue;
                    continue block8;
                }
                default: {
                    throw new BallerinaException("unsupported data type for struct parameter: " + structuredSQLType);
                }
            }
        }
        return new Object[]{structData, structuredSQLType};
    }

    public static void cleanupResources(List<ResultSet> resultSets, Statement stmt, Connection conn, boolean connectionClosable) {
        try {
            if (resultSets != null) {
                for (ResultSet rs : resultSets) {
                    if (rs == null || rs.isClosed()) continue;
                    rs.close();
                }
            }
            SQLDatasourceUtils.cleanupResources(stmt, conn, connectionClosable);
        }
        catch (SQLException e) {
            throw new BallerinaException("error in cleaning sql resources: " + e.getMessage(), (Throwable)e);
        }
    }

    public static void cleanupResources(ResultSet rs, Statement stmt, Connection conn, boolean connectionClosable) {
        try {
            if (rs != null && !rs.isClosed()) {
                rs.close();
            }
            SQLDatasourceUtils.cleanupResources(stmt, conn, connectionClosable);
        }
        catch (SQLException e) {
            throw new BallerinaException("error in cleaning sql resources: " + e.getMessage(), (Throwable)e);
        }
    }

    public static void cleanupResources(Statement stmt, Connection conn, boolean connectionClosable) {
        try {
            if (stmt != null && !stmt.isClosed()) {
                stmt.close();
            }
            if (conn != null && !conn.isClosed() && connectionClosable) {
                conn.close();
            }
        }
        catch (SQLException e) {
            throw new BallerinaException("error in cleaning sql resources: " + e.getMessage(), (Throwable)e);
        }
    }

    private static TypeKind getColumnType(int sqlType) {
        switch (sqlType) {
            case 2003: {
                return TypeKind.ARRAY;
            }
            case -16: 
            case -15: 
            case -9: 
            case -8: 
            case -1: 
            case 1: 
            case 12: 
            case 91: 
            case 92: 
            case 93: 
            case 2005: 
            case 2011: 
            case 2013: 
            case 2014: {
                return TypeKind.STRING;
            }
            case -6: 
            case -5: 
            case 4: 
            case 5: {
                return TypeKind.INT;
            }
            case -7: 
            case 16: {
                return TypeKind.BOOLEAN;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: {
                return TypeKind.FLOAT;
            }
            case -4: 
            case -3: 
            case -2: 
            case 2004: {
                return TypeKind.BLOB;
            }
            case 2002: {
                return TypeKind.RECORD;
            }
        }
        return TypeKind.NONE;
    }

    public static String getSQLType(BType value) {
        int tag = value.getTag();
        switch (tag) {
            case 1: {
                return "BIGINT";
            }
            case 5: {
                return "VARCHAR";
            }
            case 3: {
                return "DOUBLE";
            }
            case 6: {
                return "BOOLEAN";
            }
        }
        throw new BallerinaException("unsupported data type as direct value for sql operation, use sql:Parameter: " + value.getName());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getString(Clob data) {
        if (data == null) {
            return null;
        }
        try (BufferedReader r = new BufferedReader(data.getCharacterStream());){
            int pos;
            StringBuilder sb = new StringBuilder();
            while ((pos = ((Reader)r).read()) != -1) {
                sb.append((char)pos);
            }
            String string = sb.toString();
            return string;
        }
        catch (IOException | SQLException e) {
            throw new BallerinaException("error occurred while reading clob value: " + e.getMessage(), (Throwable)e);
        }
    }

    public static String getString(Blob data) {
        if (data == null) {
            return null;
        }
        try {
            byte[] encode = SQLDatasourceUtils.getBase64Encode(new String(data.getBytes(1L, (int)data.length()), Charset.defaultCharset()));
            return new String(encode, Charset.defaultCharset());
        }
        catch (SQLException e) {
            throw new BallerinaException("error occurred while reading blob value", (Throwable)e);
        }
    }

    public static String getString(byte[] data) {
        if (data == null) {
            return null;
        }
        return new String(data, Charset.defaultCharset());
    }

    public static String getString(java.util.Date value) {
        String type;
        if (value == null) {
            return null;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.clear();
        if (value instanceof Time) {
            calendar.setTimeInMillis(value.getTime());
            type = TIME_FIELD;
        } else if (value instanceof Timestamp) {
            calendar.setTimeInMillis(value.getTime());
            type = "datetime";
        } else if (value instanceof Date) {
            calendar.setTime(value);
            type = "date";
        } else {
            calendar.setTime(value);
            type = TIME_FIELD;
        }
        return SQLDatasourceUtils.getString(calendar, type);
    }

    public static String getString(Array dataArray) throws SQLException {
        if (dataArray == null) {
            return null;
        }
        StringJoiner sj = new StringJoiner(",", "[", "]");
        ResultSet rs = dataArray.getResultSet();
        while (rs.next()) {
            Object arrayEl = rs.getObject(2);
            String val = String.valueOf(arrayEl);
            sj.add(val);
        }
        return sj.toString();
    }

    public static String getString(java.sql.Struct udt) throws SQLException {
        if (udt.getAttributes() != null) {
            Object[] udtValues;
            StringJoiner sj = new StringJoiner(",", "{", "}");
            for (Object obj : udtValues = udt.getAttributes()) {
                sj.add(String.valueOf(obj));
            }
            return sj.toString();
        }
        return null;
    }

    public static BError getSQLConnectorError(Context context, Throwable throwable) {
        String detailedErrorMessage = throwable.getMessage() != null ? throwable.getMessage() : "SQL Error Occurred";
        BMap sqlClientErrorDetailRecord = BLangConnectorSPIUtil.createBStruct((Context)context, (String)"ballerina/sql", (String)"DatabaseErrorData", (Object[])new Object[]{detailedErrorMessage});
        return BLangVMErrors.createError((Context)context, (boolean)true, (BErrorType)BTypes.typeError, (String)"{ballerina/sql}DatabaseError", (BMap)sqlClientErrorDetailRecord);
    }

    public static void handleErrorOnTransaction(Context context) {
        TransactionLocalContext transactionLocalContext = context.getLocalTransactionInfo();
        if (transactionLocalContext == null) {
            return;
        }
        SQLDatasourceUtils.notifyTxMarkForAbort(context, transactionLocalContext);
    }

    private static void notifyTxMarkForAbort(Context context, TransactionLocalContext transactionLocalContext) {
        String globalTransactionId = transactionLocalContext.getGlobalTransactionId();
        String transactionBlockId = transactionLocalContext.getCurrentTransactionBlockId();
        transactionLocalContext.markFailure();
        if (transactionLocalContext.isRetryPossible(context.getStrand(), transactionBlockId)) {
            return;
        }
        TransactionUtils.notifyTransactionAbort((Strand)context.getStrand(), (String)globalTransactionId, (String)transactionBlockId);
    }

    public static BMap<String, BValue> createServerBasedDBClient(Context context, String dbType, Struct clientEndpointConfig, String urlOptions) {
        String host = clientEndpointConfig.getStringField("host");
        int port = (int)clientEndpointConfig.getIntField("port");
        String name = clientEndpointConfig.getStringField("name");
        String username = clientEndpointConfig.getStringField("username");
        String password = clientEndpointConfig.getStringField("password");
        Struct options = clientEndpointConfig.getStructField("poolOptions");
        SQLDatasource.SQLDatasourceParamsBuilder builder = new SQLDatasource.SQLDatasourceParamsBuilder(dbType);
        SQLDatasource.SQLDatasourceParams sqlDatasourceParams = builder.withHostOrPath(host).withPort(port).withJdbcUrl("").withOptions(options).withUsername(username).withPassword(password).withDbName(name).withUrlOptions(urlOptions).build();
        return SQLDatasourceUtils.createSQLDataSource(context, sqlDatasourceParams);
    }

    public static BMap<String, BValue> createSQLDBClient(Context context, Struct clientEndpointConfig) {
        String url = clientEndpointConfig.getStringField("url");
        String username = clientEndpointConfig.getStringField("username");
        String password = clientEndpointConfig.getStringField("password");
        Map dbOptions = clientEndpointConfig.getMapField("dbOptions");
        Struct options = clientEndpointConfig.getStructField("poolOptions");
        String dbType = url.split(":")[1].toUpperCase(Locale.getDefault());
        SQLDatasource.SQLDatasourceParamsBuilder builder = new SQLDatasource.SQLDatasourceParamsBuilder(dbType);
        SQLDatasource.SQLDatasourceParams sqlDatasourceParams = builder.withJdbcUrl("").withOptions(options).withOptions(options).withJdbcUrl(url).withHostOrPath("").withPort(0).withUsername(username).withPassword(password).withDbName("").withUrlOptions("").withDbOptionsMap(dbOptions).build();
        return SQLDatasourceUtils.createSQLDataSource(context, sqlDatasourceParams);
    }

    public static BMap<String, BValue> createMultiModeDBClient(Context context, String dbType, Struct clientEndpointConfig, String urlOptions) {
        String modeRecordType = clientEndpointConfig.getName();
        String dbPostfix = "_MEMORY";
        String hostOrPath = "";
        int port = -1;
        if (modeRecordType.equals("ServerModeConfig")) {
            dbPostfix = "_SERVER";
            hostOrPath = clientEndpointConfig.getStringField("host");
            port = (int)clientEndpointConfig.getIntField("port");
        } else if (modeRecordType.equals("EmbeddedModeConfig")) {
            dbPostfix = "_FILE";
            hostOrPath = clientEndpointConfig.getStringField("path");
        }
        dbType = dbType + dbPostfix;
        String name = clientEndpointConfig.getStringField("name");
        String username = clientEndpointConfig.getStringField("username");
        String password = clientEndpointConfig.getStringField("password");
        Struct options = clientEndpointConfig.getStructField("poolOptions");
        SQLDatasource.SQLDatasourceParamsBuilder builder = new SQLDatasource.SQLDatasourceParamsBuilder(dbType);
        SQLDatasource.SQLDatasourceParams sqlDatasourceParams = builder.withOptions(options).withJdbcUrl("").withDbType(dbType).withHostOrPath(hostOrPath).withPort(port).withUsername(username).withPassword(password).withDbName(name).withUrlOptions(urlOptions).build();
        return SQLDatasourceUtils.createSQLDataSource(context, sqlDatasourceParams);
    }

    private static void registerArrayOutParameter(PreparedStatement stmt, int index, int sqlType, String structuredSQLType, String databaseProductName) throws SQLException {
        if (databaseProductName.equals(POSTGRES_DATABASE_NAME)) {
            ((CallableStatement)stmt).registerOutParameter(index + 1, sqlType);
        } else {
            ((CallableStatement)stmt).registerOutParameter(index + 1, sqlType, structuredSQLType);
        }
    }

    private static void setArrayValue(Object[] arrayValue, Connection conn, PreparedStatement stmt, int index, int sqlType, String databaseProductName, String structuredSQLType) throws SQLException {
        if (arrayValue == null) {
            stmt.setNull(index + 1, sqlType);
        } else {
            if ("DOUBLE".equals(structuredSQLType) && POSTGRES_DATABASE_NAME.equals(databaseProductName)) {
                structuredSQLType = POSTGRES_DOUBLE;
            }
            Array array = conn.createArrayOf(structuredSQLType, arrayValue);
            stmt.setArray(index + 1, array);
        }
    }

    private static BMap<String, BValue> createSQLDataSource(Context context, SQLDatasource.SQLDatasourceParams sqlDatasourceParams) {
        SQLDatasource datasource = new SQLDatasource();
        datasource.init(sqlDatasourceParams);
        BMap sqlClient = BLangConnectorSPIUtil.createBStruct((ProgramFile)context.getProgramFile(), (String)"ballerina/sql", (String)"Client", (Object[])new Object[0]);
        sqlClient.addNativeData("Client", (Object)datasource);
        return sqlClient;
    }

    private static String getString(Calendar calendar, String type) {
        if (!calendar.isSet(15)) {
            calendar.setTimeZone(TimeZone.getDefault());
        }
        StringBuffer datetimeString = new StringBuffer(28);
        switch (type) {
            case "date": {
                SQLDatasourceUtils.appendDate(datetimeString, calendar);
                SQLDatasourceUtils.appendTimeZone(calendar, datetimeString);
                break;
            }
            case "time": {
                SQLDatasourceUtils.appendTime(calendar, datetimeString);
                SQLDatasourceUtils.appendTimeZone(calendar, datetimeString);
                break;
            }
            case "datetime": {
                SQLDatasourceUtils.appendDate(datetimeString, calendar);
                datetimeString.append("T");
                SQLDatasourceUtils.appendTime(calendar, datetimeString);
                SQLDatasourceUtils.appendTimeZone(calendar, datetimeString);
                break;
            }
            default: {
                throw new BallerinaException("invalid type for datetime data: " + type);
            }
        }
        return datetimeString.toString();
    }

    private static byte[] getBytesFromBase64String(String base64Str) {
        try {
            return Base64.getDecoder().decode(base64Str.getBytes(Charset.defaultCharset()));
        }
        catch (Exception e) {
            throw new BallerinaException("error in processing base64 string: " + e.getMessage(), (Throwable)e);
        }
    }

    private static byte[] getBase64Encode(String st) {
        return Base64.getEncoder().encode(st.getBytes(Charset.defaultCharset()));
    }

    private static void appendTimeZone(Calendar calendar, StringBuffer dateString) {
        int timezoneOffSet = calendar.get(15) + calendar.get(16);
        int timezoneOffSetInMinits = timezoneOffSet / 60000;
        if (timezoneOffSetInMinits < 0) {
            dateString.append("-");
            timezoneOffSetInMinits *= -1;
        } else {
            dateString.append("+");
        }
        int hours = timezoneOffSetInMinits / 60;
        int minits = timezoneOffSetInMinits % 60;
        if (hours < 10) {
            dateString.append("0");
        }
        dateString.append(hours).append(":");
        if (minits < 10) {
            dateString.append("0");
        }
        dateString.append(minits);
    }

    private static void appendTime(Calendar value, StringBuffer dateString) {
        if (value.get(11) < 10) {
            dateString.append("0");
        }
        dateString.append(value.get(11)).append(":");
        if (value.get(12) < 10) {
            dateString.append("0");
        }
        dateString.append(value.get(12)).append(":");
        if (value.get(13) < 10) {
            dateString.append("0");
        }
        dateString.append(value.get(13)).append(".");
        if (value.get(14) < 10) {
            dateString.append("0");
        }
        if (value.get(14) < 100) {
            dateString.append("0");
        }
        dateString.append(value.get(14));
    }

    private static void appendDate(StringBuffer dateString, Calendar calendar) {
        int year = calendar.get(1);
        if (year < 1000) {
            dateString.append("0");
        }
        if (year < 100) {
            dateString.append("0");
        }
        if (year < 10) {
            dateString.append("0");
        }
        dateString.append(year).append("-");
        int month = calendar.get(2) + 1;
        if (month < 10) {
            dateString.append("0");
        }
        dateString.append(month).append("-");
        if (calendar.get(5) < 10) {
            dateString.append("0");
        }
        dateString.append(calendar.get(5));
    }

    private static Date convertToDate(String source) {
        int timeZoneOffSet;
        int day;
        int month;
        int year;
        if (source == null || source.trim().equals("")) {
            return null;
        }
        source = source.trim();
        Calendar calendar = Calendar.getInstance();
        calendar.clear();
        calendar.setLenient(false);
        if (source.startsWith("-")) {
            source = source.substring(1);
            calendar.set(0, 0);
        }
        if (source.length() >= 10) {
            if (source.charAt(4) != '-' || source.charAt(7) != '-') {
                throw new BallerinaException("invalid date format: " + source);
            }
            year = Integer.parseInt(source.substring(0, 4));
            month = Integer.parseInt(source.substring(5, 7));
            day = Integer.parseInt(source.substring(8, 10));
            timeZoneOffSet = TimeZone.getDefault().getRawOffset();
            if (source.length() > 10) {
                String restpart = source.substring(10);
                timeZoneOffSet = SQLDatasourceUtils.getTimeZoneOffset(restpart);
                calendar.set(16, 0);
            }
        } else {
            throw new BallerinaException("invalid date string to parse: " + source);
        }
        calendar.set(1, year);
        calendar.set(2, month - 1);
        calendar.set(5, day);
        calendar.set(15, timeZoneOffSet);
        return new Date(calendar.getTime().getTime());
    }

    private static Time convertToTime(String source) {
        int timeZoneOffSet;
        int miliSecond;
        int second;
        int minite;
        int hour;
        if (source == null || source.trim().equals("")) {
            return null;
        }
        source = source.trim();
        Calendar calendar = Calendar.getInstance();
        calendar.clear();
        calendar.setLenient(false);
        if (source.length() >= 8) {
            if (source.charAt(2) != ':' || source.charAt(5) != ':') {
                throw new BallerinaException("invalid time format: " + source);
            }
            hour = Integer.parseInt(source.substring(0, 2));
            minite = Integer.parseInt(source.substring(3, 5));
            second = Integer.parseInt(source.substring(6, 8));
            miliSecond = 0;
            timeZoneOffSet = TimeZone.getDefault().getRawOffset();
            if (source.length() > 8) {
                String rest = source.substring(8);
                int[] offsetData = SQLDatasourceUtils.getTimeZoneWithMilliSeconds(rest);
                miliSecond = offsetData[0];
                timeZoneOffSet = offsetData[1];
                calendar.set(16, 0);
            }
        } else {
            throw new BallerinaException("time string can not be less than 8 characters: " + source);
        }
        calendar.set(11, hour);
        calendar.set(12, minite);
        calendar.set(13, second);
        calendar.set(14, miliSecond);
        calendar.set(15, timeZoneOffSet);
        return new Time(calendar.getTimeInMillis());
    }

    private static Timestamp convertToTimeStamp(String source) {
        int timeZoneOffSet;
        long miliSecond;
        int second;
        int minite;
        int hour;
        int day;
        int month;
        int year;
        if (source == null || source.trim().equals("")) {
            return null;
        }
        source = source.trim();
        Calendar calendar = Calendar.getInstance();
        calendar.clear();
        calendar.setLenient(false);
        if (source.startsWith("-")) {
            source = source.substring(1);
            calendar.set(0, 0);
        }
        if (source.length() >= 19) {
            if (source.charAt(4) != '-' || source.charAt(7) != '-' || source.charAt(10) != 'T' || source.charAt(13) != ':' || source.charAt(16) != ':') {
                throw new BallerinaException("invalid datetime format: " + source);
            }
            year = Integer.parseInt(source.substring(0, 4));
            month = Integer.parseInt(source.substring(5, 7));
            day = Integer.parseInt(source.substring(8, 10));
            hour = Integer.parseInt(source.substring(11, 13));
            minite = Integer.parseInt(source.substring(14, 16));
            second = Integer.parseInt(source.substring(17, 19));
            miliSecond = 0L;
            timeZoneOffSet = TimeZone.getDefault().getRawOffset();
            if (source.length() > 19) {
                String rest = source.substring(19);
                int[] offsetData = SQLDatasourceUtils.getTimeZoneWithMilliSeconds(rest);
                miliSecond = offsetData[0];
                int calculatedtimeZoneOffSet = offsetData[1];
                if (calculatedtimeZoneOffSet != -1) {
                    timeZoneOffSet = calculatedtimeZoneOffSet;
                }
                calendar.set(16, 0);
            }
        } else {
            throw new BallerinaException("datetime string can not be less than 19 characters: " + source);
        }
        calendar.set(1, year);
        calendar.set(2, month - 1);
        calendar.set(5, day);
        calendar.set(11, hour);
        calendar.set(12, minite);
        calendar.set(13, second);
        calendar.set(14, (int)miliSecond);
        calendar.set(15, timeZoneOffSet);
        return new Timestamp(calendar.getTimeInMillis());
    }

    private static int[] getTimeZoneWithMilliSeconds(String fractionStr) {
        int miliSecond = 0;
        int timeZoneOffSet = -1;
        if (fractionStr.startsWith(".")) {
            int milliSecondPartLength = 0;
            if (fractionStr.endsWith("Z")) {
                timeZoneOffSet = 0;
                String fractionPart = fractionStr.substring(1, fractionStr.lastIndexOf("Z"));
                miliSecond = Integer.parseInt(fractionPart);
                milliSecondPartLength = fractionPart.trim().length();
            } else {
                int lastIndexOfPlus = fractionStr.lastIndexOf("+");
                int lastIndexofMinus = fractionStr.lastIndexOf("-");
                if (lastIndexOfPlus > 0 || lastIndexofMinus > 0) {
                    String fractionPart;
                    String timeOffSetStr = null;
                    if (lastIndexOfPlus > 0) {
                        timeOffSetStr = fractionStr.substring(lastIndexOfPlus + 1);
                        fractionPart = fractionStr.substring(1, lastIndexOfPlus);
                        miliSecond = Integer.parseInt(fractionPart);
                        milliSecondPartLength = fractionPart.trim().length();
                        timeZoneOffSet = 1;
                    } else if (lastIndexofMinus > 0) {
                        timeOffSetStr = fractionStr.substring(lastIndexofMinus + 1);
                        fractionPart = fractionStr.substring(1, lastIndexofMinus);
                        miliSecond = Integer.parseInt(fractionPart);
                        milliSecondPartLength = fractionPart.trim().length();
                        timeZoneOffSet = -1;
                    }
                    if (timeOffSetStr != null) {
                        if (timeOffSetStr.charAt(2) != ':') {
                            throw new BallerinaException("invalid time zone format: " + fractionStr);
                        }
                        int hours = Integer.parseInt(timeOffSetStr.substring(0, 2));
                        int minits = Integer.parseInt(timeOffSetStr.substring(3, 5));
                        timeZoneOffSet = (hours * 60 + minits) * 60000 * timeZoneOffSet;
                    }
                } else {
                    miliSecond = Integer.parseInt(fractionStr.substring(1));
                    milliSecondPartLength = fractionStr.substring(1).trim().length();
                }
            }
            if (milliSecondPartLength != 3) {
                miliSecond *= 1000;
                for (int i = 0; i < milliSecondPartLength; ++i) {
                    miliSecond /= 10;
                }
            }
        } else {
            timeZoneOffSet = SQLDatasourceUtils.getTimeZoneOffset(fractionStr);
        }
        return new int[]{miliSecond, timeZoneOffSet};
    }

    private static int getTimeZoneOffset(String timezoneStr) {
        int timeZoneOffSet;
        if (timezoneStr.startsWith("Z")) {
            timeZoneOffSet = 0;
        } else if (timezoneStr.startsWith("+") || timezoneStr.startsWith("-")) {
            if (timezoneStr.charAt(3) != ':') {
                throw new BallerinaException("invalid time zone format:" + timezoneStr);
            }
            int hours = Integer.parseInt(timezoneStr.substring(1, 3));
            int minits = Integer.parseInt(timezoneStr.substring(4, 6));
            timeZoneOffSet = (hours * 60 + minits) * 60000;
            if (timezoneStr.startsWith("-")) {
                timeZoneOffSet *= -1;
            }
        } else {
            throw new BallerinaException("invalid prefix for timezone: " + timezoneStr);
        }
        return timeZoneOffSet;
    }

    public static List<ColumnDefinition> getColumnDefinitions(ResultSet rs) throws SQLException {
        ArrayList<ColumnDefinition> columnDefs = new ArrayList<ColumnDefinition>();
        HashSet<String> columnNames = new HashSet<String>();
        ResultSetMetaData rsMetaData = rs.getMetaData();
        int cols = rsMetaData.getColumnCount();
        for (int i = 1; i <= cols; ++i) {
            String colName = rsMetaData.getColumnLabel(i);
            if (columnNames.contains(colName)) {
                String tableName = rsMetaData.getTableName(i).toUpperCase(Locale.getDefault());
                colName = tableName + "." + colName;
            }
            int colType = rsMetaData.getColumnType(i);
            TypeKind mappedType = SQLDatasourceUtils.getColumnType(colType);
            columnDefs.add(new SQLDataIterator.SQLColumnDefinition(colName, mappedType, colType));
            columnNames.add(colName);
        }
        return columnDefs;
    }

    public static Connection getDatabaseConnection(Context context, SQLDatasource datasource, boolean isSelectQuery) throws SQLException {
        Connection conn;
        boolean isInTransaction = context.isInTransaction();
        if (!isInTransaction || isSelectQuery) {
            Connection conn2 = datasource.getSQLConnection();
            return conn2;
        }
        if (!context.getLocalTransactionInfo().hasTransactionBlock()) {
            Connection conn3 = datasource.getSQLConnection();
            return conn3;
        }
        String connectorId = datasource.getConnectorId();
        boolean isXAConnection = datasource.isXAConnection();
        TransactionLocalContext transactionLocalContext = context.getLocalTransactionInfo();
        String globalTxId = transactionLocalContext.getGlobalTransactionId();
        String currentTxBlockId = transactionLocalContext.getCurrentTransactionBlockId();
        BallerinaTransactionContext txContext = transactionLocalContext.getTransactionContext(connectorId);
        if (txContext == null) {
            if (isXAConnection) {
                XAConnection xaConn = datasource.getXADataSource().getXAConnection();
                XAResource xaResource = xaConn.getXAResource();
                TransactionResourceManager.getInstance().beginXATransaction(globalTxId, currentTxBlockId, xaResource);
                conn = xaConn.getConnection();
                txContext = new SQLTransactionContext(conn, xaResource);
            } else {
                conn = datasource.getSQLConnection();
                conn.setAutoCommit(false);
                txContext = new SQLTransactionContext(conn);
            }
            transactionLocalContext.registerTransactionContext(connectorId, txContext);
            TransactionResourceManager.getInstance().register(globalTxId, currentTxBlockId, txContext);
        } else {
            conn = ((SQLTransactionContext)txContext).getConnection();
        }
        return conn;
    }

    public static String createJDBCDbOptions(String propertiesBeginSymbol, String separator, Map<String, Value> dbOptions) {
        StringJoiner dbOptionsStringJoiner = new StringJoiner(separator, propertiesBeginSymbol, "");
        for (Map.Entry<String, Value> entry : dbOptions.entrySet()) {
            String dataValue = null;
            Value value = entry.getValue();
            if (value != null) {
                switch (value.getType()) {
                    case INT: {
                        dataValue = Long.toString(value.getIntValue());
                        break;
                    }
                    case FLOAT: {
                        dataValue = Double.toString(value.getFloatValue());
                        break;
                    }
                    case BOOLEAN: {
                        dataValue = Boolean.toString(value.getBooleanValue());
                        break;
                    }
                    default: {
                        dataValue = value.getStringValue();
                    }
                }
            }
            dbOptionsStringJoiner.add(entry.getKey() + "=" + dataValue);
        }
        return dbOptionsStringJoiner.toString();
    }
}

