/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.database.sql;

import java.sql.Connection;
import java.sql.SQLException;
import javax.transaction.xa.XAResource;
import org.ballerinalang.util.exceptions.BallerinaException;
import org.ballerinalang.util.transactions.BallerinaTransactionContext;

public class SQLTransactionContext
implements BallerinaTransactionContext {
    private Connection conn;
    private XAResource xaResource;

    public SQLTransactionContext(Connection conn, XAResource resource) {
        this.conn = conn;
        this.xaResource = resource;
    }

    public SQLTransactionContext(Connection conn) {
        this.conn = conn;
    }

    public Connection getConnection() {
        return this.conn;
    }

    public void commit() {
        try {
            this.conn.commit();
        }
        catch (SQLException e) {
            throw new BallerinaException("transaction commit failed:" + e.getMessage());
        }
    }

    public void rollback() {
        try {
            if (!this.conn.isClosed()) {
                this.conn.rollback();
            }
        }
        catch (SQLException e) {
            throw new BallerinaException("transaction rollback failed:" + e.getMessage());
        }
    }

    public void close() {
        try {
            if (!this.conn.isClosed()) {
                this.conn.close();
            }
        }
        catch (SQLException e) {
            throw new BallerinaException("connection close failed:" + e.getMessage());
        }
    }

    public XAResource getXAResource() {
        return this.xaResource;
    }
}

