/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.database.sql.actions;

import java.math.BigDecimal;
import java.sql.Array;
import java.sql.BatchUpdateException;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Struct;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.TimeZone;
import javax.sql.rowset.CachedRowSet;
import javax.sql.rowset.RowSetProvider;
import org.ballerinalang.bre.Context;
import org.ballerinalang.bre.bvm.BlockingNativeCallableUnit;
import org.ballerinalang.database.sql.SQLDataIterator;
import org.ballerinalang.database.sql.SQLDatasource;
import org.ballerinalang.database.sql.SQLDatasourceUtils;
import org.ballerinalang.database.table.BCursorTable;
import org.ballerinalang.model.ColumnDefinition;
import org.ballerinalang.model.DataIterator;
import org.ballerinalang.model.types.BArrayType;
import org.ballerinalang.model.types.BStructureType;
import org.ballerinalang.model.types.BTupleType;
import org.ballerinalang.model.types.BType;
import org.ballerinalang.model.types.BTypes;
import org.ballerinalang.model.values.BBoolean;
import org.ballerinalang.model.values.BByte;
import org.ballerinalang.model.values.BFloat;
import org.ballerinalang.model.values.BInteger;
import org.ballerinalang.model.values.BMap;
import org.ballerinalang.model.values.BNewArray;
import org.ballerinalang.model.values.BRefType;
import org.ballerinalang.model.values.BString;
import org.ballerinalang.model.values.BTable;
import org.ballerinalang.model.values.BTypeDescValue;
import org.ballerinalang.model.values.BValue;
import org.ballerinalang.model.values.BValueArray;
import org.ballerinalang.stdlib.time.util.TimeUtils;
import org.ballerinalang.util.TableResourceManager;
import org.ballerinalang.util.codegen.PackageInfo;
import org.ballerinalang.util.codegen.StructureTypeInfo;
import org.ballerinalang.util.exceptions.BallerinaException;
import org.ballerinalang.util.observability.ObserveUtils;

public abstract class AbstractSQLAction
extends BlockingNativeCallableUnit {
    private Calendar utcCalendar = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
    private static final BTupleType executeUpdateWithKeysTupleType = new BTupleType(Arrays.asList(BTypes.typeInt, new BArrayType(BTypes.typeString)));
    private static final String MYSQL = "mysql";

    protected void executeQuery(Context context, SQLDatasource datasource, String query, BValueArray parameters, BStructureType structType, boolean loadSQLTableToMemory) {
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            BValueArray generatedParams = this.constructParameters(context, parameters);
            conn = SQLDatasourceUtils.getDatabaseConnection(context, datasource, true);
            String processedQuery = this.createProcessedQueryString(query, generatedParams);
            stmt = this.getPreparedStatement(conn, datasource, processedQuery, loadSQLTableToMemory);
            this.createProcessedStatement(conn, stmt, generatedParams);
            rs = stmt.executeQuery();
            TableResourceManager rm = new TableResourceManager(conn, (Statement)stmt, true);
            List<ColumnDefinition> columnDefinitions = SQLDatasourceUtils.getColumnDefinitions(rs);
            if (loadSQLTableToMemory) {
                CachedRowSet cachedRowSet = RowSetProvider.newFactory().createCachedRowSet();
                cachedRowSet.populate(rs);
                rs = cachedRowSet;
                rm.gracefullyReleaseResources();
            } else {
                rm.addResultSet(rs);
            }
            context.setReturnValues(new BValue[]{this.constructTable(rm, context, rs, structType, columnDefinitions, datasource.getDatabaseProductName())});
        }
        catch (Throwable e) {
            SQLDatasourceUtils.cleanupResources(rs, stmt, conn, true);
            throw new BallerinaException("execute query failed: " + e.getMessage(), e);
        }
    }

    protected void executeUpdate(Context context, SQLDatasource datasource, String query, BValueArray parameters) {
        Connection conn = null;
        PreparedStatement stmt = null;
        boolean isInTransaction = context.isInTransaction();
        try {
            BValueArray generatedParams = this.constructParameters(context, parameters);
            conn = SQLDatasourceUtils.getDatabaseConnection(context, datasource, false);
            String processedQuery = this.createProcessedQueryString(query, generatedParams);
            stmt = conn.prepareStatement(processedQuery);
            this.createProcessedStatement(conn, stmt, generatedParams, datasource.getDatabaseProductName());
            int count = stmt.executeUpdate();
            context.setReturnValues(new BValue[]{new BInteger((long)count)});
            SQLDatasourceUtils.cleanupResources(stmt, conn, !isInTransaction);
        }
        catch (SQLException e) {
            try {
                throw new BallerinaException("execute update failed: " + e.getMessage(), (Throwable)e);
            }
            catch (Throwable throwable) {
                SQLDatasourceUtils.cleanupResources(stmt, conn, !isInTransaction);
                throw throwable;
            }
        }
    }

    protected void executeUpdateWithKeys(Context context, SQLDatasource datasource, String query, BValueArray keyColumns, BValueArray parameters) {
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        boolean isInTransaction = context.isInTransaction();
        try {
            BValueArray generatedParams = this.constructParameters(context, parameters);
            conn = SQLDatasourceUtils.getDatabaseConnection(context, datasource, false);
            String processedQuery = this.createProcessedQueryString(query, generatedParams);
            int keyColumnCount = 0;
            if (keyColumns != null) {
                keyColumnCount = (int)keyColumns.size();
            }
            if (keyColumnCount > 0) {
                String[] columnArray = new String[keyColumnCount];
                for (int i = 0; i < keyColumnCount; ++i) {
                    columnArray[i] = keyColumns.getString((long)i);
                }
                stmt = conn.prepareStatement(processedQuery, columnArray);
            } else {
                stmt = conn.prepareStatement(processedQuery, 1);
            }
            this.createProcessedStatement(conn, stmt, generatedParams);
            int count = stmt.executeUpdate();
            BInteger updatedCount = new BInteger((long)count);
            rs = stmt.getGeneratedKeys();
            BValueArray generatedKeys = rs.next() ? this.getGeneratedKeys(rs) : new BValueArray(BTypes.typeString);
            BValueArray tuple = new BValueArray((BType)executeUpdateWithKeysTupleType);
            tuple.add(0L, (BRefType)updatedCount);
            tuple.add(1L, (BRefType)generatedKeys);
            context.setReturnValues(new BValue[]{tuple});
            SQLDatasourceUtils.cleanupResources(rs, (Statement)stmt, conn, !isInTransaction);
        }
        catch (SQLException e) {
            try {
                throw new BallerinaException("execute update with generated keys failed: " + e.getMessage(), (Throwable)e);
            }
            catch (Throwable throwable) {
                SQLDatasourceUtils.cleanupResources(rs, stmt, conn, !isInTransaction);
                throw throwable;
            }
        }
    }

    protected void executeProcedure(Context context, SQLDatasource datasource, String query, BValueArray parameters, BValueArray structTypes) {
        Connection conn = null;
        CallableStatement stmt = null;
        List<ResultSet> resultSets = null;
        boolean isInTransaction = context.isInTransaction();
        try {
            boolean requiredToReturnTables;
            BValueArray generatedParams = this.constructParameters(context, parameters);
            conn = SQLDatasourceUtils.getDatabaseConnection(context, datasource, false);
            stmt = this.getPreparedCall(conn, datasource, query, generatedParams);
            this.createProcessedStatement(conn, stmt, generatedParams, datasource.getDatabaseProductName());
            boolean refCursorOutParamsPresent = generatedParams != null && this.isRefCursorOutParamPresent(generatedParams);
            boolean resultSetsReturned = false;
            TableResourceManager rm = null;
            boolean bl = requiredToReturnTables = structTypes != null && structTypes.size() > 0L;
            if (requiredToReturnTables) {
                resultSets = this.executeStoredProc(stmt, datasource.getDatabaseProductName());
                resultSetsReturned = !resultSets.isEmpty();
            } else {
                stmt.execute();
            }
            if (resultSetsReturned || refCursorOutParamsPresent) {
                rm = new TableResourceManager(conn, (Statement)stmt, !isInTransaction);
            }
            this.setOutParameters(context, stmt, parameters, rm);
            if (resultSetsReturned) {
                rm.addAllResultSets(resultSets);
                context.setReturnValues(new BValue[]{this.constructTablesForResultSets(resultSets, rm, context, structTypes, datasource.getDatabaseProductName())});
            } else if (!refCursorOutParamsPresent) {
                SQLDatasourceUtils.cleanupResources(resultSets, (Statement)stmt, conn, !isInTransaction);
                context.setReturnValues(new BValue[0]);
            }
        }
        catch (Throwable e) {
            SQLDatasourceUtils.cleanupResources(resultSets, stmt, conn, !isInTransaction);
            throw new BallerinaException("execute stored procedure failed: " + e.getMessage(), e);
        }
    }

    private BValueArray constructTablesForResultSets(List<ResultSet> resultSets, TableResourceManager rm, Context context, BValueArray structTypes, String databaseProductName) throws SQLException {
        BValueArray bTables = new BValueArray((BType)new BArrayType(BTypes.typeTable));
        if (databaseProductName.contains(MYSQL) && structTypes != null && structTypes.size() > 1L) {
            throw new BallerinaException("Retrieving result sets from stored procedures returning more than one result set, is not supported");
        }
        if (structTypes == null || (long)resultSets.size() != structTypes.size()) {
            throw new BallerinaException("Mismatching record type count: " + (structTypes == null ? 0L : structTypes.size()) + " and returned result set count: " + resultSets.size() + " from the stored procedure");
        }
        for (int i = 0; i < resultSets.size(); ++i) {
            bTables.add((long)i, (BRefType)this.constructTable(rm, context, resultSets.get(i), (BStructureType)structTypes.getRefValue((long)i).value(), databaseProductName));
        }
        return bTables;
    }

    /*
     * Loose catch block
     */
    protected void executeBatchUpdate(Context context, SQLDatasource datasource, String query, BValueArray parameters) throws SQLException {
        int[] updatedCount;
        Connection conn = null;
        PreparedStatement stmt = null;
        int paramArrayCount = 0;
        boolean isInTransaction = context.isInTransaction();
        try {
            conn = SQLDatasourceUtils.getDatabaseConnection(context, datasource, false);
            stmt = conn.prepareStatement(query);
            conn.setAutoCommit(false);
            if (parameters != null) {
                paramArrayCount = (int)parameters.size();
                if (paramArrayCount == 0) {
                    stmt.addBatch();
                }
                for (int index = 0; index < paramArrayCount; ++index) {
                    BValueArray params = (BValueArray)parameters.getRefValue((long)index);
                    BValueArray generatedParams = this.constructParameters(context, params);
                    this.createProcessedStatement(conn, stmt, generatedParams);
                    stmt.addBatch();
                }
            } else {
                stmt.addBatch();
            }
            updatedCount = stmt.executeBatch();
            if (!isInTransaction) {
                conn.commit();
            }
            SQLDatasourceUtils.cleanupResources(stmt, conn, !isInTransaction);
        }
        catch (BatchUpdateException e) {
            if (!isInTransaction) {
                conn.rollback();
            }
            updatedCount = e.getUpdateCounts();
            SQLDatasourceUtils.cleanupResources(stmt, conn, !isInTransaction);
        }
        catch (SQLException e2) {
            conn.rollback();
            throw new BallerinaException("execute batch update failed: " + e2.getMessage(), (Throwable)e2);
            {
                catch (Throwable throwable) {
                    SQLDatasourceUtils.cleanupResources(stmt, conn, !isInTransaction);
                    throw throwable;
                }
            }
        }
        long[] returnedCount = new long[paramArrayCount];
        Arrays.fill(returnedCount, -3L);
        BValueArray countArray = new BValueArray(returnedCount);
        if (updatedCount != null) {
            int iSize = updatedCount.length;
            for (int i = 0; i < iSize; ++i) {
                countArray.add((long)i, updatedCount[i]);
            }
        }
        context.setReturnValues(new BValue[]{countArray});
    }

    protected BStructureType getStructType(Context context, int index) {
        BStructureType structType = null;
        BTypeDescValue type = (BTypeDescValue)context.getNullableRefArgument(index);
        if (type != null) {
            structType = (BStructureType)type.value();
        }
        return structType;
    }

    protected void checkAndObserveSQLAction(Context context, SQLDatasource datasource, String query) {
        Optional observerContext = ObserveUtils.getObserverContextOfCurrentFrame((Context)context);
        observerContext.ifPresent(ctx -> {
            ctx.addTag("peer.address", datasource.getPeerAddress());
            ctx.addTag("db.instance", datasource.getDatabaseName());
            ctx.addTag("db.statement", query);
            ctx.addTag("db.type", "sql");
        });
    }

    protected void checkAndObserveSQLError(Context context, String message) {
        Optional observerContext = ObserveUtils.getObserverContextOfCurrentFrame((Context)context);
        observerContext.ifPresent(ctx -> {
            ctx.addProperty("error", (Object)Boolean.TRUE);
            ctx.addProperty("error_message", (Object)message);
        });
    }

    protected SQLDatasource retrieveDatasource(Context context) {
        BMap bConnector = (BMap)context.getRefArgument(0);
        return (SQLDatasource)bConnector.getNativeData("Client");
    }

    private BValueArray constructParameters(Context context, BValueArray parameters) {
        BValueArray parametersNew = new BValueArray();
        int paramCount = (int)parameters.size();
        for (int i = 0; i < paramCount; ++i) {
            BMap<String, BValue> paramStruct;
            BRefType typeValue = parameters.getRefValue((long)i);
            if (typeValue.getType().getTag() == 35 || typeValue.getType().getTag() == 12) {
                paramStruct = (BMap<String, BValue>)typeValue;
            } else {
                paramStruct = AbstractSQLAction.getSQLParameter(context);
                paramStruct.put((Object)"sqlType", (BValue)new BString(SQLDatasourceUtils.getSQLType(typeValue.getType())));
                paramStruct.put((Object)"value", (BValue)typeValue);
                paramStruct.put((Object)"direction", (BValue)new BString("IN"));
            }
            parametersNew.add((long)i, paramStruct);
        }
        return parametersNew;
    }

    private static BMap<String, BValue> getSQLParameter(Context context) {
        PackageInfo sqlPackageInfo = context.getProgramFile().getPackageInfo("ballerina/sql");
        StructureTypeInfo paramStructInfo = sqlPackageInfo.getStructInfo("Parameter");
        return new BMap((BType)paramStructInfo.getType());
    }

    private String createProcessedQueryString(String query, BValueArray parameters) {
        String currentQuery = query;
        if (parameters != null) {
            int start = 0;
            int paramCount = (int)parameters.size();
            for (int i = 0; i < paramCount; ++i) {
                BMap paramValue = (BMap)parameters.getRefValue((long)i);
                if (paramValue == null) continue;
                String sqlType = this.getSQLType((BMap<String, BValue>)paramValue);
                BValue value = paramValue.get((Object)"value");
                int count = value != null && value.getType().getTag() == 20 && ((BArrayType)value.getType()).getElementType().getTag() != 2 && !"ARRAY".equalsIgnoreCase(sqlType) ? (int)((BNewArray)value).size() : 1;
                Object[] vals = this.expandQuery(start, count, currentQuery);
                start = (Integer)vals[0];
                currentQuery = (String)vals[1];
            }
        }
        return currentQuery;
    }

    private Object[] expandQuery(int start, int count, String query) {
        StringBuilder result = new StringBuilder();
        int n = query.length();
        boolean doubleQuoteExists = false;
        boolean singleQuoteExists = false;
        int end = n;
        for (int i = start; i < n; ++i) {
            if (query.charAt(i) == '\'') {
                singleQuoteExists = !singleQuoteExists;
                continue;
            }
            if (query.charAt(i) == '\"') {
                doubleQuoteExists = !doubleQuoteExists;
                continue;
            }
            if (query.charAt(i) != '?' || doubleQuoteExists || singleQuoteExists) continue;
            result.append(query.substring(0, i));
            result.append(this.generateQuestionMarks(count));
            end = result.length() + 1;
            if (i + 1 >= n) break;
            result.append(query.substring(i + 1));
            break;
        }
        return new Object[]{end, result.toString()};
    }

    private String generateQuestionMarks(int n) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < n; ++i) {
            builder.append("?");
            if (i + 1 >= n) continue;
            builder.append(",");
        }
        return builder.toString();
    }

    protected void closeConnections(SQLDatasource datasource) {
        if (datasource != null) {
            datasource.closeConnectionPool();
        }
    }

    private PreparedStatement getPreparedStatement(Connection conn, SQLDatasource datasource, String query, boolean loadToMemory) throws SQLException {
        PreparedStatement stmt;
        boolean mysql = datasource.getDatabaseProductName().contains(MYSQL);
        if (mysql && !loadToMemory) {
            stmt = conn.prepareStatement(query, 1003, 1007);
            try {
                stmt.setFetchSize(Integer.MIN_VALUE);
            }
            catch (SQLException e) {
                stmt.close();
            }
        } else {
            stmt = conn.prepareStatement(query);
        }
        return stmt;
    }

    private CallableStatement getPreparedCall(Connection conn, SQLDatasource datasource, String query, BValueArray parameters) throws SQLException {
        CallableStatement stmt;
        boolean mysql = datasource.getDatabaseProductName().contains(MYSQL);
        if (mysql) {
            stmt = conn.prepareCall(query, 1003, 1007);
            if (parameters != null && !this.hasOutParams(parameters)) {
                stmt.setFetchSize(Integer.MIN_VALUE);
            }
        } else {
            stmt = conn.prepareCall(query);
        }
        return stmt;
    }

    private BValueArray getGeneratedKeys(ResultSet rs) throws SQLException {
        BValueArray generatedKeys = new BValueArray(BTypes.typeString);
        ResultSetMetaData metaData = rs.getMetaData();
        int columnCount = metaData.getColumnCount();
        for (int i = 1; i <= columnCount; ++i) {
            String value;
            int columnType = metaData.getColumnType(i);
            switch (columnType) {
                case -6: 
                case 4: 
                case 5: {
                    value = Integer.toString(rs.getInt(i));
                    break;
                }
                case 8: {
                    value = Double.toString(rs.getDouble(i));
                    break;
                }
                case 6: {
                    value = Float.toString(rs.getFloat(i));
                    break;
                }
                case -7: 
                case 16: {
                    value = Boolean.toString(rs.getBoolean(i));
                    break;
                }
                case 2: 
                case 3: {
                    BigDecimal bigDecimal = rs.getBigDecimal(i);
                    if (bigDecimal != null) {
                        value = bigDecimal.toPlainString();
                        break;
                    }
                    value = null;
                    break;
                }
                case -5: {
                    value = Long.toString(rs.getLong(i));
                    break;
                }
                default: {
                    value = rs.getString(i);
                }
            }
            generatedKeys.add((long)(i - 1), value);
        }
        return generatedKeys;
    }

    private void createProcessedStatement(Connection conn, PreparedStatement stmt, BValueArray param) {
        this.createProcessedStatement(conn, stmt, param, null);
    }

    private void createProcessedStatement(Connection conn, PreparedStatement stmt, BValueArray params, String databaseProductName) {
        if (params == null) {
            return;
        }
        int paramCount = (int)params.size();
        int currentOrdinal = 0;
        for (int index = 0; index < paramCount; ++index) {
            BMap paramStruct = (BMap)params.getRefValue((long)index);
            if (paramStruct != null) {
                String sqlType = this.getSQLType((BMap<String, BValue>)paramStruct);
                BValue value = paramStruct.get((Object)"value");
                int direction = this.getParameterDirection((BMap<String, BValue>)paramStruct);
                if (value != null && value.getType().getTag() == 20 && ((BArrayType)value.getType()).getElementType().getTag() != 2 && !"ARRAY".equalsIgnoreCase(sqlType)) {
                    int arrayLength = (int)((BNewArray)value).size();
                    int typeTagOfArrayElement = ((BArrayType)value.getType()).getElementType().getTag();
                    for (int i = 0; i < arrayLength; ++i) {
                        BInteger paramValue;
                        switch (typeTagOfArrayElement) {
                            case 1: {
                                paramValue = new BInteger(((BValueArray)value).getInt((long)i));
                                break;
                            }
                            case 2: {
                                paramValue = new BByte(((BValueArray)value).getByte((long)i));
                                break;
                            }
                            case 3: {
                                paramValue = new BFloat(((BValueArray)value).getFloat((long)i));
                                break;
                            }
                            case 5: {
                                paramValue = new BString(((BValueArray)value).getString((long)i));
                                break;
                            }
                            case 6: {
                                paramValue = new BBoolean(((BValueArray)value).getBoolean((long)i) > 0);
                                break;
                            }
                            case 20: {
                                BRefType array = ((BValueArray)value).getRefValue((long)i);
                                if (((BArrayType)array.getType()).getElementType().getTag() == 2) {
                                    paramValue = array;
                                    break;
                                }
                                throw new BallerinaException("unsupported array type for parameter index: " + index + ". Array element type being an array is supported only when the inner array element type is BYTE");
                            }
                            default: {
                                throw new BallerinaException("unsupported array type for parameter index " + index);
                            }
                        }
                        if ("REFCURSOR".equals(sqlType) || "BLOB".equals(sqlType)) {
                            this.setParameter(conn, stmt, sqlType, (BValue)paramValue, direction, currentOrdinal, databaseProductName);
                        } else {
                            this.setParameter(conn, stmt, sqlType, (BValue)paramValue, direction, currentOrdinal);
                        }
                        ++currentOrdinal;
                    }
                    continue;
                }
                if ("REFCURSOR".equals(sqlType) || "ARRAY".equals(sqlType) || "BLOB".equals(sqlType)) {
                    this.setParameter(conn, stmt, sqlType, value, direction, currentOrdinal, databaseProductName);
                } else {
                    this.setParameter(conn, stmt, sqlType, value, direction, currentOrdinal);
                }
                ++currentOrdinal;
                continue;
            }
            SQLDatasourceUtils.setNullObject(stmt, index);
            ++currentOrdinal;
        }
    }

    private void setParameter(Connection conn, PreparedStatement stmt, String sqlType, BValue value, int direction, int index) {
        this.setParameter(conn, stmt, sqlType, value, direction, index, null);
    }

    private void setParameter(Connection conn, PreparedStatement stmt, String sqlType, BValue value, int direction, int index, String databaseProductName) {
        if (sqlType == null || sqlType.isEmpty()) {
            SQLDatasourceUtils.setStringValue(stmt, value, index, direction, 12);
        } else {
            String sqlDataType;
            switch (sqlDataType = sqlType.toUpperCase(Locale.getDefault())) {
                case "SMALLINT": {
                    SQLDatasourceUtils.setSmallIntValue(stmt, value, index, direction, 5);
                    break;
                }
                case "VARCHAR": {
                    SQLDatasourceUtils.setStringValue(stmt, value, index, direction, 12);
                    break;
                }
                case "CHAR": {
                    SQLDatasourceUtils.setStringValue(stmt, value, index, direction, 1);
                    break;
                }
                case "LONGVARCHAR": {
                    SQLDatasourceUtils.setStringValue(stmt, value, index, direction, -1);
                    break;
                }
                case "NCHAR": {
                    SQLDatasourceUtils.setNStringValue(stmt, value, index, direction, -15);
                    break;
                }
                case "NVARCHAR": {
                    SQLDatasourceUtils.setNStringValue(stmt, value, index, direction, -9);
                    break;
                }
                case "LONGNVARCHAR": {
                    SQLDatasourceUtils.setNStringValue(stmt, value, index, direction, -16);
                    break;
                }
                case "DOUBLE": {
                    SQLDatasourceUtils.setDoubleValue(stmt, value, index, direction, 8);
                    break;
                }
                case "NUMERIC": {
                    SQLDatasourceUtils.setNumericValue(stmt, value, index, direction, 2);
                    break;
                }
                case "DECIMAL": {
                    SQLDatasourceUtils.setNumericValue(stmt, value, index, direction, 3);
                    break;
                }
                case "BIT": 
                case "BOOLEAN": {
                    SQLDatasourceUtils.setBooleanValue(stmt, value, index, direction, -7);
                    break;
                }
                case "TINYINT": {
                    SQLDatasourceUtils.setTinyIntValue(stmt, value, index, direction, -6);
                    break;
                }
                case "BIGINT": {
                    SQLDatasourceUtils.setBigIntValue(stmt, value, index, direction, -5);
                    break;
                }
                case "INTEGER": {
                    SQLDatasourceUtils.setIntValue(stmt, value, index, direction, 4);
                    break;
                }
                case "REAL": {
                    SQLDatasourceUtils.setRealValue(stmt, value, index, direction, 7);
                    break;
                }
                case "FLOAT": {
                    SQLDatasourceUtils.setRealValue(stmt, value, index, direction, 6);
                    break;
                }
                case "DATE": {
                    SQLDatasourceUtils.setDateValue(stmt, value, index, direction, 91);
                    break;
                }
                case "TIMESTAMP": 
                case "DATETIME": {
                    SQLDatasourceUtils.setTimeStampValue(stmt, value, index, direction, 93, this.utcCalendar);
                    break;
                }
                case "TIME": {
                    SQLDatasourceUtils.setTimeValue(stmt, value, index, direction, 92, this.utcCalendar);
                    break;
                }
                case "BINARY": {
                    SQLDatasourceUtils.setBinaryValue(stmt, value, index, direction, -2);
                    break;
                }
                case "BLOB": {
                    SQLDatasourceUtils.setBlobValue(stmt, value, index, direction, 2004);
                    break;
                }
                case "LONGVARBINARY": {
                    SQLDatasourceUtils.setBlobValue(stmt, value, index, direction, -4);
                    break;
                }
                case "VARBINARY": {
                    SQLDatasourceUtils.setBinaryValue(stmt, value, index, direction, -3);
                    break;
                }
                case "CLOB": {
                    SQLDatasourceUtils.setClobValue(stmt, value, index, direction, 2005);
                    break;
                }
                case "NCLOB": {
                    SQLDatasourceUtils.setNClobValue(stmt, value, index, direction, 2011);
                    break;
                }
                case "ARRAY": {
                    SQLDatasourceUtils.setArrayValue(conn, stmt, value, index, direction, 2003, databaseProductName);
                    break;
                }
                case "STRUCT": {
                    SQLDatasourceUtils.setUserDefinedValue(conn, stmt, value, index, direction, 2002);
                    break;
                }
                case "REFCURSOR": {
                    SQLDatasourceUtils.setRefCursorValue(stmt, index, direction, databaseProductName);
                    break;
                }
                default: {
                    throw new BallerinaException("unsupported datatype as parameter: " + sqlType + " index:" + index);
                }
            }
        }
    }

    private boolean isRefCursorOutParamPresent(BValueArray params) {
        boolean refCursorOutParamPresent = false;
        int paramCount = (int)params.size();
        for (int index = 0; index < paramCount; ++index) {
            BMap paramValue = (BMap)params.getRefValue((long)index);
            if (paramValue == null) continue;
            String sqlType = this.getSQLType((BMap<String, BValue>)paramValue);
            int direction = this.getParameterDirection((BMap<String, BValue>)paramValue);
            if (direction != 1 || !"REFCURSOR".equals(sqlType)) continue;
            refCursorOutParamPresent = true;
            break;
        }
        return refCursorOutParamPresent;
    }

    private void setOutParameters(Context context, CallableStatement stmt, BValueArray params, TableResourceManager rm) {
        if (params == null) {
            return;
        }
        int paramCount = (int)params.size();
        for (int index = 0; index < paramCount; ++index) {
            if (params.getRefValue((long)index).getType().getTag() != 35 && params.getRefValue((long)index).getType().getTag() != 12) continue;
            BMap paramValue = (BMap)params.getRefValue((long)index);
            if (paramValue != null) {
                String sqlType = this.getSQLType((BMap<String, BValue>)paramValue);
                int direction = this.getParameterDirection((BMap<String, BValue>)paramValue);
                if (direction != 2 && direction != 1) continue;
                this.setOutParameterValue(context, stmt, sqlType, index, (BMap<String, BValue>)paramValue, rm);
                continue;
            }
            throw new BallerinaException("out value cannot set for null parameter with index: " + index);
        }
    }

    private void setOutParameterValue(Context context, CallableStatement stmt, String sqlType, int index, BMap<String, BValue> paramValue, TableResourceManager resourceManager) {
        try {
            String sqlDataType;
            switch (sqlDataType = sqlType.toUpperCase(Locale.getDefault())) {
                case "INTEGER": {
                    int value = stmt.getInt(index + 1);
                    paramValue.put((Object)"value", (BValue)new BInteger((long)value));
                    break;
                }
                case "VARCHAR": {
                    String value = stmt.getString(index + 1);
                    paramValue.put((Object)"value", (BValue)new BString(value));
                    break;
                }
                case "NUMERIC": 
                case "DECIMAL": {
                    BigDecimal value = stmt.getBigDecimal(index + 1);
                    if (value == null) {
                        paramValue.put((Object)"value", (BValue)new BFloat(0.0));
                        break;
                    }
                    paramValue.put((Object)"value", (BValue)new BFloat(value.doubleValue()));
                    break;
                }
                case "BIT": 
                case "BOOLEAN": {
                    boolean value = stmt.getBoolean(index + 1);
                    paramValue.put((Object)"value", (BValue)new BBoolean(value));
                    break;
                }
                case "TINYINT": {
                    byte value = stmt.getByte(index + 1);
                    paramValue.put((Object)"value", (BValue)new BInteger((long)value));
                    break;
                }
                case "SMALLINT": {
                    short value = stmt.getShort(index + 1);
                    paramValue.put((Object)"value", (BValue)new BInteger((long)value));
                    break;
                }
                case "BIGINT": {
                    long value = stmt.getLong(index + 1);
                    paramValue.put((Object)"value", (BValue)new BInteger(value));
                    break;
                }
                case "REAL": 
                case "FLOAT": {
                    float value = stmt.getFloat(index + 1);
                    paramValue.put((Object)"value", (BValue)new BFloat((double)value));
                    break;
                }
                case "DOUBLE": {
                    double value = stmt.getDouble(index + 1);
                    paramValue.put((Object)"value", (BValue)new BFloat(value));
                    break;
                }
                case "CLOB": {
                    Clob value = stmt.getClob(index + 1);
                    paramValue.put((Object)"value", (BValue)new BString(SQLDatasourceUtils.getString(value)));
                    break;
                }
                case "BLOB": {
                    Blob value = stmt.getBlob(index + 1);
                    paramValue.put((Object)"value", (BValue)new BString(SQLDatasourceUtils.getString(value)));
                    break;
                }
                case "BINARY": {
                    byte[] value = stmt.getBytes(index + 1);
                    paramValue.put((Object)"value", (BValue)new BString(SQLDatasourceUtils.getString(value)));
                    break;
                }
                case "DATE": {
                    Date value = stmt.getDate(index + 1);
                    paramValue.put((Object)"value", (BValue)new BString(SQLDatasourceUtils.getString(value)));
                    break;
                }
                case "TIMESTAMP": 
                case "DATETIME": {
                    Timestamp value = stmt.getTimestamp(index + 1, this.utcCalendar);
                    paramValue.put((Object)"value", (BValue)new BString(SQLDatasourceUtils.getString(value)));
                    break;
                }
                case "TIME": {
                    Time value = stmt.getTime(index + 1, this.utcCalendar);
                    paramValue.put((Object)"value", (BValue)new BString(SQLDatasourceUtils.getString(value)));
                    break;
                }
                case "ARRAY": {
                    Array value = stmt.getArray(index + 1);
                    paramValue.put((Object)"value", (BValue)new BString(SQLDatasourceUtils.getString(value)));
                    break;
                }
                case "STRUCT": {
                    Object value = stmt.getObject(index + 1);
                    String stringValue = "";
                    if (value != null) {
                        stringValue = value instanceof Struct ? SQLDatasourceUtils.getString((Struct)value) : value.toString();
                    }
                    paramValue.put((Object)"value", (BValue)new BString(stringValue));
                    break;
                }
                case "REFCURSOR": {
                    ResultSet rs = (ResultSet)stmt.getObject(index + 1);
                    BStructureType structType = this.getStructType(paramValue);
                    if (structType != null) {
                        resourceManager.addResultSet(rs);
                        SQLDatasource datasource = this.retrieveDatasource(context);
                        paramValue.put((Object)"value", (BValue)this.constructTable(resourceManager, context, rs, this.getStructType(paramValue), datasource.getDatabaseProductName()));
                        break;
                    }
                    throw new BallerinaException("The Struct Type for the result set pointed by the Ref Cursor cannot be null");
                }
                default: {
                    throw new BallerinaException("unsupported datatype as out/inout parameter: " + sqlType + " index:" + index);
                }
            }
        }
        catch (SQLException e) {
            throw new BallerinaException("error in getting out parameter value: " + e.getMessage(), (Throwable)e);
        }
    }

    private boolean hasOutParams(BValueArray params) {
        int paramCount = (int)params.size();
        for (int index = 0; index < paramCount; ++index) {
            BMap paramValue = (BMap)params.getRefValue((long)index);
            int direction = this.getParameterDirection((BMap<String, BValue>)paramValue);
            if (direction != 1 && direction != 2) continue;
            return true;
        }
        return false;
    }

    private List<ResultSet> executeStoredProc(CallableStatement stmt, String databaseProductName) throws SQLException {
        boolean resultAndNoUpdateCount = stmt.execute();
        ArrayList<ResultSet> resultSets = new ArrayList<ResultSet>();
        while (true) {
            if (!resultAndNoUpdateCount) {
                int updateCount = stmt.getUpdateCount();
                if (updateCount == -1) {
                    break;
                }
            } else {
                ResultSet result = stmt.getResultSet();
                resultSets.add(result);
                if (databaseProductName.contains(MYSQL)) break;
            }
            try {
                resultAndNoUpdateCount = stmt.getMoreResults(2);
            }
            catch (SQLException e) {
                break;
            }
        }
        return resultSets;
    }

    private BTable constructTable(TableResourceManager rm, Context context, ResultSet rs, BStructureType structType, List<ColumnDefinition> columnDefinitions, String databaseProductName) {
        return new BCursorTable((DataIterator)new SQLDataIterator(rm, rs, this.utcCalendar, columnDefinitions, structType, TimeUtils.getTimeStructInfo((Context)context), TimeUtils.getTimeZoneStructInfo((Context)context), databaseProductName), structType);
    }

    private BTable constructTable(TableResourceManager rm, Context context, ResultSet rs, BStructureType structType, String databaseProductName) throws SQLException {
        List<ColumnDefinition> columnDefinitions = SQLDatasourceUtils.getColumnDefinitions(rs);
        return this.constructTable(rm, context, rs, structType, columnDefinitions, databaseProductName);
    }

    private String getSQLType(BMap<String, BValue> parameter) {
        String sqlType = "";
        BRefType refType = (BRefType)parameter.get((Object)"sqlType");
        if (refType != null) {
            sqlType = refType.stringValue();
        }
        return sqlType;
    }

    private BStructureType getStructType(BMap<String, BValue> parameter) {
        BTypeDescValue type = (BTypeDescValue)parameter.get((Object)"recordType");
        BStructureType structType = null;
        if (type != null) {
            structType = (BStructureType)type.value();
        }
        return structType;
    }

    private int getParameterDirection(BMap<String, BValue> parameter) {
        int direction = 0;
        BRefType dir = (BRefType)parameter.get((Object)"direction");
        if (dir != null) {
            String sqlType;
            switch (sqlType = dir.stringValue()) {
                case "OUT": {
                    direction = 1;
                    break;
                }
                case "INOUT": {
                    direction = 2;
                }
            }
        }
        return direction;
    }
}

