/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.database.sql.actions;

import org.ballerinalang.bre.Context;
import org.ballerinalang.database.sql.SQLDatasource;
import org.ballerinalang.database.sql.SQLDatasourceUtils;
import org.ballerinalang.database.sql.actions.AbstractSQLAction;
import org.ballerinalang.model.types.TypeKind;
import org.ballerinalang.model.values.BValue;
import org.ballerinalang.model.values.BValueArray;
import org.ballerinalang.natives.annotations.Argument;
import org.ballerinalang.natives.annotations.BallerinaFunction;
import org.ballerinalang.natives.annotations.ReturnType;

@BallerinaFunction(orgName="ballerina", packageName="sql", functionName="nativeCall", args={@Argument(name="sqlQuery", type=TypeKind.STRING), @Argument(name="recordType", type=TypeKind.TYPEDESC), @Argument(name="parameters", type=TypeKind.ARRAY, elementType=TypeKind.UNION, structType="Param")}, returnType={@ReturnType(type=TypeKind.TABLE), @ReturnType(type=TypeKind.RECORD, structType="error", structPackage="ballerina/builtin")})
public class Call
extends AbstractSQLAction {
    public void execute(Context context) {
        try {
            String query = context.getStringArgument(0);
            BValueArray structTypes = (BValueArray)context.getNullableRefArgument(1);
            BValueArray parameters = (BValueArray)context.getNullableRefArgument(2);
            SQLDatasource datasource = this.retrieveDatasource(context);
            this.checkAndObserveSQLAction(context, datasource, query);
            this.executeProcedure(context, datasource, query, parameters, structTypes);
        }
        catch (Throwable e) {
            context.setReturnValues(new BValue[]{SQLDatasourceUtils.getSQLConnectorError(context, e)});
            SQLDatasourceUtils.handleErrorOnTransaction(context);
            this.checkAndObserveSQLError(context, e.getMessage());
        }
    }
}

