/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.stdlib.task.actions;

import org.ballerinalang.jvm.BRuntime;
import org.ballerinalang.jvm.values.MapValue;
import org.ballerinalang.jvm.values.ObjectValue;
import org.ballerinalang.jvm.values.api.BString;
import org.ballerinalang.stdlib.task.exceptions.SchedulingException;
import org.ballerinalang.stdlib.task.impl.TaskServerConnectorImpl;
import org.ballerinalang.stdlib.task.objects.AbstractTask;
import org.ballerinalang.stdlib.task.objects.ServiceInformation;
import org.ballerinalang.stdlib.task.objects.Task;
import org.ballerinalang.stdlib.task.utils.TaskConstants;
import org.ballerinalang.stdlib.task.utils.Utils;

public class TaskActions {
    public static Object pause(ObjectValue taskListener) {
        Task task = (Task)taskListener.getNativeData("TaskObject");
        try {
            task.pause();
        }
        catch (SchedulingException e) {
            return Utils.createTaskError("SchedulerError", e.getMessage());
        }
        return null;
    }

    public static Object resume(ObjectValue taskListener) {
        Task task = (Task)taskListener.getNativeData("TaskObject");
        try {
            task.resume();
        }
        catch (SchedulingException e) {
            return Utils.createTaskError("SchedulerError", e.getMessage());
        }
        return null;
    }

    public static Object detach(ObjectValue taskListener, ObjectValue service) {
        try {
            Task task = (Task)taskListener.getNativeData("TaskObject");
            String serviceName = service.getType().getName();
            task.removeService(serviceName);
        }
        catch (Exception e) {
            return Utils.createTaskError("SchedulerError", e.getMessage());
        }
        return null;
    }

    public static Object start(ObjectValue taskListener) {
        Task task = (Task)taskListener.getNativeData("TaskObject");
        TaskServerConnectorImpl serverConnector = new TaskServerConnectorImpl(task);
        try {
            serverConnector.start();
        }
        catch (SchedulingException e) {
            return Utils.createTaskError(e.getMessage());
        }
        return null;
    }

    public static Object stop(ObjectValue taskListener) {
        Task task = (Task)taskListener.getNativeData("TaskObject");
        TaskServerConnectorImpl serverConnector = new TaskServerConnectorImpl(task);
        try {
            serverConnector.stop();
        }
        catch (SchedulingException e) {
            return Utils.createTaskError(e.getMessage());
        }
        return null;
    }

    public static Object attach(ObjectValue taskListener, ObjectValue service, Object ... attachments) {
        ServiceInformation serviceInformation = attachments == null ? new ServiceInformation(BRuntime.getCurrentRuntime(), service, new Object[0]) : new ServiceInformation(BRuntime.getCurrentRuntime(), service, attachments);
        try {
            Utils.validateService(serviceInformation);
        }
        catch (SchedulingException e) {
            return Utils.createTaskError(e.getMessage());
        }
        Task task = (Task)taskListener.getNativeData("TaskObject");
        task.addService(serviceInformation);
        return null;
    }

    public static Object init(ObjectValue taskListener) {
        MapValue configurations = taskListener.getMapValue(TaskConstants.MEMBER_LISTENER_CONFIGURATION);
        String configurationTypeName = configurations.getType().getName();
        try {
            AbstractTask task = "TimerConfiguration".equals(configurationTypeName) ? Utils.processTimer((MapValue<BString, Object>)configurations) : Utils.processAppointment((MapValue<BString, Object>)configurations);
            taskListener.addNativeData("TaskObject", (Object)task);
        }
        catch (SchedulingException e) {
            return Utils.createTaskError(e.getMessage());
        }
        return null;
    }
}

