/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.stdlib.task.objects;

import java.util.Properties;
import org.ballerinalang.stdlib.task.exceptions.SchedulingException;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.impl.StdSchedulerFactory;

public class TaskManager {
    private Scheduler scheduler;

    private TaskManager() {
    }

    public static TaskManager getInstance() {
        return TaskManagerHelper.INSTANCE;
    }

    public Scheduler getScheduler() throws SchedulingException {
        try {
            if (this.scheduler != null && this.scheduler.isStarted()) {
                return this.scheduler;
            }
            StdSchedulerFactory stdSchedulerFactory = new StdSchedulerFactory(this.createSchedulerProperties());
            this.scheduler = stdSchedulerFactory.getScheduler();
            this.scheduler.start();
        }
        catch (SchedulerException e) {
            throw new SchedulingException("Cannot start the Task Listener/Scheduler.", e);
        }
        return this.scheduler;
    }

    private Properties createSchedulerProperties() {
        Properties properties = new Properties();
        properties.setProperty("org.quartz.jobStore.misfireThreshold", "5000");
        properties.setProperty("org.quartz.threadPool.threadCount", "10");
        return properties;
    }

    private static class TaskManagerHelper {
        private static final TaskManager INSTANCE = new TaskManager();

        private TaskManagerHelper() {
        }
    }
}

