/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.stdlib.task.utils;

import java.util.Objects;
import org.ballerinalang.jvm.BallerinaErrors;
import org.ballerinalang.jvm.TypeChecker;
import org.ballerinalang.jvm.types.AttachedFunction;
import org.ballerinalang.jvm.types.BPackage;
import org.ballerinalang.jvm.types.BType;
import org.ballerinalang.jvm.types.BTypes;
import org.ballerinalang.jvm.values.ErrorValue;
import org.ballerinalang.jvm.values.MapValue;
import org.ballerinalang.jvm.values.api.BString;
import org.ballerinalang.stdlib.task.exceptions.SchedulingException;
import org.ballerinalang.stdlib.task.objects.Appointment;
import org.ballerinalang.stdlib.task.objects.ServiceInformation;
import org.ballerinalang.stdlib.task.objects.Timer;
import org.ballerinalang.stdlib.task.utils.TaskConstants;
import org.quartz.CronExpression;

public class Utils {
    private static final int VALID_RESOURCE_COUNT = 1;

    public static ErrorValue createTaskError(String message) {
        return Utils.createTaskError("ListenerError", message);
    }

    public static ErrorValue createTaskError(String reason, String message) {
        return BallerinaErrors.createDistinctError((String)reason, (BPackage)TaskConstants.TASK_PACKAGE_ID, (String)message);
    }

    public static String getCronExpressionFromAppointmentRecord(Object record) throws SchedulingException {
        String cronExpression;
        if ("AppointmentData".equals(TypeChecker.getType((Object)record).getName())) {
            cronExpression = Utils.buildCronExpression((MapValue<BString, Object>)((MapValue)record));
            if (!CronExpression.isValidExpression((String)cronExpression)) {
                throw new SchedulingException("AppointmentData \"" + record.toString() + "\" is invalid.");
            }
        } else {
            cronExpression = record.toString();
            if (!CronExpression.isValidExpression((String)cronExpression)) {
                throw new SchedulingException("Cron Expression \"" + cronExpression + "\" is invalid.");
            }
        }
        return cronExpression;
    }

    private static String buildCronExpression(MapValue<BString, Object> record) {
        String cronExpression = Utils.getStringFieldValue(record, TaskConstants.FIELD_SECONDS) + " " + Utils.getStringFieldValue(record, TaskConstants.FIELD_MINUTES) + " " + Utils.getStringFieldValue(record, TaskConstants.FIELD_HOURS) + " " + Utils.getStringFieldValue(record, TaskConstants.FIELD_DAYS_OF_MONTH) + " " + Utils.getStringFieldValue(record, TaskConstants.FIELD_MONTHS) + " " + Utils.getStringFieldValue(record, TaskConstants.FIELD_DAYS_OF_WEEK) + " " + Utils.getStringFieldValue(record, TaskConstants.FIELD_YEAR);
        return cronExpression.trim();
    }

    private static String getStringFieldValue(MapValue<BString, Object> record, BString fieldName) {
        if (TaskConstants.FIELD_DAYS_OF_MONTH.equals(fieldName) && Objects.isNull(record.get((Object)TaskConstants.FIELD_DAYS_OF_MONTH))) {
            return "?";
        }
        if (Objects.nonNull(record.get((Object)fieldName))) {
            return record.get((Object)fieldName).toString();
        }
        return "*";
    }

    public static void validateService(ServiceInformation serviceInformation) throws SchedulingException {
        AttachedFunction[] resources = serviceInformation.getService().getType().getAttachedFunctions();
        if (resources.length != 1) {
            throw new SchedulingException("Invalid number of resources found in service '" + serviceInformation.getServiceName() + "'. Task service should include only one resource.");
        }
        AttachedFunction resource = resources[0];
        if (!"onTrigger".equals(resource.getName())) {
            throw new SchedulingException("Invalid resource function found: " + resource.getName() + ". Expected: '" + "onTrigger" + "'.");
        }
        Utils.validateOnTriggerResource(resource.getReturnParameterType());
    }

    private static void validateOnTriggerResource(BType returnParameterType) throws SchedulingException {
        if (returnParameterType != BTypes.typeNull) {
            throw new SchedulingException("Invalid resource function signature: 'onTrigger' should not return a value.");
        }
    }

    public static Timer processTimer(MapValue<BString, Object> configurations) throws SchedulingException {
        Timer task;
        long interval = configurations.getIntValue(TaskConstants.FIELD_INTERVAL).intValue();
        long delay = configurations.getIntValue(TaskConstants.FIELD_DELAY).intValue();
        if (configurations.get((Object)TaskConstants.FIELD_NO_OF_RUNS) == null) {
            task = new Timer(delay, interval);
        } else {
            long noOfRuns = configurations.getIntValue(TaskConstants.FIELD_NO_OF_RUNS);
            task = new Timer(delay, interval, noOfRuns);
        }
        return task;
    }

    public static Appointment processAppointment(MapValue<BString, Object> configurations) throws SchedulingException {
        Appointment appointment;
        Object appointmentDetails = configurations.get((Object)TaskConstants.MEMBER_APPOINTMENT_DETAILS);
        String cronExpression = Utils.getCronExpressionFromAppointmentRecord(appointmentDetails);
        if (configurations.get((Object)TaskConstants.FIELD_NO_OF_RUNS) == null) {
            appointment = new Appointment(cronExpression);
        } else {
            long noOfRuns = configurations.getIntValue(TaskConstants.FIELD_NO_OF_RUNS);
            appointment = new Appointment(cronExpression, noOfRuns);
        }
        return appointment;
    }
}

