/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.stdlib.task.actions;

import io.ballerina.runtime.api.Environment;
import io.ballerina.runtime.api.Runtime;
import io.ballerina.runtime.api.values.BMap;
import io.ballerina.runtime.api.values.BObject;
import io.ballerina.runtime.api.values.BString;
import org.ballerinalang.stdlib.task.exceptions.SchedulingException;
import org.ballerinalang.stdlib.task.impl.TaskServerConnectorImpl;
import org.ballerinalang.stdlib.task.objects.AbstractTask;
import org.ballerinalang.stdlib.task.objects.ServiceInformation;
import org.ballerinalang.stdlib.task.objects.Task;
import org.ballerinalang.stdlib.task.utils.TaskConstants;
import org.ballerinalang.stdlib.task.utils.Utils;

public class TaskActions {
    public static Object pause(BObject taskListener) {
        Task task = (Task)taskListener.getNativeData("TaskObject");
        try {
            task.pause();
        }
        catch (SchedulingException e) {
            return Utils.createTaskError("SchedulerError", e.getMessage());
        }
        return null;
    }

    public static Object resume(BObject taskListener) {
        Task task = (Task)taskListener.getNativeData("TaskObject");
        try {
            task.resume();
        }
        catch (SchedulingException e) {
            return Utils.createTaskError("SchedulerError", e.getMessage());
        }
        return null;
    }

    public static Object detach(BObject taskListener, BObject service) {
        try {
            Task task = (Task)taskListener.getNativeData("TaskObject");
            String serviceName = service.getType().getName();
            task.removeService(serviceName);
        }
        catch (Exception e) {
            return Utils.createTaskError("SchedulerError", e.getMessage());
        }
        return null;
    }

    public static Object start(BObject taskListener) {
        Task task = (Task)taskListener.getNativeData("TaskObject");
        TaskServerConnectorImpl serverConnector = new TaskServerConnectorImpl(task);
        try {
            serverConnector.start();
        }
        catch (SchedulingException e) {
            return Utils.createTaskError(e.getMessage());
        }
        return null;
    }

    public static Object stop(BObject taskListener) {
        Task task = (Task)taskListener.getNativeData("TaskObject");
        TaskServerConnectorImpl serverConnector = new TaskServerConnectorImpl(task);
        try {
            serverConnector.stop();
        }
        catch (SchedulingException e) {
            return Utils.createTaskError(e.getMessage());
        }
        return null;
    }

    public static Object attach(Environment env, BObject taskListener, BObject service, Object ... attachments) {
        Runtime runtime = env.getRuntime();
        ServiceInformation serviceInformation = attachments == null ? new ServiceInformation(runtime, service, new Object[0]) : new ServiceInformation(runtime, service, attachments);
        try {
            Utils.validateService(serviceInformation);
        }
        catch (SchedulingException e) {
            return Utils.createTaskError(e.getMessage());
        }
        Task task = (Task)taskListener.getNativeData("TaskObject");
        task.addService(serviceInformation);
        return null;
    }

    public static Object init(BObject taskListener) {
        BMap configurations = taskListener.getMapValue(TaskConstants.MEMBER_LISTENER_CONFIGURATION);
        String configurationTypeName = configurations.getType().getName();
        try {
            AbstractTask task = "TimerConfiguration".equals(configurationTypeName) ? Utils.processTimer((BMap<BString, Object>)configurations) : Utils.processAppointment((BMap<BString, Object>)configurations);
            taskListener.addNativeData("TaskObject", (Object)task);
        }
        catch (SchedulingException e) {
            return Utils.createTaskError(e.getMessage());
        }
        return null;
    }
}

