/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.stdlib.task.objects;

import java.util.HashMap;
import java.util.Map;
import org.ballerinalang.stdlib.task.exceptions.SchedulingException;
import org.ballerinalang.stdlib.task.objects.ServiceInformation;
import org.ballerinalang.stdlib.task.objects.Task;
import org.ballerinalang.stdlib.task.objects.TaskManager;
import org.ballerinalang.stdlib.task.utils.TaskIdGenerator;
import org.quartz.JobDataMap;
import org.quartz.JobKey;
import org.quartz.SchedulerException;
import org.quartz.TriggerKey;

public abstract class AbstractTask
implements Task {
    protected String id;
    private TriggerKey triggerKey;
    private HashMap<String, ServiceInformation> serviceMap;
    Map<String, JobKey> quartzJobs = new HashMap<String, JobKey>();
    long maxRuns;

    AbstractTask() throws SchedulingException {
        this.id = TaskIdGenerator.generate();
        this.triggerKey = new TriggerKey(this.id);
        this.serviceMap = new HashMap();
        this.maxRuns = -1L;
    }

    AbstractTask(long maxRuns) throws SchedulingException {
        this.id = TaskIdGenerator.generate();
        this.triggerKey = new TriggerKey(this.id);
        this.validateMaxRuns(maxRuns);
        this.serviceMap = new HashMap();
        this.maxRuns = maxRuns;
    }

    @Override
    public void addService(ServiceInformation service) {
        this.serviceMap.put(service.getService().getType().getName(), service);
    }

    @Override
    public void removeService(String serviceName) {
        this.serviceMap.remove(serviceName);
    }

    @Override
    public HashMap<String, ServiceInformation> getServicesMap() {
        return this.serviceMap;
    }

    @Override
    public ServiceInformation getService(String serviceName) {
        return this.serviceMap.get(serviceName);
    }

    @Override
    public String getId() {
        return this.id;
    }

    JobDataMap getJobDataMapFromTask() {
        JobDataMap jobData = new JobDataMap();
        jobData.put("ballerina.task", (Object)this);
        return jobData;
    }

    private void validateMaxRuns(long maxRuns) throws SchedulingException {
        if (maxRuns < 1L) {
            throw new SchedulingException("Task noOfOccurrences should be a positive integer.");
        }
    }

    @Override
    public void stop() throws SchedulingException {
        try {
            TaskManager.getInstance().getScheduler().unscheduleJob(this.triggerKey);
        }
        catch (SchedulerException e) {
            throw new SchedulingException("Failed to stop the task.", e);
        }
    }

    @Override
    public void pause() throws SchedulingException {
        try {
            TaskManager.getInstance().getScheduler().pauseTrigger(this.triggerKey);
        }
        catch (SchedulerException e) {
            throw new SchedulingException("Cannot pause the task.", e);
        }
    }

    @Override
    public void resume() throws SchedulingException {
        try {
            TaskManager.getInstance().getScheduler().resumeTrigger(this.triggerKey);
        }
        catch (SchedulerException e) {
            throw new SchedulingException("Cannot resume the task.", e);
        }
    }
}

