/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.stdlib.task.objects;

import java.util.Date;
import org.ballerinalang.stdlib.task.exceptions.SchedulingException;
import org.ballerinalang.stdlib.task.objects.AbstractTask;
import org.ballerinalang.stdlib.task.objects.TaskManager;
import org.ballerinalang.stdlib.task.utils.TaskJob;
import org.quartz.Calendar;
import org.quartz.CronScheduleBuilder;
import org.quartz.CronTrigger;
import org.quartz.JobBuilder;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.ScheduleBuilder;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.quartz.TriggerUtils;
import org.quartz.impl.calendar.BaseCalendar;
import org.quartz.spi.OperableTrigger;

public class Appointment
extends AbstractTask {
    private String cronExpression;

    public Appointment(String cronExpression) throws SchedulingException {
        this.cronExpression = cronExpression;
    }

    public Appointment(String cronExpression, long maxRuns) throws SchedulingException {
        super(maxRuns);
        this.cronExpression = cronExpression;
    }

    private String getCronExpression() {
        return this.cronExpression;
    }

    private long getMaxRuns() {
        return this.maxRuns;
    }

    @Override
    public void start() throws SchedulingException {
        JobDataMap jobDataMap = this.getJobDataMapFromTask();
        try {
            this.scheduleAppointment(jobDataMap);
        }
        catch (SchedulerException e) {
            throw new SchedulingException("Failed to schedule Task.", e);
        }
    }

    private void scheduleAppointment(JobDataMap jobData) throws SchedulerException, SchedulingException {
        String triggerId = this.getId();
        JobDetail job = JobBuilder.newJob(TaskJob.class).usingJobData(jobData).withIdentity(triggerId).build();
        CronTrigger trigger = (CronTrigger)TriggerBuilder.newTrigger().withIdentity(triggerId).withSchedule((ScheduleBuilder)Appointment.buildCronScheduler(this.getCronExpression())).build();
        if (this.getMaxRuns() > 0L) {
            int repeatCount = (int)(this.getMaxRuns() - 1L);
            Date endDate = TriggerUtils.computeEndTimeToAllowParticularNumberOfFirings((OperableTrigger)((OperableTrigger)trigger), (Calendar)new BaseCalendar(java.util.Calendar.getInstance().getTimeZone()), (int)repeatCount);
            trigger = (CronTrigger)trigger.getTriggerBuilder().endAt(endDate).build();
        }
        TaskManager.getInstance().getScheduler().scheduleJob(job, (Trigger)trigger);
        this.quartzJobs.put(triggerId, job.getKey());
    }

    private static CronScheduleBuilder buildCronScheduler(String cronExpression) {
        return CronScheduleBuilder.cronSchedule((String)cronExpression).withMisfireHandlingInstructionDoNothing();
    }
}

