/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.stdlib.task.utils;

import io.ballerina.runtime.TypeChecker;
import io.ballerina.runtime.api.ErrorCreator;
import io.ballerina.runtime.api.Module;
import io.ballerina.runtime.api.PredefinedTypes;
import io.ballerina.runtime.api.StringUtils;
import io.ballerina.runtime.api.types.AttachedFunctionType;
import io.ballerina.runtime.api.types.Type;
import io.ballerina.runtime.api.values.BError;
import io.ballerina.runtime.api.values.BMap;
import io.ballerina.runtime.api.values.BString;
import java.util.Objects;
import org.ballerinalang.stdlib.task.exceptions.SchedulingException;
import org.ballerinalang.stdlib.task.objects.Appointment;
import org.ballerinalang.stdlib.task.objects.ServiceInformation;
import org.ballerinalang.stdlib.task.objects.Timer;
import org.ballerinalang.stdlib.task.utils.TaskConstants;
import org.quartz.CronExpression;

public class Utils {
    private static final int VALID_RESOURCE_COUNT = 1;

    public static BError createTaskError(String message) {
        return Utils.createTaskError("ListenerError", message);
    }

    public static BError createTaskError(String reason, String message) {
        return ErrorCreator.createDistinctError((String)reason, (Module)TaskConstants.TASK_PACKAGE_ID, (BString)StringUtils.fromString((String)message));
    }

    public static String getCronExpressionFromAppointmentRecord(Object record) throws SchedulingException {
        String cronExpression;
        if ("AppointmentData".equals(TypeChecker.getType((Object)record).getName())) {
            cronExpression = Utils.buildCronExpression((BMap<BString, Object>)((BMap)record));
            if (!CronExpression.isValidExpression((String)cronExpression)) {
                throw new SchedulingException("AppointmentData \"" + record.toString() + "\" is invalid.");
            }
        } else {
            cronExpression = record.toString();
            if (!CronExpression.isValidExpression((String)cronExpression)) {
                throw new SchedulingException("Cron Expression \"" + cronExpression + "\" is invalid.");
            }
        }
        return cronExpression;
    }

    private static String buildCronExpression(BMap<BString, Object> record) {
        String cronExpression = Utils.getStringFieldValue(record, TaskConstants.FIELD_SECONDS) + " " + Utils.getStringFieldValue(record, TaskConstants.FIELD_MINUTES) + " " + Utils.getStringFieldValue(record, TaskConstants.FIELD_HOURS) + " " + Utils.getStringFieldValue(record, TaskConstants.FIELD_DAYS_OF_MONTH) + " " + Utils.getStringFieldValue(record, TaskConstants.FIELD_MONTHS) + " " + Utils.getStringFieldValue(record, TaskConstants.FIELD_DAYS_OF_WEEK) + " " + Utils.getStringFieldValue(record, TaskConstants.FIELD_YEAR);
        return cronExpression.trim();
    }

    private static String getStringFieldValue(BMap<BString, Object> record, BString fieldName) {
        if (TaskConstants.FIELD_DAYS_OF_MONTH.equals(fieldName) && Objects.isNull(record.get((Object)TaskConstants.FIELD_DAYS_OF_MONTH))) {
            return "?";
        }
        if (Objects.nonNull(record.get((Object)fieldName))) {
            return record.get((Object)fieldName).toString();
        }
        return "*";
    }

    public static void validateService(ServiceInformation serviceInformation) throws SchedulingException {
        AttachedFunctionType[] resources = serviceInformation.getService().getType().getAttachedFunctions();
        if (resources.length != 1) {
            throw new SchedulingException("Invalid number of resources found in service '" + serviceInformation.getServiceName() + "'. Task service should include only one resource.");
        }
        AttachedFunctionType resource = resources[0];
        if (!"onTrigger".equals(resource.getName())) {
            throw new SchedulingException("Invalid resource function found: " + resource.getName() + ". Expected: 'onTrigger'.");
        }
        Utils.validateOnTriggerResource(resource.getReturnParameterType());
    }

    private static void validateOnTriggerResource(Type returnParameterType) throws SchedulingException {
        if (returnParameterType != PredefinedTypes.TYPE_NULL) {
            throw new SchedulingException("Invalid resource function signature: 'onTrigger' should not return a value.");
        }
    }

    public static Timer processTimer(BMap<BString, Object> configurations) throws SchedulingException {
        Timer task;
        long interval = configurations.getIntValue(TaskConstants.FIELD_INTERVAL).intValue();
        long delay = configurations.getIntValue(TaskConstants.FIELD_DELAY).intValue();
        if (configurations.get((Object)TaskConstants.FIELD_NO_OF_RUNS) == null) {
            task = new Timer(delay, interval);
        } else {
            long noOfRuns = configurations.getIntValue(TaskConstants.FIELD_NO_OF_RUNS);
            task = new Timer(delay, interval, noOfRuns);
        }
        return task;
    }

    public static Appointment processAppointment(BMap<BString, Object> configurations) throws SchedulingException {
        Appointment appointment;
        Object appointmentDetails = configurations.get((Object)TaskConstants.MEMBER_APPOINTMENT_DETAILS);
        String cronExpression = Utils.getCronExpressionFromAppointmentRecord(appointmentDetails);
        if (configurations.get((Object)TaskConstants.FIELD_NO_OF_RUNS) == null) {
            appointment = new Appointment(cronExpression);
        } else {
            long noOfRuns = configurations.getIntValue(TaskConstants.FIELD_NO_OF_RUNS);
            appointment = new Appointment(cronExpression, noOfRuns);
        }
        return appointment;
    }
}

