/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.tool.util;

import org.ballerinalang.tool.util.CompileResult;
import org.ballerinalang.util.diagnostic.Diagnostic;
import org.testng.Assert;

public class BAssertUtil {
    private static final String CARRIAGE_RETURN_CHAR = "\\r";
    private static final String EMPTY_STRING = "";

    public static void validateError(CompileResult result, int errorIndex, String expectedErrMsg, int expectedErrLine, int expectedErrCol) {
        Diagnostic diag = result.getDiagnostics()[errorIndex];
        Assert.assertEquals((Object)diag.getKind(), (Object)Diagnostic.Kind.ERROR, (String)"incorrect diagnostic type");
        Assert.assertEquals((String)diag.getMessage().replace(CARRIAGE_RETURN_CHAR, EMPTY_STRING), (String)expectedErrMsg.replace(CARRIAGE_RETURN_CHAR, EMPTY_STRING), (String)"incorrect error message:");
        Assert.assertEquals((int)diag.getPosition().getStartLine(), (int)expectedErrLine, (String)"incorrect line number:");
        Assert.assertEquals((int)diag.getPosition().getStartColumn(), (int)expectedErrCol, (String)"incorrect column position:");
    }

    public static void validateError(CompileResult result, int errorIndex, int expectedErrLine, int expectedErrCol) {
        Diagnostic diag = result.getDiagnostics()[errorIndex];
        Assert.assertEquals((Object)diag.getKind(), (Object)Diagnostic.Kind.ERROR, (String)"incorrect diagnostic type");
        Assert.assertEquals((int)diag.getPosition().getStartLine(), (int)expectedErrLine, (String)"incorrect line number:");
        Assert.assertEquals((int)diag.getPosition().getStartColumn(), (int)expectedErrCol, (String)"incorrect column position:");
    }

    public static void validateErrorMessageOnly(CompileResult result, int errorIndex, String expectedPartOfErrMsg) {
        Diagnostic diag = result.getDiagnostics()[errorIndex];
        Assert.assertEquals((Object)diag.getKind(), (Object)Diagnostic.Kind.ERROR, (String)"incorrect diagnostic type");
        Assert.assertTrue((boolean)diag.getMessage().contains(expectedPartOfErrMsg), (String)('\'' + expectedPartOfErrMsg + "' is not contained in error message '" + diag.getMessage() + '\''));
    }

    public static void validateErrorMessageOnly(CompileResult result, int errorIndex, String[] expectedPartsOfErrMsg) {
        Diagnostic diag = result.getDiagnostics()[errorIndex];
        Assert.assertEquals((Object)diag.getKind(), (Object)Diagnostic.Kind.ERROR, (String)"incorrect diagnostic type");
        boolean contains = false;
        for (String part : expectedPartsOfErrMsg) {
            if (!diag.getMessage().contains(part)) continue;
            contains = true;
            break;
        }
        Assert.assertTrue((boolean)contains, (String)("None of given strings is contained in the error message '" + diag.getMessage() + '\''));
    }

    public static void validateWarning(CompileResult result, int warningIndex, String expectedWarnMsg, int expectedWarnLine, int expectedWarnCol) {
        Diagnostic diag = result.getDiagnostics()[warningIndex];
        Assert.assertEquals((Object)diag.getKind(), (Object)Diagnostic.Kind.WARNING, (String)"incorrect diagnostic type");
        Assert.assertEquals((String)diag.getMessage(), (String)expectedWarnMsg, (String)"incorrect warning message:");
        Assert.assertEquals((int)diag.getPosition().getStartLine(), (int)expectedWarnLine, (String)"incorrect line number:");
        Assert.assertEquals((int)diag.getPosition().getStartColumn(), (int)expectedWarnCol, (String)"incorrect column position:");
    }
}

