/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.net.websub;

import io.netty.buffer.Unpooled;
import io.netty.handler.codec.http.DefaultLastHttpContent;
import io.netty.handler.codec.http.HttpContent;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.ballerinalang.bre.bvm.CallableUnitCallback;
import org.ballerinalang.bre.bvm.WorkerExecutionContext;
import org.ballerinalang.connector.api.BLangConnectorSPIUtil;
import org.ballerinalang.connector.api.BallerinaConnectorException;
import org.ballerinalang.connector.api.Executor;
import org.ballerinalang.connector.api.Resource;
import org.ballerinalang.connector.api.Value;
import org.ballerinalang.mime.util.MimeUtil;
import org.ballerinalang.model.values.BJSON;
import org.ballerinalang.model.values.BMap;
import org.ballerinalang.model.values.BRefType;
import org.ballerinalang.model.values.BString;
import org.ballerinalang.model.values.BStruct;
import org.ballerinalang.model.values.BValue;
import org.ballerinalang.net.http.BallerinaHTTPConnectorListener;
import org.ballerinalang.net.http.HTTPServicesRegistry;
import org.ballerinalang.net.http.HttpResource;
import org.ballerinalang.net.http.HttpUtil;
import org.ballerinalang.net.http.caching.RequestCacheControlStruct;
import org.ballerinalang.net.uri.URIUtil;
import org.ballerinalang.net.websub.WebSubDispatcher;
import org.ballerinalang.net.websub.WebSubEmptyCallableUnitCallback;
import org.ballerinalang.net.websub.WebSubServicesRegistry;
import org.ballerinalang.util.codegen.ProgramFile;
import org.ballerinalang.util.exceptions.BallerinaException;
import org.wso2.transport.http.netty.message.HTTPCarbonMessage;

public class BallerinaWebSubConnectionListener
extends BallerinaHTTPConnectorListener {
    private WebSubServicesRegistry webSubServicesRegistry;
    private PrintStream console = System.out;

    public BallerinaWebSubConnectionListener(WebSubServicesRegistry webSubServicesRegistry, Value[] filterHolders) {
        super((HTTPServicesRegistry)webSubServicesRegistry, filterHolders);
        this.webSubServicesRegistry = webSubServicesRegistry;
    }

    public void onMessage(HTTPCarbonMessage httpCarbonMessage) {
        try {
            if (this.accessed(httpCarbonMessage)) {
                HttpResource httpResource;
                if (httpCarbonMessage.getProperty("httpResource") instanceof String) {
                    if (httpCarbonMessage.getProperty("httpResource").equals("annotatedTopic")) {
                        this.autoRespondToIntentVerification(httpCarbonMessage);
                        return;
                    }
                    httpResource = WebSubDispatcher.findResource(this.webSubServicesRegistry, httpCarbonMessage);
                } else {
                    httpResource = (HttpResource)httpCarbonMessage.getProperty("httpResource");
                }
                this.extractPropertiesAndStartResourceExecution(httpCarbonMessage, httpResource);
                return;
            }
            HttpResource httpResource = WebSubDispatcher.findResource(this.webSubServicesRegistry, httpCarbonMessage);
            if (httpCarbonMessage.getProperty("httpResource") == null) {
                httpCarbonMessage.setProperty("httpResource", (Object)httpResource);
                return;
            }
            if (httpCarbonMessage.getProperty("httpResource") instanceof String) {
                return;
            }
            this.extractPropertiesAndStartResourceExecution(httpCarbonMessage, httpResource);
        }
        catch (BallerinaException ex) {
            HttpUtil.handleFailure((HTTPCarbonMessage)httpCarbonMessage, (BallerinaConnectorException)new BallerinaConnectorException(ex.getMessage(), ex.getCause()));
        }
    }

    protected void extractPropertiesAndStartResourceExecution(HTTPCarbonMessage httpCarbonMessage, HttpResource httpResource) {
        BStruct subscriberServiceEndpoint = this.getSubscriberServiceEndpoint(httpResource, httpCarbonMessage);
        Object httpRequest = httpCarbonMessage.getProperty("entityAccessedRequest") != null ? (BValue)httpCarbonMessage.getProperty("entityAccessedRequest") : this.getHttpRequest(httpResource, httpCarbonMessage);
        WorkerExecutionContext parentCtx = new WorkerExecutionContext(httpResource.getBalResource().getResourceInfo().getServiceInfo().getPackageInfo().getProgramFile());
        this.invokeRequestFilters(httpCarbonMessage, (BValue)httpRequest, this.getRequestFilterContext(httpResource), parentCtx);
        Resource balResource = httpResource.getBalResource();
        List paramDetails = balResource.getParamDetails();
        BValue[] signatureParams = new BValue[paramDetails.size()];
        String resourceName = httpResource.getName();
        if ("onIntentVerification".equals(resourceName)) {
            signatureParams[0] = subscriberServiceEndpoint;
            BStruct intentVerificationRequestStruct = this.createIntentVerificationRequestStruct(balResource);
            if (httpCarbonMessage.getProperty("QUERY_STR") != null) {
                String queryString = (String)httpCarbonMessage.getProperty("QUERY_STR");
                BMap params = new BMap();
                try {
                    URIUtil.populateQueryParamMap((String)queryString, (BMap)params);
                    intentVerificationRequestStruct.setStringField(0, ((BString)params.get((Object)"hub.mode")).stringValue());
                    intentVerificationRequestStruct.setStringField(1, ((BString)params.get((Object)"hub.topic")).stringValue());
                    intentVerificationRequestStruct.setStringField(2, ((BString)params.get((Object)"hub.challenge")).stringValue());
                    intentVerificationRequestStruct.setIntField(0, (long)Integer.parseInt(((BString)params.get((Object)"hub.lease_seconds")).stringValue()));
                }
                catch (UnsupportedEncodingException e) {
                    throw new BallerinaException("Error populating query map for intent verification request received: " + e.getMessage());
                }
            }
            intentVerificationRequestStruct.setRefField(0, (BRefType)httpRequest);
            signatureParams[1] = intentVerificationRequestStruct;
        } else {
            HTTPCarbonMessage response = HttpUtil.createHttpCarbonMessage((boolean)false);
            response.waitAndReleaseAllEntities();
            response.setProperty("HTTP_STATUS_CODE", (Object)202);
            response.addHttpContent((HttpContent)new DefaultLastHttpContent());
            HttpUtil.sendOutboundResponse((HTTPCarbonMessage)httpCarbonMessage, (HTTPCarbonMessage)response);
            BStruct notificationRequestStruct = this.createNotificationRequestStruct(balResource);
            BStruct entityStruct = MimeUtil.extractEntity((BStruct)((BStruct)httpRequest));
            if (entityStruct != null) {
                if (entityStruct.getNativeData("message_datasource") instanceof BJSON) {
                    BJSON jsonBody = (BJSON)entityStruct.getNativeData("message_datasource");
                    notificationRequestStruct.setRefField(0, (BRefType)jsonBody);
                } else {
                    this.console.println("ballerina: Non-JSON payload received as WebSub Notification");
                }
            }
            notificationRequestStruct.setRefField(1, (BRefType)httpRequest);
            signatureParams[0] = notificationRequestStruct;
        }
        WebSubEmptyCallableUnitCallback callback = new WebSubEmptyCallableUnitCallback();
        Executor.submit((Resource)balResource, (CallableUnitCallback)callback, null, null, (BValue[])signatureParams);
    }

    private BStruct getSubscriberServiceEndpoint(HttpResource httpResource, HTTPCarbonMessage httpCarbonMessage) {
        BStruct subscriberServiceEndpoint = this.createSubscriberServiceEndpointStruct(httpResource.getBalResource());
        BStruct serviceEndpoint = BLangConnectorSPIUtil.createBStruct((ProgramFile)httpResource.getBalResource().getResourceInfo().getServiceInfo().getPackageInfo().getProgramFile(), (String)"ballerina.http", (String)"Listener", (Object[])new Object[0]);
        BStruct connection = BLangConnectorSPIUtil.createBStruct((ProgramFile)httpResource.getBalResource().getResourceInfo().getServiceInfo().getPackageInfo().getProgramFile(), (String)"ballerina.http", (String)"Connection", (Object[])new Object[0]);
        HttpUtil.enrichServiceEndpointInfo((BStruct)serviceEndpoint, (HTTPCarbonMessage)httpCarbonMessage, (HttpResource)httpResource);
        HttpUtil.enrichConnectionInfo((BStruct)connection, (HTTPCarbonMessage)httpCarbonMessage);
        serviceEndpoint.setRefField(0, (BRefType)connection);
        subscriberServiceEndpoint.setRefField(1, (BRefType)serviceEndpoint);
        return subscriberServiceEndpoint;
    }

    private BStruct getHttpRequest(HttpResource httpResource, HTTPCarbonMessage httpCarbonMessage) {
        BStruct httpRequest = this.createBStruct(httpResource.getBalResource().getResourceInfo().getServiceInfo().getPackageInfo().getProgramFile(), "ballerina.http", "Request");
        BStruct inRequestEntity = this.createBStruct(httpResource.getBalResource().getResourceInfo().getServiceInfo().getPackageInfo().getProgramFile(), "ballerina.mime", "Entity");
        BStruct mediaType = this.createBStruct(httpResource.getBalResource().getResourceInfo().getServiceInfo().getPackageInfo().getProgramFile(), "ballerina.mime", "MediaType");
        BStruct cacheControlStruct = this.createBStruct(httpResource.getBalResource().getResourceInfo().getServiceInfo().getPackageInfo().getProgramFile(), "ballerina.http", "RequestCacheControl");
        RequestCacheControlStruct requestCacheControl = new RequestCacheControlStruct(cacheControlStruct);
        HttpUtil.populateInboundRequest((BStruct)httpRequest, (BStruct)inRequestEntity, (BStruct)mediaType, (HTTPCarbonMessage)httpCarbonMessage, (RequestCacheControlStruct)requestCacheControl);
        return httpRequest;
    }

    private BStruct createSubscriberServiceEndpointStruct(Resource resource) {
        return this.createBStruct(resource.getResourceInfo().getServiceInfo().getPackageInfo().getProgramFile(), "ballerina.websub", "Listener");
    }

    private BStruct createIntentVerificationRequestStruct(Resource resource) {
        return this.createBStruct(resource.getResourceInfo().getServiceInfo().getPackageInfo().getProgramFile(), "ballerina.websub", "IntentVerificationRequest");
    }

    private BStruct createNotificationRequestStruct(Resource resource) {
        return this.createBStruct(resource.getResourceInfo().getServiceInfo().getPackageInfo().getProgramFile(), "ballerina.websub", "NotificationRequest");
    }

    private BStruct createBStruct(ProgramFile programFile, String packagePath, String structName) {
        return BLangConnectorSPIUtil.createBStruct((ProgramFile)programFile, (String)packagePath, (String)structName, (Object[])new Object[0]);
    }

    private void autoRespondToIntentVerification(HTTPCarbonMessage httpCarbonMessage) {
        String annotatedTopic = httpCarbonMessage.getProperty("annotatedTopic").toString();
        if (httpCarbonMessage.getProperty("QUERY_STR") != null) {
            String queryString = (String)httpCarbonMessage.getProperty("QUERY_STR");
            BMap params = new BMap();
            try {
                HTTPCarbonMessage response = HttpUtil.createHttpCarbonMessage((boolean)false);
                response.waitAndReleaseAllEntities();
                URIUtil.populateQueryParamMap((String)queryString, (BMap)params);
                String mode = ((BString)params.get((Object)"hub.mode")).stringValue();
                if (("subscribe".equals(mode) || "unsubscribe".equals(mode)) && annotatedTopic.equals(((BString)params.get((Object)"hub.topic")).stringValue())) {
                    String challenge = ((BString)params.get((Object)"hub.challenge")).stringValue();
                    response.addHttpContent((HttpContent)new DefaultLastHttpContent(Unpooled.wrappedBuffer((byte[])challenge.getBytes(StandardCharsets.UTF_8))));
                    response.setProperty("HTTP_STATUS_CODE", (Object)202);
                    this.console.println("ballerina: Intent Verification agreed - Mode [" + mode + "], Topic [" + annotatedTopic + "], Lease Seconds [" + params.get((Object)"hub.lease_seconds") + "]");
                } else {
                    this.console.println("ballerina: Intent Verification denied - Mode [" + mode + "], Topic [" + annotatedTopic + "]");
                    response.setProperty("HTTP_STATUS_CODE", (Object)404);
                    response.addHttpContent((HttpContent)new DefaultLastHttpContent());
                }
                HttpUtil.sendOutboundResponse((HTTPCarbonMessage)httpCarbonMessage, (HTTPCarbonMessage)response);
            }
            catch (UnsupportedEncodingException e) {
                throw new BallerinaConnectorException("Error responding to intent verification request: " + e.getMessage());
            }
        }
    }
}

