/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.net.websub;

import org.ballerinalang.connector.api.BallerinaConnectorException;
import org.ballerinalang.net.http.HTTPServicesRegistry;
import org.ballerinalang.net.http.HttpDispatcher;
import org.ballerinalang.net.http.HttpResource;
import org.ballerinalang.net.http.HttpService;
import org.ballerinalang.net.websub.WebSubResourceDispatcher;
import org.ballerinalang.net.websub.WebSubServicesRegistry;
import org.wso2.transport.http.netty.message.HTTPCarbonMessage;

class WebSubDispatcher
extends HttpDispatcher {
    WebSubDispatcher() {
    }

    static HttpResource findResource(WebSubServicesRegistry servicesRegistry, HTTPCarbonMessage httpCarbonMessage) {
        HttpResource resource = null;
        String protocol = (String)httpCarbonMessage.getProperty("PROTOCOL");
        if (protocol == null) {
            throw new BallerinaConnectorException("protocol not defined in the incoming request");
        }
        try {
            HttpService service = HttpDispatcher.findService((HTTPServicesRegistry)servicesRegistry, (HTTPCarbonMessage)httpCarbonMessage);
            if (service == null) {
                throw new BallerinaConnectorException("no service found to handle the service request");
            }
            resource = WebSubResourceDispatcher.findResource(service, httpCarbonMessage, servicesRegistry);
        }
        catch (Throwable throwable) {
            WebSubDispatcher.handleError((HTTPCarbonMessage)httpCarbonMessage, (Throwable)throwable);
        }
        return resource;
    }
}

