/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.net.websub;

import java.util.ArrayList;
import org.ballerinalang.connector.api.Annotation;
import org.ballerinalang.connector.api.Resource;
import org.ballerinalang.connector.api.Service;
import org.ballerinalang.connector.api.Struct;
import org.ballerinalang.net.http.HttpResource;
import org.ballerinalang.net.http.HttpService;
import org.ballerinalang.net.uri.DispatcherUtil;
import org.ballerinalang.net.websub.WebSubHttpResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebSubHttpService
extends HttpService {
    private static final Logger logger = LoggerFactory.getLogger(WebSubHttpService.class);
    private String topic;

    protected WebSubHttpService(Service service) {
        super(service);
    }

    private static Annotation getWebSubSubscriberServiceConfigAnnotation(Service service) {
        return WebSubHttpService.getServiceConfigAnnotation((Service)service, (String)"ballerina.websub", (String)"SubscriberServiceConfig");
    }

    static WebSubHttpService buildWebSubSubscriberHttpService(Service service) {
        WebSubHttpService websubHttpService = new WebSubHttpService(service);
        Annotation serviceConfigAnnotation = WebSubHttpService.getWebSubSubscriberServiceConfigAnnotation(service);
        if (serviceConfigAnnotation == null) {
            logger.debug("ServiceConfig not specified in the Service instance, using default base path");
            websubHttpService.setBasePath("/".concat(websubHttpService.getName()));
            return websubHttpService;
        }
        Struct serviceConfig = serviceConfigAnnotation.getValue();
        websubHttpService.setBasePath(serviceConfig.getStringField("path"));
        ArrayList<HttpResource> resources = new ArrayList<HttpResource>();
        for (Resource resource : websubHttpService.getBallerinaService().getResources()) {
            HttpResource httpResource = WebSubHttpResource.buildWebSubHttpResource(resource, websubHttpService);
            resources.add(httpResource);
        }
        websubHttpService.setResources(resources);
        websubHttpService.setAllAllowedMethods(DispatcherUtil.getAllResourceMethods((HttpService)websubHttpService));
        return websubHttpService;
    }

    public String getTopic() {
        return this.topic;
    }

    public void setTopic(String topic) {
        this.topic = topic;
    }
}

